import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownHubunganEvent {}

class GetDataDropdownHubungan extends DropdownHubunganEvent {}

class SelectDataDropdownHubungan extends DropdownHubunganEvent {
  JenisData selectedValue;
  SelectDataDropdownHubungan(this.selectedValue);
}

abstract class DropdownHubunganState {}

class DropdownHubunganProgressState extends DropdownHubunganState {}

class DropdownHubunganSuccessState extends DropdownHubunganState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;

  DropdownHubunganSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownHubunganErrorState extends DropdownHubunganState {}

class DropdownHubunganBloc extends Bloc<DropdownHubunganEvent, DropdownHubunganState> {
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  DropdownHubunganBloc(DropdownHubunganState? initialState) : super(initialState!);


  @override
  Stream<DropdownHubunganState> mapEventToState(DropdownHubunganEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownHubungan) {
      yield DropdownHubunganProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisHubungan();
      if (dropdownRespon!.data != null)
        yield DropdownHubunganSuccessState(dropdownRespon!, null);
      else
        yield DropdownHubunganErrorState();
    } else if (event is SelectDataDropdownHubungan) {
      selectedValue = event.selectedValue;
      yield DropdownHubunganSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
