import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownAsalLulusanEvent {}

class GetDataDropdownAsalLulusan extends DropdownAsalLulusanEvent {}

class SelectDataDropdownAsalLulusan extends DropdownAsalLulusanEvent {
  JenisData selectedValue;
  SelectDataDropdownAsalLulusan(this.selectedValue);
}

abstract class DropdownAsalLulusanState {}

class DropdownAsalLulusanProgressState extends DropdownAsalLulusanState {}

class DropdownAsalLulusanSuccessState extends DropdownAsalLulusanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownAsalLulusanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownAsalLulusanErrorState extends DropdownAsalLulusanState {}

class DropdownAsalLulusanBloc extends Bloc<DropdownAsalLulusanEvent, DropdownAsalLulusanState> {
  DropdownAsalLulusanBloc(DropdownAsalLulusanState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownAsalLulusanState> mapEventToState(DropdownAsalLulusanEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownAsalLulusan) {
      yield DropdownAsalLulusanProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisAsalLulusan();
      if (dropdownRespon!.data != null)
        yield DropdownAsalLulusanSuccessState(dropdownRespon!, null);
      else
        yield DropdownAsalLulusanErrorState();
    } else if (event is SelectDataDropdownAsalLulusan) {
      selectedValue = event.selectedValue!;
      yield DropdownAsalLulusanSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
