import 'package:absenkuv3/Repository/Model/Cuti/mDataCuti.dart';
import 'package:absenkuv3/Repository/Model/Cuti/mDataPeriodeCuti.dart';
import 'package:absenkuv3/Repository/Service/cutiApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class GetDataPeriodeCutiEvent {}

class GetDataPeriodeCuti extends GetDataPeriodeCutiEvent {
  String? idKaryawan;
  GetDataPeriodeCuti(this.idKaryawan);
}

abstract class GetDataPeriodeCutiState {}

class GetDataPeriodeCutiProggres extends GetDataPeriodeCutiState {}

class GetDataPeriodeCutiSuccessState extends GetDataPeriodeCutiState {
  ResponPeriodeCuti respon;
  GetDataPeriodeCutiSuccessState(this.respon);
}

class GetDataPeriodeCutiError extends GetDataPeriodeCutiState {}

class GetDataPeriodeCutiBloc
    extends Bloc<GetDataPeriodeCutiEvent, GetDataPeriodeCutiState> {
  GetDataPeriodeCutiBloc(GetDataPeriodeCutiState initialState) : super(initialState);

  @override
  Stream<GetDataPeriodeCutiState> mapEventToState(
      GetDataPeriodeCutiEvent event) async* {
    if (event is GetDataPeriodeCuti) {
      yield GetDataPeriodeCutiProggres();
      ResponPeriodeCuti respon =
          await CutiApi().getDataPeriodeCuti(event.idKaryawan);
      if (respon.success!)
        yield GetDataPeriodeCutiSuccessState(respon);
      else
        yield GetDataPeriodeCutiError();
    }
  }
}
