import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Service/badgeApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgeShiftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class BadgeShiftState {}

class GetBadgeShift extends BadgeShiftEvent {
  GetBadgeShift(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class GetSuccess extends BadgeShiftState {
  JumlahBadge? dataDashboard;
  GetSuccess(this.dataDashboard) {}
}

class GetProgress extends BadgeShiftState {}

class GetFailed extends BadgeShiftState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetFailed(this.message, this.scaffoldKey) {
  }
}

class BadgeShiftBloc extends Bloc<BadgeShiftEvent, BadgeShiftState> {
  BadgeShiftBloc(BadgeShiftState initialState) : super(initialState);

  @override
  Stream<BadgeShiftState> mapEventToState(BadgeShiftEvent event) async* {
    if (event is GetBadgeShift) {
      yield GetProgress();
      JumlahBadge dashboardRespon = await BadgeApi().badgeShift();
      if (dashboardRespon.success!)
        yield GetSuccess(dashboardRespon);
      else
        yield GetFailed(dashboardRespon.message, event.scaffoldKey);
    }
  }
}
