import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

abstract class StatusPengajuanDataEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getStatusPengajuanDataEvent extends StatusPengajuanDataEvent{
  getStatusPengajuanDataEvent(BuildContext _context){
    context = _context;
  }
}

class getStatusPengajuanDataSuccessState extends StatusPengajuanDataState{
  getStatusPengajuanDataSuccessState(StatusPengajuanDataEvent _event, StatusPengajuanDataRespon? _data){
    listStatusPengajuanData = _data;
  }
}

abstract class StatusPengajuanDataState{
  StatusPengajuanDataRespon? listStatusPengajuanData;
}


class StatusPengajuanDataProgressState extends StatusPengajuanDataState{}

class StatusPengajuanDataErrorState extends StatusPengajuanDataState{}

class StatusPengajuanDataBloc extends Bloc<StatusPengajuanDataEvent, StatusPengajuanDataState>{
  final dateFormat = new DateFormat('yyyy-MM');
  StatusPengajuanDataState? initialState;
  StatusPengajuanDataRespon? listStatusPengajuanData;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;
  StatusPengajuanDataBloc(StatusPengajuanDataState initialState) : super(initialState);

  @override
  Stream<StatusPengajuanDataState> mapEventToState(StatusPengajuanDataEvent event) async*{
    // TODO: implement mapEventToState
    if(event is getStatusPengajuanDataEvent){
      offset = 0;
      yield StatusPengajuanDataProgressState();
      StatusPengajuanDataRespon statusPengajuanDataRespon = await NotifikasiAkunApi().getStatusPengajuan();
      if(statusPengajuanDataRespon != null){
        yield getStatusPengajuanDataSuccessState(event, statusPengajuanDataRespon);
      }
      else yield StatusPengajuanDataErrorState();
    }
  }
}