import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/PengalamanKerja/mPengalamanKerja.dart';
import 'package:absenkuv3/Repository/Model/Akun/PengalamanKerja/mPengalamanKerjaById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/Akun/dataPengalamanKerjaApi.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DataPengalamanKerjaEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? id;
}

class getDataPengalamanKerjaTerverifikasiEvent extends DataPengalamanKerjaEvent{
  getDataPengalamanKerjaTerverifikasiEvent(BuildContext _context){
    context = _context;
  }
}

class getDataPengalamanKerjaPengajuanEvent extends DataPengalamanKerjaEvent{
  getDataPengalamanKerjaPengajuanEvent(BuildContext _context){
    context = _context;
  }
}

class getDetailDataPengalamanKerjaByIdEvent extends DataPengalamanKerjaEvent{
  DataNotifikasiAkun? dataNotifikasiAkun;
  getDetailDataPengalamanKerjaByIdEvent(BuildContext _context, DataNotifikasiAkun _data){
    context = _context;
    dataNotifikasiAkun = _data;
  }
}

class getDataPengalamanKerjaPengajuanByIdEvent extends DataPengalamanKerjaEvent{
  String? konteks;
  getDataPengalamanKerjaPengajuanByIdEvent(BuildContext _context, _idPengalamanKerja, String _konteks){
    context = _context;
    id = _idPengalamanKerja;
    konteks = _konteks;
  }
}

class deleteDataPengalamanKerjaEvent extends DataPengalamanKerjaEvent{
  deleteDataPengalamanKerjaEvent(BuildContext _context, _idPengalamanKerja){
    context = _context;
    id = _idPengalamanKerja;
  }
}

class deletePengajuanDataPengalamanKerjaEvent extends DataPengalamanKerjaEvent{
  deletePengajuanDataPengalamanKerjaEvent(BuildContext _context, _idPengalamanKerja){
    context = _context;
    id = _idPengalamanKerja;
  }
}

abstract class DataPengalamanKerjaState{
  List<DataDatapengalamankerja>? data;
  List<DataDatapengalamankerjaById>? dataById;
}

class getDataPengalamanKerjaSuccessState extends DataPengalamanKerjaState{
  getDataPengalamanKerjaSuccessState(DataPengalamanKerjaEvent _event, List<DataDatapengalamankerja> _data){
    data = _data;
  }
}

class getDataPengalamanKerjaByIdSuccessState extends DataPengalamanKerjaState{
  getDataPengalamanKerjaByIdSuccessState(DataPengalamanKerjaEvent _event, List<DataDatapengalamankerjaById> _data){
    dataById = _data;
  }
}

class PengajuanTambahDataPengalamanKerjaEvent extends DataPengalamanKerjaEvent {
  DataDatapengalamankerja? data;
  List<MultiImagePickerModel>? listImage;
  PengajuanTambahDataPengalamanKerjaEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatapengalamankerja _data, List<MultiImagePickerModel>? _file) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImage = _file;
  }
}

class EditPengajuanDataPengamalanKerjaEvent extends DataPengalamanKerjaEvent {
  DataDatapengalamankerja? data;
  List<MultiImagePickerModel>? listImage;
  EditPengajuanDataPengamalanKerjaEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatapengalamankerja _data, List<MultiImagePickerModel>? _file) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImage = _file;
  }
}

class EditDataPengalamanKerjaEvent extends DataPengalamanKerjaEvent {
  DataDatapengalamankerja? data;
  List<MultiImagePickerModel>? listImage;
  EditDataPengalamanKerjaEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatapengalamankerja _data, List<MultiImagePickerModel>? _file) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImage = _file;
  }
}

class DataPengalamanKerjaProgressState extends DataPengalamanKerjaState{}

class DataPengalamanKerjaErrorState extends DataPengalamanKerjaState{}

class DataPengalamanKerjaBloc extends Bloc<DataPengalamanKerjaEvent, DataPengalamanKerjaState>{
  final dateFormat = new DateFormat('yyyy-MM');
  List<DataDatapengalamankerja>? dataDataPengalamanKerja;
  ModelFilter? modelFilter;
  bool dismissible = false;
  int offset = 0;
  int limit = ServerInfo.limit;
  DataPengalamanKerjaBloc(DataPengalamanKerjaState initialState) : super(initialState);

  @override
  Stream<DataPengalamanKerjaState> mapEventToState(DataPengalamanKerjaEvent event) async*{
    if(event is getDataPengalamanKerjaTerverifikasiEvent){
      offset = 0;
      yield DataPengalamanKerjaProgressState();
      DataPengalamanKerjaRespon data = await DataPengalamanKerjaApi().getDataPengalamanKerjaTerferifikasi();
      if(data.success!){
        dataDataPengalamanKerja = data.dataDatapengalamankerja!;
        yield getDataPengalamanKerjaSuccessState(event, dataDataPengalamanKerja!);
      }
      else yield DataPengalamanKerjaErrorState();
    }
    else if(event is getDataPengalamanKerjaPengajuanEvent){
      offset = 0;
      yield DataPengalamanKerjaProgressState();
      DataPengalamanKerjaRespon data = await DataPengalamanKerjaApi().getDataPengalamanKerjaPengajuan();
      if(data.success!){
        dataDataPengalamanKerja = data.dataDatapengalamankerja!;
        yield getDataPengalamanKerjaSuccessState(event, dataDataPengalamanKerja!);
      }
      else yield DataPengalamanKerjaErrorState();
    }
    else if(event is getDataPengalamanKerjaPengajuanByIdEvent){
      offset = 0;
      yield DataPengalamanKerjaProgressState();
      DataPengalamanKerjaByIdRespon data = await DataPengalamanKerjaApi().getDataPengalamanKerjaPengajuanById(event.id, event.konteks);
      if(data.success!){
        yield getDataPengalamanKerjaByIdSuccessState(event, data.dataDatapengalamankerjaById!);
      }
      else yield DataPengalamanKerjaErrorState();
    }
    else if(event is PengajuanTambahDataPengalamanKerjaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPengalamanKerjaApi().pengajuanTambahDataPengalamanKerja(event.data!, event.listImage);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPengalamanKerja(event.context!, 1));
        });
      }
    }
    else if(event is EditPengajuanDataPengamalanKerjaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPengalamanKerjaApi().editPengajuanDataPengalamanKerja(event.data!, event.listImage);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPengalamanKerja(event.context!, 1));
        });
      }
    }
    else if(event is EditDataPengalamanKerjaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPengalamanKerjaApi().editDataPengalamanKerja(event.data!, event.listImage);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPengalamanKerja(event.context!, 1));
        });
      }
    }
    else if(event is deleteDataPengalamanKerjaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPengalamanKerjaApi().deleteDataPengalamanKerja(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPengalamanKerja(event.context!, 1));
        });
      }
    }
    else if(event is deletePengajuanDataPengalamanKerjaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPengalamanKerjaApi().deletePengajuanDataPengalamanKerja(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        StatusPengajuanDataRespon statusPengajuanDataRespon = await NotifikasiAkunApi().getStatusPengajuan();
        Future.delayed(Duration(milliseconds: 1000)).then((value) {
          if(statusPengajuanDataRespon.statusDataKeluarga == false){
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPengalamanKerja(event.context!, 0));
          }else{
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPengalamanKerja(event.context!, 1));
          }
        });
      }
    }
    else if(event is getDetailDataPengalamanKerjaByIdEvent){
      offset = 0;
      yield DataPengalamanKerjaProgressState();
      DataPengalamanKerjaRespon data = await DataPengalamanKerjaApi().getDetailDataPengalamanKerjaById(event.dataNotifikasiAkun!);
      if(data.success!){
        yield getDataPengalamanKerjaSuccessState(event, data.dataDatapengalamankerja!);
      }
      else yield DataPengalamanKerjaErrorState();
    }
  }
}