import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

abstract class NotifikasiAkunEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getNotifikasiAkunEvent extends NotifikasiAkunEvent{
  getNotifikasiAkunEvent(BuildContext _context){
    context = _context;
  }
}

class getBadgeAkunEvent extends NotifikasiAkunEvent{
  getBadgeAkunEvent(BuildContext _context){
    context = _context;
  }
}

class getNotifikasiAkunSuccessState extends NotifikasiAkunState{
  getNotifikasiAkunSuccessState(NotifikasiAkunEvent _event, List<DataNotifikasiAkun>? _data){
    listNotifikasiAkun = _data;
  }
}

class getBadgeAkunSuccessState extends NotifikasiAkunState{
  JumlahBadge? dataBadge;
  getBadgeAkunSuccessState(NotifikasiAkunEvent _event, JumlahBadge? _data){
    dataBadge = _data;
  }
}

class loadMoreEvent extends NotifikasiAkunEvent {
  ScrollController? scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

class LoadMoreProgressState extends NotifikasiAkunState {
  LoadMoreProgressState(List<DataNotifikasiAkun> _data) {
    listNotifikasiAkun = _data;
  }
}

abstract class NotifikasiAkunState{
  List<DataNotifikasiAkun>? listNotifikasiAkun;
}


class NotifikasiAkunProgressState extends NotifikasiAkunState{}

class NotifikasiAkunErrorState extends NotifikasiAkunState{}

class NotifikasiAkunBloc extends Bloc<NotifikasiAkunEvent, NotifikasiAkunState>{
  final dateFormat = new DateFormat('yyyy-MM');
  NotifikasiAkunState? initialState;
  List<DataNotifikasiAkun>? listDataNotifikasiAkun;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;
  NotifikasiAkunBloc(NotifikasiAkunState initialState) : super(initialState);

  @override
  Stream<NotifikasiAkunState> mapEventToState(NotifikasiAkunEvent event) async*{
    // TODO: implement mapEventToState
    if(event is getNotifikasiAkunEvent){
      offset = 0;
      yield NotifikasiAkunProgressState();
      NotifikasiAkunRespon notifikasiAkunRespon = await NotifikasiAkunApi().getDataNotifikasiAkun(offset);
      if(notifikasiAkunRespon.success!){
        listDataNotifikasiAkun = notifikasiAkunRespon.dataNotifikasiAkun;
        yield getNotifikasiAkunSuccessState(event, listDataNotifikasiAkun);
      }
      else yield getNotifikasiAkunSuccessState(event, null);
    }else if (event is loadMoreEvent) {
      if (event.scrollController!.offset >= event.scrollController!.position.maxScrollExtent && !event.scrollController!.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listDataNotifikasiAkun!);
        NotifikasiAkunRespon notifikasiAkunRespon = await NotifikasiAkunApi().getDataNotifikasiAkun(offset);
        if (notifikasiAkunRespon.success!) {
          listDataNotifikasiAkun!.addAll(notifikasiAkunRespon.dataNotifikasiAkun!);
        }
        yield getNotifikasiAkunSuccessState(event, listDataNotifikasiAkun!);
      }
    }else if(event is getBadgeAkunEvent){
      JumlahBadge badgeAkun = await NotifikasiAkunApi().getBadgeAkun();
      if (badgeAkun.success!) {
        yield getBadgeAkunSuccessState(event, badgeAkun);
      }else{
        yield getBadgeAkunSuccessState(event, JumlahBadge(success: false, message: "Data tidak ditemukan", data: 0));
      }
    }
  }
}