import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataPendidikan/mDataPendidikan.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataPendidikan/mDataPendidikanById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/Akun/dataPendidikanApi.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel2.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DataPendidikanEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? id;
}

class getDataPendidikanTerverifikasiEvent extends DataPendidikanEvent{
  getDataPendidikanTerverifikasiEvent(BuildContext _context){
    context = _context;
  }
}

class getDataPendidikanPengajuanEvent extends DataPendidikanEvent{
  getDataPendidikanPengajuanEvent(BuildContext _context){
    context = _context;
  }
}

class getDataPendidikanPengajuanByIdEvent extends DataPendidikanEvent{
  String? konteks;
  getDataPendidikanPengajuanByIdEvent(BuildContext _context, _idPendidikan, String _konteks){
    context = _context;
    id = _idPendidikan;
    konteks = _konteks;
  }
}

class deleteDataPendidikanEvent extends DataPendidikanEvent{
  deleteDataPendidikanEvent(BuildContext _context, _idPendidikan){
    context = _context;
    id = _idPendidikan;
  }
}

class deletePengajuanDataPendidikanEvent extends DataPendidikanEvent{
  deletePengajuanDataPendidikanEvent(BuildContext _context, _idPendidikan){
    context = _context;
    id = _idPendidikan;
  }
}

abstract class DataPendidikanState{
  List<DataDatapendidikan>? data;
  List<DataDatapendidikanById>? dataById;
}

class getDataPendidikanSuccessState extends DataPendidikanState{
  getDataPendidikanSuccessState(DataPendidikanEvent _event, List<DataDatapendidikan> _data){
    data = _data;
  }
}

class getDataPendidikanByIdSuccessState extends DataPendidikanState{
  getDataPendidikanByIdSuccessState(DataPendidikanEvent _event, List<DataDatapendidikanById> _data){
    dataById = _data;
  }
}

class PengajuanTambahDataPendidikanEvent extends DataPendidikanEvent {
  DataDatapendidikan? data;
  List<MultiImagePickerModel>? listImageIjazah;
  List<MultiImagePickerModel2>? listImageTranskrip;
  PengajuanTambahDataPendidikanEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatapendidikan _data, List<MultiImagePickerModel>? _ijazah, List<MultiImagePickerModel2>? _transkrip) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImageIjazah = _ijazah;
    listImageTranskrip = _transkrip;
  }
}

class EditPengajuanDataPendidikanEvent extends DataPendidikanEvent {
  DataDatapendidikan? data;
  List<MultiImagePickerModel>? listImageIjazah;
  List<MultiImagePickerModel2>? listImageTranskrip;
  EditPengajuanDataPendidikanEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatapendidikan _data, List<MultiImagePickerModel>? _ijazah, List<MultiImagePickerModel2>? _transkrip) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImageIjazah = _ijazah;
    listImageTranskrip = _transkrip;
  }
}

class EditDataPendidikanEvent extends DataPendidikanEvent {
  DataDatapendidikan? data;
  List<MultiImagePickerModel>? listImageIjazah;
  List<MultiImagePickerModel2>? listImageTranskrip;
  EditDataPendidikanEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatapendidikan _data, List<MultiImagePickerModel>? _ijazah, List<MultiImagePickerModel2>? _transkrip) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImageIjazah = _ijazah;
    listImageTranskrip = _transkrip;
  }
}

class getDetailDataPendidikanByIdEvent extends DataPendidikanEvent{
  DataNotifikasiAkun? dataNotifikasiAkun;
  getDetailDataPendidikanByIdEvent(BuildContext _context, DataNotifikasiAkun _data){
    context = _context;
    dataNotifikasiAkun = _data;
  }
}

class DataPendidikanProgressState extends DataPendidikanState{}

class DataPendidikanErrorState extends DataPendidikanState{}

class DataPendidikanBloc extends Bloc<DataPendidikanEvent, DataPendidikanState>{
  final dateFormat = new DateFormat('yyyy-MM');
  List<DataDatapendidikan>? dataDataPendidikan;
  ModelFilter? modelFilter;
  bool dismissible = false;
  int offset = 0;
  int limit = ServerInfo.limit;
  DataPendidikanBloc(DataPendidikanState initialState) : super(initialState);

  @override
  Stream<DataPendidikanState> mapEventToState(DataPendidikanEvent event) async*{
    if(event is getDataPendidikanTerverifikasiEvent){
      offset = 0;
      yield DataPendidikanProgressState();
      DataPendidikanRespon data = await DataPendidikanApi().getDataPendidikanTerferifikasi();
      if(data.success!){
        dataDataPendidikan = data.dataDatapendidikan!;
        yield getDataPendidikanSuccessState(event, dataDataPendidikan!);
      }
      else yield DataPendidikanErrorState();
    }
    else if(event is getDataPendidikanPengajuanEvent){
      offset = 0;
      yield DataPendidikanProgressState();
      DataPendidikanRespon data = await DataPendidikanApi().getDataPendidikanPengajuan();
      if(data.success!){
        dataDataPendidikan = data.dataDatapendidikan!;
        yield getDataPendidikanSuccessState(event, dataDataPendidikan!);
      }
      else yield DataPendidikanErrorState();
    }
    else if(event is getDataPendidikanPengajuanByIdEvent){
      offset = 0;
      yield DataPendidikanProgressState();
      DataPendidikanByIdRespon data = await DataPendidikanApi().getDataPendidikanPengajuanById(event.id, event.konteks);
      if(data.success!){
        yield getDataPendidikanByIdSuccessState(event, data.dataDatapendidikan!);
      }
      else yield DataPendidikanErrorState();
    }
    else if(event is PengajuanTambahDataPendidikanEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon = await DataPendidikanApi().pengajuanTambahDataPendidikan(event.data!, event.listImageIjazah, event.listImageTranskrip);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPendidikan(event.context!, 1));
        });
      }
    }
    else if(event is EditPengajuanDataPendidikanEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPendidikanApi().editPengajuanDataPendidikan(event.data!, event.listImageIjazah, event.listImageTranskrip);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPendidikan(event.context!, 1));
        });
      }
    }
    else if(event is EditDataPendidikanEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPendidikanApi().editDataPendidikan(event.data!, event.listImageIjazah, event.listImageTranskrip);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPendidikan(event.context!, 1));
        });
      }
    }
    else if(event is deleteDataPendidikanEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPendidikanApi().deleteDataPendidikan(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPendidikan(event.context!, 1));
        });
      }
    }
    else if(event is deletePengajuanDataPendidikanEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataPendidikanApi().deletePengajuanDataPendidikan(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        StatusPengajuanDataRespon statusPengajuanDataRespon = await NotifikasiAkunApi().getStatusPengajuan();
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          if(statusPengajuanDataRespon.statusDataKeluarga == false){
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPendidikan(event.context!, 0));
          }else{
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataPendidikan(event.context!, 1));
          }
        });
      }
    }
    else if(event is getDetailDataPendidikanByIdEvent){
      offset = 0;
      yield DataPendidikanProgressState();
      DataPendidikanRespon data = await DataPendidikanApi().getDetailDataPendidikanById(event.dataNotifikasiAkun!);
      if(data.success!){
        yield getDataPendidikanSuccessState(event, data.dataDatapendidikan!);
      }
      else yield DataPendidikanErrorState();
    }
  }
}