import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/View/mDataDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/View/mDataEditDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/Akun/dataDiriApi.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DataDiriEditEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class DataDiriEditState{
  DataDatadiriEdit? data;
}

class getDataDiriEditEvent extends DataDiriEditEvent{
  getDataDiriEditEvent(BuildContext _context){
    context = _context;
  }
}

class getDataPengajuanDataDiriEditEvent extends DataDiriEditEvent{
  getDataPengajuanDataDiriEditEvent(BuildContext _context){
    context = _context;
  }
}

class pengajuanEditDataDiriEvent extends DataDiriEditEvent{
  DataDatadiri? data;
  pengajuanEditDataDiriEvent(BuildContext _context,GlobalKey<ScaffoldState> _scaffoldKey, DataDatadiri _data){
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
  }
}

class EditPengajuanDataDiriEvent extends DataDiriEditEvent{
  DataDatadiri? data;
  EditPengajuanDataDiriEvent(BuildContext _context,GlobalKey<ScaffoldState> _scaffoldKey, DataDatadiri _data){
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
  }
}

class deletePengajuanDataDiriEvent extends DataDiriEditEvent{
  deletePengajuanDataDiriEvent(BuildContext _context){
    context = _context;
  }
}

class getDataDiriEditSuccessState extends DataDiriEditState{
  getDataDiriEditSuccessState(DataDiriEditEvent _event, DataDatadiriEdit _data){
    data = _data;
  }
}

class DataDiriEditProgressState extends DataDiriEditState{}

class DataDiriEditErrorState extends DataDiriEditState{}

class DataDiriEditBloc extends Bloc<DataDiriEditEvent, DataDiriEditState>{
  final dateFormat = new DateFormat('yyyy-MM');
  DataDatadiriEdit? dataDatadiriEdit;
  ModelFilter? modelFilter;
  bool dismissible = false;
  int offset = 0;
  int limit = ServerInfo.limit;
  DataDiriEditBloc(DataDiriEditState initialState) : super(initialState);

  @override
  Stream<DataDiriEditState> mapEventToState(DataDiriEditEvent event) async*{
    if(event is getDataDiriEditEvent){
      offset = 0;
      yield DataDiriEditProgressState();
      DataEditDataDiriRespon dataDiriEditRespon = await DataDiriApi().getDataEditDataDiri();
      if(dataDiriEditRespon.success!){
        dataDatadiriEdit = dataDiriEditRespon.dataDatadiriEdit;
        yield getDataDiriEditSuccessState(event, dataDatadiriEdit!);
      }
      else yield DataDiriEditErrorState();
    }
    if(event is getDataPengajuanDataDiriEditEvent){
      offset = 0;
      yield DataDiriEditProgressState();
      DataEditDataDiriRespon dataDiriEditRespon = await DataDiriApi().getDataPengajuanEditDataDiri();
      if(dataDiriEditRespon.success!){
        dataDatadiriEdit = dataDiriEditRespon.dataDatadiriEdit;
        yield getDataDiriEditSuccessState(event, dataDatadiriEdit!);
      }
      else yield DataDiriEditErrorState();
    }
    else if(event is pengajuanEditDataDiriEvent){
        ProgressDialog pd = ProgressDialog(context: event.context);
        ProgressDialogDelayed.show(pd, isDismissible: dismissible);
        BasicRespon basicRespon = await DataDiriApi().pengajuanPerubahanDataDiri(event.data!);
        // print("data response ${basicRespon.success}");
        ProgressDialogDelayed.hide(pd);
        if(!basicRespon.success!){
          showSnackBarDelayedWithColors(event.scaffoldKey, basicRespon.message, event.context);
        }else{
          showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);
        }
        if (basicRespon.success!) {
          Future.delayed(Duration(milliseconds: 2000)).then((value) {
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigatePop(event.context));
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToHalamanDataDiri(event.context!, 1));
          });
        }
    }
    else if(event is EditPengajuanDataDiriEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataDiriApi().EditPengajuanPerubahanDataDiri(event.data!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          // BlocProvider.of<NavigatorBloc>(event.context!)
          //     .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToHalamanDataDiri(event.context!, 1));
        });
      }
    }

    else if(event is deletePengajuanDataDiriEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dismissible);
      BasicRespon basicRespon = await DataDiriApi().deletePengajuanDataDiri();
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        StatusPengajuanDataRespon statusPengajuanDataRespon = await NotifikasiAkunApi().getStatusPengajuan();
        Future.delayed(Duration(milliseconds: 1000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          if(statusPengajuanDataRespon.statusPengajuanDataDiri == false){
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToHalamanDataDiri(event.context!, 0));
          }else{
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToHalamanDataDiri(event.context!, 1));
          }
        });
      }
    }
    // else if(event is getPengajuanDataDiriEvent){
    //   offset = 0;
    //   yield DataDiriProgressState();
    //   DataDiriRespon dataDiriRespon = await DataDiriApi().getPengajuanDataDiri();
    //   if(dataDiriRespon.success!){
    //     dataDiri = dataDiriRespon.data;
    //     yield getDataDiriSuccessState(event, dataDiri!);
    //   }
    //   else yield DataDiriErrorState();
    // }
    // else if(event is PengajuanEvent){
    //   ProgressDialog pd = ProgressDialog(context: event.context);
    //   ProgressDialogDelayed.show(pd, isDismissible: false);
    //
    //   BasicRespon basicRespon = await DataDiriApi().pengajuanPerubahanDataDiri(
    //     DataDiri(
    //       nik: event.nik, namaLengkap: event.namaLengkap, gelarDepan: event.gelarDepan, gelarBelakang: event.gelarBelakang,
    //       golonganDarah: JenisData(nama: event.golonganDarah), agama: JenisData(nama: event.agama), jenisKelamin: JenisData(nama: event.jenisKelamin),
    //       tempatLahir: event.tempatLahir, tglLahir: event.tglLahir, alamatDomisili: event.alamatDomisili, rt: event.rt, rw: event.rw,
    //       kelurahan: JenisData(nama: event.kelurahan), kecamatan: JenisData(nama: event.kecamatan), kabupaten: JenisData(nama: event.kabupaten),
    //       provinsi: JenisData(nama: event.provinsi), kodePos: event.kodePos, telepon: event.telepon, email: event.email, pendidikanTerakhir: JenisData(nama: event.pendidikanTerakhir),
    //       noKtp: event.noKTP, noBPJSKes: event.noBPJSKes, noBPJSTk: event.noBPJSTk, noAsuransi: event.noAsuransi));
    //
    //   ProgressDialogDelayed.hide(pd);
    //   showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);
    //
    //   if (basicRespon.success!) {
    //     Future.delayed(Duration(milliseconds: 2000)).then((value) {
    //       BlocProvider.of<NavigatorBloc>(event.context!)
    //           .add(NavigatePop(event.context));
    //       BlocProvider.of<NavigatorBloc>(event.context!)
    //           .add(NavigatePop(event.context));
    //       // BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToHalamanDataDiri(event.context, 1));
    //     });
    //   }
    // }
  }
}