import 'package:absenkuv3/Repository/Model/mEditAktivitas.dart';
import 'package:absenkuv3/Repository/Service/aktivitasApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class EditAktivitasEvent {}

class GetEditAktivitas extends EditAktivitasEvent {
  String? id;
  GetEditAktivitas(this.id);
}

abstract class EditAktivitasState {}

class EditAktivitasProgress extends EditAktivitasState {}

class EditAktivitasSuccess extends EditAktivitasState {
  EditAktivitas aktivitasRespon;
  EditAktivitasSuccess(this.aktivitasRespon);
}

class EditAktivitasError extends EditAktivitasState {}

class EditAktivitasBloc extends Bloc<EditAktivitasEvent, EditAktivitasState> {
  EditAktivitasBloc(EditAktivitasState initialState) : super(initialState);

  @override
  Stream<EditAktivitasState> mapEventToState(EditAktivitasEvent event) async* {
    if (event is GetEditAktivitas) {
      yield EditAktivitasProgress();
      EditAktivitas aktivitasRespon =
          await ActivitasApi().getEditAktivitas(event.id);
      if (aktivitasRespon.success!)
        yield EditAktivitasSuccess(aktivitasRespon);
      else
        yield EditAktivitasError();
    }
  }
}
