import 'dart:async';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Service/absensiApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

abstract class DataAbsensiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListDataAbsensiEvent extends DataAbsensiEvent{
  ModelFilter? modelFilter;
  getListDataAbsensiEvent(BuildContext _context, this.modelFilter,){
    context = _context;
  }
}
class getListDataAbsensiSayaEvent extends DataAbsensiEvent{
  ModelFilter? modelFilter;
  getListDataAbsensiSayaEvent(BuildContext _context, this.modelFilter,){
    context = _context;
  }
}

class loadMoreEvent extends DataAbsensiEvent{
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController){
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}
class loadMoreSayaEvent extends DataAbsensiEvent{
  late ScrollController scrollController;
  loadMoreSayaEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController){
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class DataAbsensiState{
  List<DataRekapAbsensi>? data;
  DataIzin? dataDetail;
}

class getListDataAbsensiSuccessState extends DataAbsensiState{
  getListDataAbsensiSuccessState(DataAbsensiEvent _event, List<DataRekapAbsensi>? _data){
    data = _data;
  }
}
class getListDataAbsensiSayaSuccessState extends DataAbsensiState{
  getListDataAbsensiSayaSuccessState(DataAbsensiEvent _event, List<DataRekapAbsensi>? _data){
    data = _data;
  }
}

class parseDataDataAbsensiState extends DataAbsensiState{
  parseDataDataAbsensiState(DataIzin _dataDetail){
    dataDetail = _dataDetail;

  }
}

class DataAbsensiProgressState extends DataAbsensiState{}

class LoadMoreProgressState extends DataAbsensiState{
  LoadMoreProgressState(List<DataRekapAbsensi>? _data){
    data = _data;
  }
}

class DataAbsensiErrorState extends DataAbsensiState{}

class DataAbsensiBloc extends Bloc<DataAbsensiEvent, DataAbsensiState>{
  final dateFormat = new DateFormat('yyyy-MM');
  ModelFilter? modelFilter;
  DataAbsensiState? initialState;
  List<DataRekapAbsensi>? listAbsensi;
  int offset = 0;
  int limit = ServerInfo.limit;

  DataAbsensiBloc(DataAbsensiState initialState) : super(initialState);

  @override
  Stream<DataAbsensiState> mapEventToState(DataAbsensiEvent event) async*{
    if(event is getListDataAbsensiEvent){
      offset = 0;
      modelFilter = event.modelFilter;
      yield DataAbsensiProgressState();
      RekapAbsensiRespon absensiRespon = await AbsensiApi().getDataAbsensi(modelFilter,offset);
      if(absensiRespon.success!){
        listAbsensi = absensiRespon.data;
        yield getListDataAbsensiSuccessState(event, listAbsensi);
      }
      else yield DataAbsensiErrorState();
    }
    else if(event is getListDataAbsensiSayaEvent){
      offset = 0;
      modelFilter = event.modelFilter;
      yield DataAbsensiProgressState();
      RekapAbsensiRespon absensiRespon = await AbsensiApi().getDataAbsensiSaya(modelFilter,offset);
      if(absensiRespon.success!){
        listAbsensi = absensiRespon.data;
        yield getListDataAbsensiSayaSuccessState(event, listAbsensi);
      }
      else yield DataAbsensiErrorState();
    }
    else if(event is loadMoreEvent){
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAbsensi);
        RekapAbsensiRespon absensiRespon = await AbsensiApi().getDataAbsensi(modelFilter,offset);
        if(absensiRespon.success!){
          listAbsensi!.addAll(absensiRespon.data!);
        }
        yield getListDataAbsensiSuccessState(event, listAbsensi);
      }
    }
    else if(event is loadMoreSayaEvent){
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAbsensi);
        RekapAbsensiRespon absensiRespon = await AbsensiApi().getDataAbsensiSaya(modelFilter,offset);
        if(absensiRespon.success!){
          listAbsensi!.addAll(absensiRespon.data!);
        }
        yield getListDataAbsensiSayaSuccessState(event, listAbsensi);
      }
    }

  }
}