#include <jni.h>
#include <android/log.h>

#define LOG_TAG "SecurityChecks"
#define LOGI(...) _android_log_print(ANDROID_LOG_INFO, LOG_TAG, __VA_ARGS_)

extern "C"
JNIEXPORT jboolean JNICALL
Java_com_example_absenkuv3_security_SecurityChecker_isDeveloperModeEnabled(
        JNIEnv *env,
        jobject /* thiz */,
        jobject context //
) {
    jclass contextClass = env->GetObjectClass(context);

    jmethodID getContentResolverMethod = env->GetMethodID(
            contextClass,
            "getContentResolver",
            "()Landroid/content/ContentResolver;"
    );
    jobject contentResolver = env->CallObjectMethod(context, getContentResolverMethod);

    jclass settingsGlobalClass = env->FindClass("android/provider/Settings$Global");

    jfieldID devSettingsEnabledField = env->GetStaticFieldID(
            settingsGlobalClass,
            "DEVELOPMENT_SETTINGS_ENABLED",
            "Ljava/lang/String;"
    );
    jstring settingName = (jstring)env->GetStaticObjectField(settingsGlobalClass, devSettingsEnabledField);

    jmethodID getIntMethod = env->GetStaticMethodID(
            settingsGlobalClass,
            "getInt",
            "(Landroid/content/ContentResolver;Ljava/lang/String;I)I"
    );
    jint result = env->CallStaticIntMethod(settingsGlobalClass, getIntMethod, contentResolver, settingName, 0);

//    LOG("Developer Mode Enabled? %d", result);

    return (result == 1) ? JNI_TRUE : JNI_FALSE;
}