import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class TemplateConfirmationDialog{
  String title;
  var action;
  BuildContext context;
  Widget? addWidget;
  double marginHeight;
  String bahasa;
  TemplateConfirmationDialog(this.title, this.action, this.context, {this.addWidget, this.marginHeight = 0,this.bahasa ='id'}) {
    showDialog(
        context: context,
        builder: (BuildContext context) {
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.all(Radius.circular(CustomStyle.boxRadius))
            ),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Center(child: Text(title, style: TextStyle(fontSize: CustomStyle.fontSizeNormal, fontWeight: FontWeight.w600),),),
                addWidget!=null?Container(
                  margin: EdgeInsets.symmetric(vertical: 12),
                  child: addWidget,
                ):Container(),
                SizedBox(height: marginHeight),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    TemplateButton(
                      onClick: ()=>BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context)),
                      label: bahasa == 'id'?"Tidak":"No", color: Colors.transparent, contentColor: CustomStyle.color1, fontSize: CustomStyle.fontSizeNormal, bold: true,),
                    TemplateButton(
                      onClick: action,
                      label: bahasa == 'id'?"Ya":"Yes", color: Colors.transparent, contentColor: CustomStyle.color1, fontSize: CustomStyle.fontSizeNormal, bold: true,)
                  ],
                )
              ],
            ),
          );
        });
  }
}
