import 'dart:async';

import 'package:flutter/material.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

class HalamanDetailMap extends StatelessWidget {
  ModelDetailMap modelDetailMap;
  Completer<GoogleMapController> _controller = Completer();
  late CameraPosition _initPosition;
  Set<Marker> markers = {};
  HalamanDetailMap(this.modelDetailMap){
    _initPosition = CameraPosition(target: LatLng(modelDetailMap.lat, modelDetailMap.long), zoom: 14);
    markers.add(
      Marker(
        markerId: MarkerId(
            "${modelDetailMap.lat}, ${modelDetailMap.long}"),
        icon: BitmapDescriptor.defaultMarker,
        position:
        LatLng(modelDetailMap.lat, modelDetailMap.long),
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: GoogleMap(
        myLocationButtonEnabled: true,
        compassEnabled: true,
        zoomControlsEnabled: false,
        initialCameraPosition: _initPosition,
        mapType: MapType.normal,
        onMapCreated: (GoogleMapController controllers) {
          _controller.complete(controllers);
        },
        markers: markers,
      ),
    );
  }
}

class ModelDetailMap{
  String title;
  double lat;
  double long;
  ModelDetailMap(this.title, this.lat, this.long);
}
