import 'package:flutter/material.dart';

import '../templateButton.dart';

class AlertConfirmation extends StatelessWidget {
  var onClick;
  String message;
  String textBtnCancel;
  String textBtnSubmit;
  int jenis; // {{ 1: DUA TOMBOL, 2: 1 TOMBOL }}
  AlertConfirmation(
      {required this.onClick, required this.message, required this.textBtnCancel, required this.textBtnSubmit, this.jenis = 1});

  @override
  Widget build(BuildContext context) {
    dialogContent(BuildContext context) {
      return Container(
        decoration: new BoxDecoration(
          color: Colors.white,
          shape: BoxShape.rectangle,
          borderRadius: BorderRadius.circular(5),
          boxShadow: [
            BoxShadow(
              color: Colors.black26,
              blurRadius: 10.0,
              offset: const Offset(0.0, 10.0),
            ),
          ],
        ),
        child: SingleChildScrollView(
          child: Padding(
            padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 40),
            child: SingleChildScrollView(
              child: Column(
                mainAxisSize: MainAxisSize.min, // To make the card compact
                children: <Widget>[
                  Container(
                    child: Icon(
                      Icons.info_outline,
                      size: 50,
                      color: Colors.blue[900],
                    ),
                  ),
                  SizedBox(height: 30),
                  Text(
                    message,
                    style: TextStyle(
                      fontSize: 15,
                      color: Colors.blue[900],
                    ),
                  ),
                  SizedBox(height: 30.0),
                  Padding(
                    padding: const EdgeInsets.symmetric(horizontal: 25),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Expanded(
                          child: TemplateButton(
                            color: Colors.blue[900],
                            onClick: () => onClick(),
                            label: textBtnSubmit,
                            widthButton: double.infinity,
                          ),
                        ),
                        SizedBox(
                          width: 5,
                        ),
                        jenis != 1
                            ? Container()
                            : Expanded(
                                child: TemplateButton(
                                  color: Colors.grey,
                                  onClick: () {
                                    Navigator.of(context).pop();
                                  },
                                  label: textBtnCancel,
                                  widthButton: double.infinity,
                                ),
                              ),
                      ],
                    ),
                  )
                ],
              ),
            ),
          ),
        ),
      );
    }

    return Dialog(
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(8),
      ),
      elevation: 0.0,
      backgroundColor: Colors.transparent,
      child: dialogContent(context),
    );
  }
}
