import 'package:absenkuv3/Repository/Model/PageModel/mButtonPage.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:flutter/material.dart';

class AlertDialogCustom extends StatelessWidget {
  final BasicRespon? data;
  final onClick;
  final String? titleMessage;

  AlertDialogCustom({required this.data, required this.onClick, this.titleMessage = ""});

  @override
  Widget build(BuildContext context) {
    dialogContent(BuildContext context) {
      return Container(
        decoration: new BoxDecoration(
          color: Colors.white,
          shape: BoxShape.rectangle,
          borderRadius: BorderRadius.circular(5),
          boxShadow: [
            BoxShadow(
              color: Colors.black26,
              blurRadius: 10.0,
              offset: const Offset(0.0, 10.0),
            ),
          ],
        ),
        child: SingleChildScrollView(
          child: Padding(
            padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 40),
            child: SingleChildScrollView(
              child: Column(
                mainAxisSize: MainAxisSize.min, // To make the card compact
                children: <Widget>[
                  Container(
                    child: Icon(
                      data!.success! ? Icons.check_circle : Icons.error,
                      size: 100,
                      color: data!.success! ? Colors.green : Colors.redAccent,
                    ),
                  ),
                  SizedBox(height: 30),
                  Text(
                    titleMessage != ""
                        ? titleMessage!
                        : data!.success!
                          ? "Sukses"
                          : "Gagal",
                    style: TextStyle(
                        color: data!.success! ? Colors.green : Colors.redAccent,
                        fontWeight: FontWeight.bold,
                        fontSize: 20),
                  ),
                  SizedBox(height: 15),
                  Text(
                    data!.message == null ? '' : data!.message!,
                    style: TextStyle(
                      color: data!.success! ? Colors.green : Colors.redAccent,
                    ),
                  ),
                  SizedBox(height: 30.0),
                  InkWell(
                    onTap: () => onClick(),
                    child: Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 30),
                      child: Container(
                        width: double.infinity,
                        child: Card(
                            color:
                                data!.success! ? Colors.green : Colors.redAccent,
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(15)),
                            child: Padding(
                              padding: const EdgeInsets.all(8.0),
                              child: FutureBuilder<PageButtonModel>(
                                future: PengaturanBahasa().button(),
                                builder: (context, snapshot) {
                                  return Text(
                                    snapshot.data == null ? "" : snapshot.data!.button!.btnTUTUP??'Tutup',
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                        color: Colors.white,
                                        fontWeight: FontWeight.bold),
                                  );
                                }
                              ),
                            )),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
      );
    }

    return Dialog(
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(8),
      ),
      elevation: 0.0,
      backgroundColor: Colors.transparent,
      child: dialogContent(context),
    );
  }
}
