import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';

class ButtonAbsensi extends StatelessWidget {
  String label;
  var onClick;
  String? mulaiTitle;
  String? selesaiTitle;
  bool enable; //enable / disable button
  bool? mulai; // variable untuk flag mulai atau selesai
  ButtonAbsensi(
      {this.mulai = true,
      this.enable = true,
      this.label = "Mulai",
      this.onClick,
      this.mulaiTitle,
      this.selesaiTitle});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: enable ? onClick : null,
      child: Container(
        decoration: BoxDecoration(
            color: enable
                ? mulai!
                    ? Colors.green
                    : Colors.redAccent
                : Colors.grey,
            borderRadius: new BorderRadius.all(
              Radius.circular(16.0),
            )),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(15, 5, 6, 5),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: Center(
                  child: Text(
                    mulai!
                        ? mulaiTitle ?? "Absen Masuk"
                        : selesaiTitle ?? "Absen Pulang",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: CustomStyle.fontSizeSmall),
                  ),
                ),
              ),
              Container(
                  decoration: BoxDecoration(
                      color: Colors.white, shape: BoxShape.circle),
                  child: Padding(
                    padding: const EdgeInsets.all(1.0),
                    child: Icon(
                      mulai!
                          ? Icons.keyboard_arrow_right
                          : Icons.keyboard_arrow_left,
                      size: 20,
                      color: enable
                          ? mulai!
                              ? Colors.green
                              : Colors.red
                          : Colors.grey,
                    ),
                  ))
            ],
          ),
        ),
      ),
    );
  }
}

class ButtonAbsensiv2 extends StatelessWidget {
  String label;
  var onClick;
  bool enable; //enable / disable button
  Color colorActive;
  IconData? icons;
  ButtonAbsensiv2({
    this.enable = true,
    this.label = "Mulai",
    this.onClick,
    this.colorActive = Colors.green,
    this.icons,
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: enable ? onClick : null,
      child: Container(
        decoration: BoxDecoration(
            color: enable ? colorActive : Colors.grey,
            borderRadius: new BorderRadius.all(
              Radius.circular(16.0),
            )),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(15, 5, 6, 5),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: Center(
                  child: Text(
                    label,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: CustomStyle.fontSizeSmall),
                  ),
                ),
              ),
              Container(
                  decoration: BoxDecoration(
                      color: Colors.white, shape: BoxShape.circle),
                  child: Padding(
                    padding: const EdgeInsets.all(1.0),
                    child: Icon(
                      icons,
                      size: 20,
                      // color: enable
                      //     ? mulai! ? Colors.green : Colors.red
                      //     : Colors.grey,
                    ),
                  ))
            ],
          ),
        ),
      ),
    );
  }
}
