
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';


abstract class ImagePickerEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class addImageEvent extends ImagePickerEvent{
MultiImagePickerModel listImage;
  addImageEvent(BuildContext _context, this.listImage){
    context = _context;
  }
}

class deleteImagePicker extends ImagePickerEvent{
  MultiImagePickerModel listImage;
  deleteImagePicker(this.listImage);
}

class clearImagePicker extends ImagePickerEvent{
  clearImagePicker();
}

abstract class ImagePickerState{
  List<MultiImagePickerModel>? listImage;
  // DataBerita? dataBerita;
}

class gettImageSuccessState extends ImagePickerState{
  gettImageSuccessState(ImagePickerEvent _event,   List<MultiImagePickerModel> _data){
    listImage = _data;
  }
}

class ImagePickerProgressState extends ImagePickerState{}


class ImageErrorState extends ImagePickerState{}

class MultiImagePicker3Bloc extends Bloc<ImagePickerEvent, ImagePickerState>{
  ImagePickerState? initialState;
  List<MultiImagePickerModel> listImage = <MultiImagePickerModel> [] ;

  MultiImagePicker3Bloc(ImagePickerState initialState) : super(initialState);

  @override
  Stream<ImagePickerState> mapEventToState(ImagePickerEvent event) async*{
    if(event is addImageEvent){
      yield ImagePickerProgressState();
      listImage.add(event.listImage);
      yield gettImageSuccessState(event, listImage);
    }
    else if (event is deleteImagePicker){
      yield ImagePickerProgressState();
      listImage.remove(event.listImage);
      yield gettImageSuccessState(event, listImage);
    }
    else if ( event is clearImagePicker){
      yield ImagePickerProgressState();
      listImage.clear();
      yield gettImageSuccessState(event, listImage);
    }
  }
}