import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/CustomCupertinoMonthYearPicker.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart'
    as dateRangePicker;
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:month_picker_dialog/month_picker_dialog.dart';
// import 'package:datepicker_dropdown/datepicker_dropdown.dart';
// import 'package:datepicker_dropdown/order_format.dart';

// ignore: must_be_immutable
class TemplateNewMonthPicker extends StatefulWidget {
  DateTime? initialData;
  double height;
  bool lastMonth;
  TemplateNewMonthPicker(
      {this.initialData, this.height = 46, this.lastMonth = false});

  @override
  _TemplateNewMonthPickerState createState() => _TemplateNewMonthPickerState();
}

class _TemplateNewMonthPickerState extends State<TemplateNewMonthPicker> {
  DateTime selectedDate = DateTime.now();
  final dateFormat = new DateFormat('MM-yyyy');

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    if (widget.initialData != null)
      BlocProvider.of<MonthPickerBloc>(context)
          .add(SetDate(widget.initialData));
    /*else BlocProvider.of<MonthPickerBloc>(context).add(SetDate(DateTime.now()));*/
    /*if(widget.initialData!=null){
      DateTime todayDate = DateTime.parse(widget);
    }*/
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return BlocBuilder<MonthPickerBloc, MonthPickerState>(
            builder: (BuildContext context, MonthPickerState state) {
              if (state is ChangeMonthSuccessState)
                return GestureDetector(
                  onTap: () async {
                    _picker(context, true, DateTime.now());

                    // BlocProvider.of<dateRangePicker.DateRangePickerBloc>(context).add(dateRangePicker.InitialDate());
                    // final DateTime? picked = await showMonthPicker(
                    //     locale: Locale(snapshot.data??'en'),
                    //     context: context,
                    //     cancelWidget: Text(snapshot.data==null || snapshot.data=="en"?"Cancel":"Batal"),
                    //     confirmWidget: Text(snapshot.data==null || snapshot.data=="en"?"Apply":"Terapkan"),
                    //     initialDate: state.dateTime!=null?state.dateTime!:DateTime.now(),
                    //     firstDate: DateTime(2015, 8),
                    //     lastDate: widget.lastMonth?DateTime(DateTime.now().year, DateTime.now().month):DateTime(2101));
                    // if (picked != null && picked != selectedDate) BlocProvider.of<MonthPickerBloc>(context).add(SetDate(picked));
                  },
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Container(
                        padding: EdgeInsets.fromLTRB(0, 7, 7, 7),
                        // color: Colors.red,
                        // decoration: BoxDecoration(
                        //     boxShadow: [
                        //       BoxShadow(
                        //         color: Colors.grey.withOpacity(0.3),
                        //         spreadRadius: 2,
                        //         blurRadius: 5,
                        //         offset: Offset(0, 1), // changes position of shadow
                        //       ),
                        //     ],
                        //     gradient: LinearGradient(
                        //         begin: Alignment.centerLeft,
                        //         end: Alignment.centerRight,
                        //         stops: [ 0.0,0.5,1.0],
                        //         colors: [
                        //           Colors.orange[500]!,
                        //           Colors.orange[300]!,
                        //           Colors.orange[500]!,
                        //         ]),
                        //     borderRadius: new BorderRadius.all(
                        //       Radius.circular(20),
                        //     )),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              snapshot.data == null
                                  ? "Month - Year"
                                  : snapshot.data == "en"
                                      ? "Month - Year"
                                      : "Bulan - Tahun",
                              style: TextStyle(
                                  color: Colors.grey.shade600,
                                  fontWeight: FontWeight.w400,
                                  fontSize: CustomStyle.fontSizeSmall - 1),
                            ),
                            SizedBox(
                              height: 11,
                            ),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                // SizedBox(width: 8,),
                                Container(
                                    margin: EdgeInsets.only(left: 0, right: 4),
                                    child: Text(
                                      state.dateTime != null
                                          ? dateFormat.format(state.dateTime!)
                                          : '-',
                                      style: TextStyle(
                                          fontSize:
                                              CustomStyle.fontSizeSmall - 1,
                                          color: Colors.black),
                                    )),
                                // SizedBox(width: 4,),
                                Container(
                                    margin: EdgeInsets.only(right: 9),
                                    child: Icon(Icons.keyboard_arrow_down,
                                        color: Colors.black, size: 18))
                              ],
                            ),
                          ],
                        ),
                      ),
                      Divider(
                        thickness: 0.5,
                        height: 1,
                      )
                    ],
                  ),
                );
              else
                return Container();
            },
          );
        });
  }

  void _picker(
      BuildContext context, bool isStartDate, DateTime initalDateTime) {
    final currentState =
        BlocProvider.of<MonthPickerBloc>(context).state.dateTime;
    DateTime? position;
    if (currentState is DateTime) {
      if (isStartDate) {
        initalDateTime = currentState;
        position = currentState;
      }
    }
    showModalBottomSheet(
        context: context,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.vertical(top: Radius.circular(20)),
        ),
        isScrollControlled: true,
        builder: (context) {
          DateTime selectedDateTime = initalDateTime;
          return FutureBuilder(
            future: PengaturanBahasa().getDataBahasa(),
            builder: (BuildContext context, snapshot) {
              if (snapshot.connectionState == ConnectionState.done) {
                return Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    Container(
                      height: 5,
                      width: 50,
                      margin:
                          EdgeInsets.symmetric(horizontal: 10, vertical: 15),
                      decoration: BoxDecoration(
                          color: Colors.grey,
                          borderRadius: BorderRadius.circular(10)),
                    ),
                    Divider(),
                    SizedBox(
                      height: 300,
                      child: CustomCupertinoMonthYearPicker(
                        itemExtent: 50,
                        selectedDate: isStartDate ? position : initalDateTime,
                        bahasa: snapshot =='id'?'id':'en',
                        maxDate: DateTime.now(),
                        selectionOverlay: Container(
                          width: double.infinity,
                          height: 50,
                          decoration: const BoxDecoration(
                            border: Border.symmetric(
                              horizontal:
                                  BorderSide(color: Colors.grey, width: 1),
                            ),
                          ),
                        ),
                        selectedStyle: const TextStyle(
                          color: Colors.blue,
                          fontWeight: FontWeight.w600,
                          fontSize: 24,
                        ),
                        unselectedStyle: TextStyle(
                          color: Colors.black,
                          fontWeight: FontWeight.w600,
                          fontSize: 18,
                        ),
                        disabledStyle: TextStyle(
                          color: Colors.grey[500],
                          fontSize: 18,
                        ),
                        onSelectedItemChanged: (date) {
                          selectedDateTime = date;
                        },
                      ),
                    ),
                    Divider(),
                    Container(
                      width: MediaQuery.sizeOf(context).width,
                      margin: EdgeInsets.all(10),
                      child: TemplateButton(
                        label: snapshot.data == 'id' ? "Terapkan" : 'Apply',
                        heightButton: 45,
                        fontSize: 15,
                        color: CustomStyle.color1,
                        widthButton: MediaQuery.of(context).size.width - 20,
                        onClick: () {
                          if (isStartDate) {
                            BlocProvider.of<MonthPickerBloc>(context)
                                .add(SetDate(selectedDateTime));
                          }
                          Navigator.pop(context);
                        },
                      ),
                    )
                  ],
                );
              } else {
                return Container();
              }
            },
          );
        });
  }
}
