import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:month_picker_dialog/month_picker_dialog.dart';

// ignore: must_be_immutable
class TemplateMonthPicker extends StatefulWidget {
  DateTime? initialData;
  double height;
  TemplateMonthPicker({this.initialData, this.height = 46});

  @override
  _TemplateMonthPickerState createState() => _TemplateMonthPickerState();
}

class _TemplateMonthPickerState extends State<TemplateMonthPicker> {
  DateTime selectedDate = DateTime.now();
  final dateFormat = new DateFormat('yyyy-MM');

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    if(widget.initialData!=null) BlocProvider.of<MonthPickerBloc>(context).add(SetDate(widget.initialData));
    /*else BlocProvider.of<MonthPickerBloc>(context).add(SetDate(DateTime.now()));*/
    /*if(widget.initialData!=null){
      DateTime todayDate = DateTime.parse(widget);
    }*/
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot){
          return BlocBuilder<MonthPickerBloc, MonthPickerState>(
            builder: (BuildContext context, MonthPickerState state){
              if(state.dateTime!=null)
                return FloatingActionButton.extended(
                  label: Text(dateFormat.format(state.dateTime!), style: TextStyle(fontSize: CustomStyle.fontSizeSmall),),
                  backgroundColor: CustomStyle.color1,
                  icon: Icon(Icons.calendar_today_sharp, size: 22,),
                  onPressed: () async{
                    final DateTime? picked = await showMonthPicker(
                        locale: Locale(snapshot.data??'en'),
                        context: context,
                        initialDate: state.dateTime!,
                        firstDate: DateTime(2015, 8),
                        lastDate: DateTime(2101));
                    if (picked != null && picked != selectedDate) BlocProvider.of<MonthPickerBloc>(context).add(SetDate(picked));
                  },);
              else return Container();
            },
          );
        }
    );
  }
}
