import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Modul/Absensi/KomponenAbsensi.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownCabang.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownDepartemen.dart';
import 'package:absenkuv3/UI/Template/FilterBottomKontak/Bloc/FilterBottomKontakKaryawanBloc.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownCabangBloc.dart' as cabang;
import 'package:absenkuv3/Bloc/Dropdown/DropdownDepartemenBloc.dart'
    as departemen;

class FilterKontakSheet extends StatefulWidget {
  const FilterKontakSheet({super.key});

  @override
  State<FilterKontakSheet> createState() => _FilterKontakSheetState();
}

class _FilterKontakSheetState extends State<FilterKontakSheet> {
  DataDropdown? dataDepartemen;
  DataDropdown? dataCabang;
  ModelFilter? modelFilter;

  @override
  void initState() {
    initialFilter();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (context) {
        return MonthPickerBloc(MonthPickerProgressState());
      },
      child: BlocBuilder<AuthBloc, LoginRespon>(
          builder: (BuildContext context, LoginRespon loginRespon) {
        return TombolIcon(
          onClick: () => _settingModalBottomSheet(loginRespon),
          icon: Icons.filter_alt,
          bgnColor: Colors.white,
          size: 32,
          iconColor: CustomStyle.color1,
        );
      }),
    );
  }

  void initialFilter() {
    modelFilter = null;
    // BlocProvider.of<AutoCompletePegawaiBloc>(context).add(GetPegawai(null, null));
    BlocProvider.of<cabang.DropdownCabangBloc>(context)
        .add(cabang.GetDataDropdown());
    BlocProvider.of<departemen.DropdownDepartemenBloc>(context)
        .add(departemen.GetDataDropdown());

    // BlocProvider.of<departemen.DropdownDepartemenBloc>(context).add(departemen.GetDataDropdown());
    // BlocProvider.of<monthPicker.MonthPickerBloc>(context).add(monthPicker.SetDate(null));
    // BlocProvider.of<dateRangePicker.DateRangePickerBloc>(context).add(dateRangePicker.InitialDate());
    // if(widget.adaFilterStatus) BlocProvider.of<status.DropdownStatusBloc>(context).add(status.GetDataDropdown());
  }

  void resetFilter() {
    modelFilter = null;
    // BlocProvider.of<AutoCompletePegawaiBloc>(context).add(SetPegawai(null));
    BlocProvider.of<cabang.DropdownCabangBloc>(context)
        .add(cabang.SelectDataDropdown(null));
    BlocProvider.of<departemen.DropdownDepartemenBloc>(context)
        .add(departemen.SelectDataDropdown(null));
    // BlocProvider.of<monthPicker.MonthPickerBloc>(context).add(monthPicker.SetDate(null));
    // BlocProvider.of<dateRangePicker.DateRangePickerBloc>(context).add(dateRangePicker.InitialDate());
    // if(widget.adaFilterStatus) BlocProvider.of<status.DropdownStatusBloc>(context).add(status.GetDataDropdown());
  }

  void _settingModalBottomSheet(LoginRespon loginRespon) {
    showModalBottomSheet(
        context: context,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.vertical(top: Radius.circular(20.0)),
        ),
        builder: (context) => StatefulBuilder(
                builder: (BuildContext context, StateSetter setState) {
              return FutureBuilder<String>(
                future: PengaturanBahasa().getDataBahasa(),
                builder: (BuildContext context, snapshot) {
                  if (snapshot.connectionState == ConnectionState.done) {
                    return Container(
                      margin: EdgeInsets.symmetric(horizontal: 10),
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: <Widget>[
                          SizedBox(
                            height: 24,
                          ),
                          BlocListener<cabang.DropdownCabangBloc,
                              cabang.DropdownState>(
                            listener: (BuildContext context,
                                cabang.DropdownState state) {
                              if (state is cabang.DropdownSuccessState) {
                                dataCabang = state.selectedValue;
                              }
                            },
                            child: DropdownCabang(
                              color: CustomStyle.fontColorBlack,
                              formHeight: 50,
                              radius: 14,
                            ),
                          ),
                          BlocListener<departemen.DropdownDepartemenBloc,
                              departemen.DropdownState>(
                            listener: (BuildContext context,
                                departemen.DropdownState state) {
                              if (state is departemen.DropdownSuccessState) {
                                // BlocProvider.of<AutoCompletePegawaiBloc>(context).add(SetPegawai(null));
                                dataDepartemen = state.selectedValue;
                              }
                            },
                            child: DropdownDepartemen(
                              color: CustomStyle.fontColorBlack,
                              formHeight: 50,
                              radius: 14,
                            ),
                          ),
                          SizedBox(
                            height: 24,
                          ),
                          Row(
                              mainAxisAlignment: MainAxisAlignment.end,
                              children: [
                                TemplateButton(
                                  onClick: () => resetFilter(),
                                  label: "Reset",
                                  expand: true,
                                  color: Colors.transparent,
                                  contentColor: CustomStyle.color1,
                                  fontSize: CustomStyle.fontSizeNormal,
                                  bold: true,
                                  paddingTopBottom: 0,
                                  heightButton: 34,
                                  paddingLeftRight: 8,
                                ),
                                TemplateButton(
                                  onClick: () {
                                    modelFilter = ModelFilter(
                                        idCabang: dataCabang != null
                                            ? dataCabang!.id
                                            : null,
                                        idDepartemen: dataDepartemen != null
                                            ? dataDepartemen!.id
                                            : null);
                                    BlocProvider.of<
                                                FilterBottomKontakKaryawanBloc>(
                                            context)
                                        .add(
                                            setFilterBottomKontak(modelFilter));
                                    BlocProvider.of<NavigatorBloc>(context)
                                        .add(NavigatePop(context));
                                  },
                                  label: snapshot.data == null ||
                                          snapshot.data == 'en'
                                      ? "Apply"
                                      : "Terapkan",
                                  expand: true,
                                  color: Colors.transparent,
                                  contentColor: CustomStyle.color1,
                                  fontSize: CustomStyle.fontSizeNormal,
                                  bold: true,
                                  paddingTopBottom: 0,
                                  heightButton: 34,
                                  paddingLeftRight: 8,
                                ),
                              ])
                        ],
                      ),
                    );
                  } else {
                    return Container();
                  }
                },
              );
            })
        // {
        //   // return
        //   // Container(
        //   //   child: Column(
        //   //     mainAxisSize: MainAxisSize.min,
        //   //     children: <Widget>[
        //   //       ListTile(
        //   //         leading: Icon(Icons.photo),
        //   //         title: Text('Pilih Foto'),
        //   //         onTap: () {
        //   //           // Kode ketika item dipilih
        //   //         },
        //   //       ),
        //   //       ListTile(
        //   //         leading: Icon(Icons.camera),
        //   //         title: Text('Gunakan Kamera'),
        //   //         onTap: () {
        //   //           // Kode ketika item dipilih
        //   //         },
        //   //       ),
        //   //     ],
        //   //   ),
        //   // );
        // },
        );

    // showModalBottomSheet(
    //     backgroundColor: Colors.transparent,
    //     elevation: 0,
    //     context: context,
    //     isDismissible: false,
    //     isScrollControlled: true,
    //     shape:RoundedRectangleBorder(
    //       borderRadius: BorderRadius.vertical(
    //         top: Radius.circular(25.0),
    //       ),
    //     ),
    //     builder: (context) => StatefulBuilder(
    //             builder: (BuildContext context, StateSetter setState) {
    //           return FutureBuilder<String>(
    //               future: PengaturanBahasa().getDataBahasa(),
    //               builder: (context, snapshot) {
    //                 return Container(
    //                     child: SingleChildScrollView(
    //                   child: Padding(
    //                     padding: EdgeInsets.only(
    //                         bottom: MediaQuery.of(context).viewInsets.bottom),
    //                     child: ConstrainedBox(
    //                       constraints: BoxConstraints(
    //                           minHeight:
    //                               MediaQuery.of(context).size.height / 4),
    //                       child: Container(
    //                         color: Colors.white,
    //                         padding: EdgeInsets.fromLTRB(18, 14, 18, 14),
    //                         child: Column(
    //                           children: [
    //                             Row(
    //                               children: [
    //                                 GestureDetector(
    //                                     onTap: () {
    //                                       BlocProvider.of<NavigatorBloc>(
    //                                               context)
    //                                           .add(NavigatePop(context));
    //                                       // resetFilter();
    //                                     },
    //                                     child: Icon(
    //                                       Icons.close,
    //                                       color: CustomStyle.fontColorBlack,
    //                                       size: 23,
    //                                     )),
    //                                 SizedBox(
    //                                   width: 8,
    //                                 ),
    //                                 Text(
    //                                   snapshot.data == null ||
    //                                           snapshot.data == 'en'
    //                                       ? "Search Filters"
    //                                       : "Filter Pencarian",
    //                                   style: TextStyle(
    //                                       color: CustomStyle.fontColorBlack,
    //                                       fontSize: CustomStyle.fontSizeTitle,
    //                                       fontWeight: FontWeight.w700),
    //                                 )
    //                               ],
    //                             ),
    //                             BlocListener<cabang.DropdownCabangBloc,
    //                                 cabang.DropdownState>(
    //                               listener: (BuildContext context,
    //                                   cabang.DropdownState state) {
    //                                 if (state is cabang.DropdownSuccessState) {
    //                                   dataCabang = state.selectedValue;
    //                                 }
    //                               },
    //                               child: DropdownCabang(
    //                                 color: CustomStyle.fontColorBlack,
    //                                 formHeight: 50,
    //                                 radius: 14,
    //                               ),
    //                             ),
    //                             BlocListener<departemen.DropdownDepartemenBloc,
    //                                 departemen.DropdownState>(
    //                               listener: (BuildContext context,
    //                                   departemen.DropdownState state) {
    //                                 if (state
    //                                     is departemen.DropdownSuccessState) {
    //                                   // BlocProvider.of<AutoCompletePegawaiBloc>(context).add(SetPegawai(null));
    //                                   dataDepartemen = state.selectedValue;
    //                                 }
    //                               },
    //                               child: DropdownDepartemen(
    //                                 color: CustomStyle.fontColorBlack,
    //                                 formHeight: 50,
    //                                 radius: 14,
    //                               ),
    //                             ),
    //                             SizedBox(
    //                               height: 24,
    //                             ),
    //                             Row(
    //                               mainAxisAlignment: MainAxisAlignment.end,
    //                               children: [
    //                                 TemplateButton(
    //                                   onClick: () => resetFilter(),
    //                                   label: "Reset",
    //                                   expand: true,
    //                                   color: Colors.transparent,
    //                                   contentColor: CustomStyle.color1,
    //                                   fontSize: CustomStyle.fontSizeNormal,
    //                                   bold: true,
    //                                   paddingTopBottom: 0,
    //                                   heightButton: 34,
    //                                   paddingLeftRight: 8,
    //                                 ),
    //                                 TemplateButton(
    //                                   onClick: () {
    //                                     modelFilter = ModelFilter(
    //                                         idCabang: dataCabang != null
    //                                             ? dataCabang!.id
    //                                             : null,
    //                                         idDepartemen: dataDepartemen != null
    //                                             ? dataDepartemen!.id
    //                                             : null);
    //                                     BlocProvider.of<
    //                                                 FilterBottomKontakKaryawanBloc>(
    //                                             context)
    //                                         .add(setFilterBottomKontak(
    //                                             modelFilter));
    //                                     BlocProvider.of<NavigatorBloc>(context)
    //                                         .add(NavigatePop(context));
    //                                   },
    //                                   label: snapshot.data == null ||
    //                                           snapshot.data == 'en'
    //                                       ? "Apply"
    //                                       : "Terapkan",
    //                                   expand: true,
    //                                   color: Colors.transparent,
    //                                   contentColor: CustomStyle.color1,
    //                                   fontSize: CustomStyle.fontSizeNormal,
    //                                   bold: true,
    //                                   paddingTopBottom: 0,
    //                                   heightButton: 34,
    //                                   paddingLeftRight: 8,
    //                                 ),
    //                               ],
    //                             )
    //                           ],
    //                         ),
    //                       ),
    //                     ),
    //                   ),
    //                 ));
    //                 // return
    //                 // SingleChildScrollView(
    //                 //   child: Padding(
    //                 //     padding: EdgeInsets.only(
    //                 //         bottom: MediaQuery.of(context).viewInsets.bottom),
    //                 //     child: ConstrainedBox(
    //                 //       constraints: BoxConstraints(
    //                 //           minHeight:
    //                 //               MediaQuery.of(context).size.height / 4),
    //                 //       child: Container(
    //                 //         color: Colors.white,
    //                 //         padding: EdgeInsets.fromLTRB(18, 14, 18, 14),
    //                 //         child: Column(
    //                 //           children: [
    //                 //             Row(
    //                 //               children: [
    //                 //                 GestureDetector(
    //                 //                     onTap: () {
    //                 //                       BlocProvider.of<NavigatorBloc>(
    //                 //                               context)
    //                 //                           .add(NavigatePop(context));
    //                 //                       // resetFilter();
    //                 //                     },
    //                 //                     child: Icon(
    //                 //                       Icons.close,
    //                 //                       color: CustomStyle.fontColorBlack,
    //                 //                       size: 23,
    //                 //                     )),
    //                 //                 SizedBox(
    //                 //                   width: 8,
    //                 //                 ),
    //                 //                 Text(
    //                 //                   snapshot.data == null ||
    //                 //                           snapshot.data == 'en'
    //                 //                       ? "Search Filters"
    //                 //                       : "Filter Pencarian",
    //                 //                   style: TextStyle(
    //                 //                       color: CustomStyle.fontColorBlack,
    //                 //                       fontSize: CustomStyle.fontSizeTitle,
    //                 //                       fontWeight: FontWeight.w700),
    //                 //                 )
    //                 //               ],
    //                 //             ),
    //                 //             BlocListener<cabang.DropdownCabangBloc,
    //                 //                 cabang.DropdownState>(
    //                 //               listener: (BuildContext context,
    //                 //                   cabang.DropdownState state) {
    //                 //                 if (state is cabang.DropdownSuccessState) {
    //                 //                   dataCabang = state.selectedValue;
    //                 //                 }
    //                 //               },
    //                 //               child: DropdownCabang(
    //                 //                 color: CustomStyle.fontColorBlack,
    //                 //                 formHeight: 34,
    //                 //                 radius: 14,
    //                 //               ),
    //                 //             ),
    //                 //             BlocListener<departemen.DropdownDepartemenBloc,
    //                 //                 departemen.DropdownState>(
    //                 //               listener: (BuildContext context,
    //                 //                   departemen.DropdownState state) {
    //                 //                 if (state
    //                 //                     is departemen.DropdownSuccessState) {
    //                 //                   // BlocProvider.of<AutoCompletePegawaiBloc>(context).add(SetPegawai(null));
    //                 //                   dataDepartemen = state.selectedValue;
    //                 //                 }
    //                 //               },
    //                 //               child: DropdownDepartemen(
    //                 //                 color: CustomStyle.fontColorBlack,
    //                 //                 formHeight: 34,
    //                 //                 radius: 14,
    //                 //               ),
    //                 //             ),
    //                 //             SizedBox(
    //                 //               height: 24,
    //                 //             ),
    //                 //             Row(
    //                 //               mainAxisAlignment: MainAxisAlignment.end,
    //                 //               children: [
    //                 //                 TemplateButton(
    //                 //                   onClick: () => resetFilter(),
    //                 //                   label: "Reset",
    //                 //                   expand: true,
    //                 //                   color: Colors.transparent,
    //                 //                   contentColor: CustomStyle.color1,
    //                 //                   fontSize: CustomStyle.fontSizeNormal,
    //                 //                   bold: true,
    //                 //                   paddingTopBottom: 0,
    //                 //                   heightButton: 34,
    //                 //                   paddingLeftRight: 8,
    //                 //                 ),
    //                 //                 TemplateButton(
    //                 //                   onClick: () {
    //                 //                     modelFilter = ModelFilter(
    //                 //                         idCabang: dataCabang != null
    //                 //                             ? dataCabang!.id
    //                 //                             : null,
    //                 //                         idDepartemen: dataDepartemen != null
    //                 //                             ? dataDepartemen!.id
    //                 //                             : null);
    //                 //                     BlocProvider.of<
    //                 //                                 FilterBottomKontakKaryawanBloc>(
    //                 //                             context)
    //                 //                         .add(setFilterBottomKontak(
    //                 //                             modelFilter));
    //                 //                     BlocProvider.of<NavigatorBloc>(context)
    //                 //                         .add(NavigatePop(context));
    //                 //                   },
    //                 //                   label: snapshot.data == null ||
    //                 //                           snapshot.data == 'en'
    //                 //                       ? "Apply"
    //                 //                       : "Terapkan",
    //                 //                   expand: true,
    //                 //                   color: Colors.transparent,
    //                 //                   contentColor: CustomStyle.color1,
    //                 //                   fontSize: CustomStyle.fontSizeNormal,
    //                 //                   bold: true,
    //                 //                   paddingTopBottom: 0,
    //                 //                   heightButton: 34,
    //                 //                   paddingLeftRight: 8,
    //                 //                 ),
    //                 //               ],
    //                 //             )
    //                 //           ],
    //                 //         ),
    //                 //       ),
    //                 //     ),
    //                 //   ),
    //                 // );
    //               });
    //         }));
  }
}
