import 'dart:convert';
import 'dart:io';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/Camera/Model/CameraModel.dart';
import 'package:absenkuv3/UI/Template/FaceRecognition/Bloc/FaceRecognitionBloc.dart';
import 'package:camera/camera.dart';
import 'package:flutter/material.dart';
import 'dart:math' as math;
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../style.dart';
import 'Widget/FacePainter.dart';

class FaceRecognition extends StatefulWidget {
  String konteks;
  FaceRecognition(this.konteks);

  @override
  _FaceRecognitionState createState() => _FaceRecognitionState();
}

class _FaceRecognitionState extends State<FaceRecognition> {

  @override
  void initState() {
    // TODO: implement initState
    BlocProvider.of<FaceRecognitionBloc>(context).add(Initialize(context));
    super.initState();
  }

  Future<bool> keluar() async{
    BlocProvider.of<FaceRecognitionBloc>(context).add(Dispose(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    final double mirror = math.pi;
    final width = MediaQuery.of(context).size.width;
    return WillPopScope(child: BlocConsumer<FaceRecognitionBloc, FaceRecognitionState>(
      listener: (BuildContext context, FaceRecognitionState state){
        // if(state is TakePictureSuccess) Navigator.pop(context, CameraModel(base64Encode(File(state.file!.path).readAsBytesSync()), state.file!.path));
      },
      builder: (BuildContext context, FaceRecognitionState state){
        return Scaffold(
          appBar: AppBar(
            centerTitle: true,
            flexibleSpace: Image(
              image: AssetImage(ValueImage.headerBiruDashboard),
              fit: BoxFit.cover,
            ),
            backgroundColor: Colors.black,
            title: Text(
              widget.konteks,
              style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
            ),
          ),
          body: Container(
            color: Colors.black,
            height: MediaQuery.of(context).size.height,
            child: Stack(
              children: [
                // cameraWidget(context, state.controller),
                state is InitializeSuccess?Transform.scale(
                  scale: 1.0,
                  child: Container(
                    width: width,
                    height: width * state.controller!.value.aspectRatio,
                    child: Stack(
                      fit: StackFit.expand,
                      children: <Widget>[
                        Container(
                          width: double.infinity,
                            child: CameraPreview(state.controller!)
                        ),
                        CustomPaint(
                          painter: FacePainter(face: state.faceDetected, imageSize: state.imageSize),
                        )
                      ],
                    ),
                  ),
                ):
                Container(
                  height: double.infinity,
                  width: double.infinity,
                  color: Colors.black,
                ),
                Positioned(
                  bottom: 0,
                  child: Container(
                    padding: EdgeInsets.only(bottom: 30, top: 10),
                    height: 110,
                    color: Colors.transparent,
                    width: MediaQuery.of(context).size.width,
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      mainAxisSize: MainAxisSize.max,
                      children: [
                        GestureDetector(
                          onTap: ()=>state is InitializeProgress?(){}:BlocProvider.of<FaceRecognitionBloc>(context).add(TakePicture(context)),
                          child: Container(
                            height: 60,
                            padding: EdgeInsets.fromLTRB(18, 10, 18, 10),
                            decoration: BoxDecoration(boxShadow: [
                              BoxShadow(
                                color: Colors.grey.withOpacity(0.4),
                                spreadRadius: 2,
                                blurRadius: 5,
                                offset: Offset(0, 1), // changes position of shadow
                              ),
                            ], color: Colors.white, borderRadius: new BorderRadius.all(
                              Radius.circular(32),
                            )),
                            child: Row(children: [
                              Text(widget.konteks, style: TextStyle(color: CustomStyle.fontColorBlack, fontSize: CustomStyle.fontSizeSmall, fontWeight: FontWeight.w600),),
                              SizedBox(width: 6,),
                              state is InitializeProgress?
                              ClipRRect(
                                borderRadius : BorderRadius.circular(120.0),
                                child: Container(
                                  width: 36,
                                  height: 36,
                                  padding: EdgeInsets.all(8),
                                  child: CircularProgressIndicator(valueColor: new AlwaysStoppedAnimation<Color>(Colors.grey),),
                                ),):Icon(Icons.camera_alt, color: CustomStyle.fontColorBlack, size: 36,)
                            ],),
                          ),
                        ),

                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    ), onWillPop: keluar);
  }
}
