import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglKawinBloc.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class TemplateDatePickerTglKawin extends StatefulWidget {
  DateTime? initialData;
  double height;
  String title;
  bool validasi;
  double marginHorizontal;
  TextEditingController? textEditingController;
  bool nextDate;
  bool enableClick;
  TemplateDatePickerTglKawin(this.title,{this.initialData, this.height = 46, this.validasi = false, this.marginHorizontal = 0, this.textEditingController, this.nextDate = true, this.enableClick = true});

  @override
  _TemplateDatePickerTglKawinState createState() => _TemplateDatePickerTglKawinState();
}

class _TemplateDatePickerTglKawinState extends State<TemplateDatePickerTglKawin> {
  DateTime selectedDate = DateTime.now();
  // final dateFormat = new DateFormat('dd-MM-yyyy');
  final dateFormat = DateFormat('d MMMM  yyyy', 'id_ID');

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    // if(widget.initialData!=null) BlocProvider.of<DatePickerMulaiBloc>(context).add(SetDate(widget.initialData));
    // else BlocProvider.of<DatePickerMulaiBloc>(context).add(SetDate(DateTime.now()));
    /*if(widget.initialData!=null){
      DateTime todayDate = DateTime.parse(widget);
    }*/
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<DatePickerTglKawinBloc, DateTime>(
      builder: (BuildContext context, DateTime date){
        return GestureDetector(
          onTap: widget.enableClick?() async{
            final DateTime? picked = await showDatePicker(
                context: context,
                initialDate: DateFormat('yyyy-MM-dd').format(DateTime(date.year,date.month,date.day)) == "0001-01-01" ? DateTime.now() : date,
                firstDate: DateTime(1920, 1),
                lastDate: widget.nextDate ? DateTime(2101) : DateTime.now());
            if (picked != null && picked != selectedDate) BlocProvider.of<DatePickerTglKawinBloc>(context).add(SetDate(picked));
          }:null,
          child: Container(
            child: TemplateTextFormAkun(
                enabled: false,
                suffixIcon: Container(
                    margin: EdgeInsets.only(right: 15),
                    child: Icon(Icons.calendar_today, size: 20)),
                fontSize: 13,
                adaValidasi: widget.validasi,
                controller: widget.textEditingController,
                titleText:widget.title,
                marginHorizontal: widget.marginHorizontal,
                hintText: DateFormat('yyyy-MM-dd').format(DateTime(date.year,date.month,date.day))=="0001-01-01"
                    ? widget.initialData == null
                    ? widget.title
                    : dateFormat.format(widget.initialData!)
                    :dateFormat.format(date),
                radius: 6,
                flagColorBackground: true,
                color: Colors.black),
          ),
        );
        // else return Container();
      },
    );
  }
}
