import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerMulaiBloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import '../../style.dart';

// ignore: must_be_immutable
class TemplateDatePicker extends StatefulWidget {
  String title; // Tanggal Nota
  DateTime? initialData;
  double height;
  TemplateDatePicker(this.title, {this.initialData, this.height = 46});

  @override
  _TemplateDatePickerState createState() => _TemplateDatePickerState();
}

class _TemplateDatePickerState extends State<TemplateDatePicker> {
  DateTime selectedDate = DateTime.now();
  final dateFormat = new DateFormat('dd-MM-yyyy');

  @override
  void initState() {
    super.initState();
    if(widget.initialData!=null) BlocProvider.of<DatePickerMulaiBloc>(context).add(SetDate(widget.initialData));
    else BlocProvider.of<DatePickerMulaiBloc>(context).add(SetDate(DateTime.now()));
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<DatePickerMulaiBloc, DateTime>(
      builder: (BuildContext context, DateTime date){
        // ignore: unnecessary_null_comparison
        if(date!=null) return GestureDetector(
          onTap: () async{
            final DateTime? picked = await showDatePicker(
                context: context,
                initialDate: date,
                firstDate: DateTime(2015, 8),
                lastDate: DateTime(2101));
            if (picked != null && picked != selectedDate) BlocProvider.of<DatePickerMulaiBloc>(context).add(SetDate(picked));
          },
          child: Container(
            padding: EdgeInsets.fromLTRB(16, 7, 16, 7),
            decoration: BoxDecoration(
                boxShadow: [
                  BoxShadow(
                    color: Colors.grey.withOpacity(0.3),
                    spreadRadius: 2,
                    blurRadius: 5,
                    offset: Offset(0, 1), // changes position of shadow
                  ),
                ],
                gradient: LinearGradient(
                    begin: Alignment.centerLeft,
                    end: Alignment.centerRight,
                    stops: [ 0.0,0.5,1.0],
                    colors: [
                      CustomStyle.color1,
                      Colors.lightBlue,
                      CustomStyle.color1,
                    ]),
                borderRadius: new BorderRadius.all(
                  Radius.circular(20),
                )),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Text(widget.title, style: TextStyle(color: Colors.white, fontWeight: FontWeight.w600, fontSize: CustomStyle.fontSizeSmall),),
                SizedBox(height: 1,),
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    SizedBox(width: 8,),
                    Text(dateFormat.format(date), style: TextStyle(fontSize: CustomStyle.fontSizeSmall-1, color: Colors.white),),
                    SizedBox(width: 4,),
                    Icon(Icons.keyboard_arrow_down, color: Colors.white,  size: 18)
                  ],
                ),
              ],
            ),
          )/*Container(
            child: TemplateForm(
              enabled: false,
              prefixIcon: Icon(Icons.calendar_today, size: 20,),titleText:"Tanggal Mulai:",hintText:dateFormat.format(date), radius: 6, formHeight: widget.height, color: Colors.grey[600],),
          ),*/
        );
        else return Container();
      },
    );
  }
}
