import 'package:absenkuv3/UI/Template/CupertinoPicker/Bloc/date_pick_bloc.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/CustomCupertinoMonthYearPicker.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class TemplateMonthYearPicker extends StatefulWidget {
  const TemplateMonthYearPicker({super.key});

  @override
  State<TemplateMonthYearPicker> createState() => _TemplateMonthYearPickerState();
}

class _TemplateMonthYearPickerState extends State<TemplateMonthYearPicker> {
  @override
   Widget build(BuildContext context) {
    DateTime? selectedStartDate;
    List<String> monthNames = [
      'Januari',
      'Februari',
      'Maret',
      'April',
      'Mei',
      'Juni',
      'Juli',
      'Agustus',
      'September',
      'Oktober',
      'November',
      'Desember'
    ];
    return BlocBuilder<DatePickBloc, DatePickState>(builder: (context, state) {
      DateTime? startDate;
      if (state is DateSelected) {
        startDate = state.startDate;
        selectedStartDate = startDate;
      }
      return Container(
        padding: EdgeInsets.all(20),
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(20), color: CustomStyle.color1),
        child: GestureDetector(
          onTap: () {
            _picker(context, true, DateTime.now());
          },
          child: Container(
            child: Column(
              children: [
                startDate == null
                    ? Text(
                        "bulan - tahun",
                        style: TextStyle(color: Colors.white),
                      )
                    : Container(),
                startDate == null
                    ? Container()
                    : Text(
                        "${monthNames[startDate.month - 1]} - ${startDate.year}",
                        style: TextStyle(color: Colors.white))
              ],
            ),
          ),
        ),
      );
    });
    // return ElevatedButton(
    //   style: ElevatedButton.styleFrom(
    //     backgroundColor: Colors.black,
    //     foregroundColor: Colors.white,
    //   ),
    //   onPressed: () {
    //     _picker(context, true, DateTime.now());
    //   },
    //   child: const Text("Save"),
    // );
  }

  void _picker(
      BuildContext context, bool isStartDate, DateTime initalDateTime) {
    final currentState = BlocProvider.of<DatePickBloc>(context).state;
    DateTime? position;

    if (currentState is DateSelected) {
      if (isStartDate) {
        initalDateTime = currentState.startDate;
        position = currentState.startDate;
      } else {
        initalDateTime = currentState.startDate.isAfter(DateTime.now())
            ? currentState.startDate
            : DateTime.now();
        position = DateTime.now();
      }
    }
    showCupertinoModalPopup(
        context: context,
        builder: (context) {
          DateTime selectedDateTime = initalDateTime;
          return Container(
            decoration: BoxDecoration(
                color: Colors.white,
                borderRadius: BorderRadius.only(
                    topLeft: Radius.circular(20),
                    topRight: Radius.circular(20))),
            height: 430,
            child: Container(
                child: Column(
              children: [
                Container(
                  height: 10,
                  width: 60,
                  margin: EdgeInsets.symmetric(horizontal: 5, vertical: 5),
                  decoration: BoxDecoration(
                      color: Colors.grey,
                      borderRadius: BorderRadius.circular(20)),
                ),
                Divider(),
                SizedBox(
                  height: 320,
                  child: CustomCupertinoMonthYearPicker(
                    itemExtent: 60,
                    diameterRatio: 4.0,
                    magnification: 1.1,
                    selectedDate: isStartDate ? position : initalDateTime,
                    selectionOverlay: Container(
                      width: double.infinity,
                      height: 50,
                      decoration: const BoxDecoration(
                        border: Border.symmetric(
                          horizontal: BorderSide(color: Colors.grey, width: 1),
                        ),
                      ),
                    ),
                    selectedStyle: const TextStyle(
                      color: Colors.blue,
                      fontWeight: FontWeight.w600,
                      fontSize: 24,
                    ),
                    unselectedStyle: TextStyle(
                      color: Colors.black,
                      fontWeight: FontWeight.w600,
                      fontSize: 18,
                    ),
                    disabledStyle: TextStyle(
                      color: Colors.grey[500],
                      fontSize: 18,
                    ),
                    onSelectedItemChanged: (date) {
                      selectedDateTime = date;
                    },
                  ),
                ),
                Divider(),
                Container(
                  width: MediaQuery.sizeOf(context).width - 30,
                  child: ElevatedButton(
                    style: ElevatedButton.styleFrom(
                        backgroundColor: CustomStyle.color1,
                        foregroundColor: Colors.white,
                        minimumSize: Size(double.infinity, 50),
                        shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(20))),
                    onPressed: () {
                      if (isStartDate) {
                        context
                            .read<DatePickBloc>()
                            .add(PickStartDateEvent(selectedDateTime));
                      }
                      Navigator.pop(context);
                    },
                    child: Text("Terapkan"),
                  ),
                )
              ],
            )),
          );
        });
  }

}