// date_event.dart
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DatePickEvent {}

class PickStartDateEvent extends DatePickEvent {
  final DateTime startDate;

  PickStartDateEvent(this.startDate);

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
      other is PickStartDateEvent &&
          runtimeType == other.runtimeType &&
          startDate == other.startDate;

  @override
  int get hashCode => startDate.hashCode;
}

class PickEndDateEvent extends DatePickEvent {
  final DateTime endDate;

  PickEndDateEvent(this.endDate);

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
      other is PickEndDateEvent &&
          runtimeType == other.runtimeType &&
          endDate == other.endDate;

  @override
  int get hashCode => endDate.hashCode;
}

class ClearDatesEvent extends DatePickEvent {
  @override
  bool operator ==(Object other) => identical(this, other);

  @override
  int get hashCode => runtimeType.hashCode;
}

abstract class DatePickState {}

class DateInitialPick extends DatePickState {}

class DateSelected extends DatePickState {
  final DateTime startDate;
  final DateTime? endDate;

  DateSelected({required this.startDate, this.endDate});

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
      other is DateSelected &&
          runtimeType == other.runtimeType &&
          startDate == other.startDate &&
          endDate == other.endDate;

  @override
  int get hashCode => startDate.hashCode ^ endDate.hashCode;
}
class DatePickBloc extends Bloc<DatePickEvent, DatePickState> {
  DatePickBloc() : super(DateInitialPick());

  @override
  Stream<DatePickState> mapEventToState(DatePickEvent event) async* {
    if (event is PickStartDateEvent) {
      yield DateSelected(startDate: event.startDate);
    } else if (event is PickEndDateEvent) {
      if (state is DateSelected) {
        final currentState = state as DateSelected;
        yield DateSelected(
          startDate: currentState.startDate,
          endDate: event.endDate,
        );
      }
    } else if (event is ClearDatesEvent ) {
      yield DateInitialPick();
    }
  }
}