import 'package:bloc/bloc.dart';

// Events
abstract class DateEvent {}

class StartDateChanged extends DateEvent {
  final DateTime date;

  StartDateChanged(this.date);

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
          other is StartDateChanged &&
              runtimeType == other.runtimeType &&
              date == other.date;

  @override
  int get hashCode => date.hashCode;
}

class EndDateChanged extends DateEvent {
  final DateTime date;

  EndDateChanged(this.date);

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
          other is EndDateChanged &&
              runtimeType == other.runtimeType &&
              date == other.date;

  @override
  int get hashCode => date.hashCode;
}

// States
abstract class DateState {}

class DateInitial extends DateState {
  final DateTime startDate;
  final DateTime endDate;

  DateInitial({required this.startDate, required this.endDate});

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
          other is DateInitial &&
              runtimeType == other.runtimeType &&
              startDate == other.startDate &&
              endDate == other.endDate;

  @override
  int get hashCode => startDate.hashCode ^ endDate.hashCode;
}

// BLoC
class DateBloc extends Bloc<DateEvent, DateState> {
  DateBloc()
      : super(DateInitial(
    startDate: DateTime.now(),
    endDate: DateTime.now(),
  )) {
    on<StartDateChanged>((event, emit) {
      final currentState = state;
      if (currentState is DateInitial) {
        emit(DateInitial(
          startDate: event.date,
          endDate: currentState.endDate,
        ));
      }
    });
    on<EndDateChanged>((event, emit) {
      final currentState = state;
      if (currentState is DateInitial) {
        emit(DateInitial(
          startDate: currentState.startDate,
          endDate: event.date,
        ));
      }
    });
  }
}
