import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mButtonPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/progress_dialog.dart';
import '../../../../Bloc/AuthBloc.dart';
import '../../../../Bloc/CustomFunction.dart';
import '../../../../Repository/Model/mFace.dart';
import '../../../../Repository/Model/mSplashScreen.dart';
import '../../../../Repository/Service/FaceRecognitionApi.dart';
import '../../../../Repository/Service/userApi.dart';

abstract class FaceXEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class InitialDialog extends FaceXEvent {
  InitialDialog(BuildContext? _context) {
    context = _context;
  }
}

class registrasiEvent extends FaceXEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  List? matrix;
  String listImage;
  bool? shiftLepas;
  registrasiEvent(this.context, this.scaffoldKey, this.matrix, this.listImage,this.shiftLepas);
}

abstract class FaceXState {}

class regisState extends FaceXState {}

class FaceXStateInit extends FaceXState {
  FaceXStateInit(this.faceRegistrationInfoRespon);
  List<DataFaceRegistrationInfo>? faceRegistrationInfoRespon;
}

class FaceXBloc extends Bloc<FaceXEvent, FaceXState> {
  // FaceRegisCameraXBloc() : super(FaceRegisCameraXState());
  FaceXBloc(FaceXState initialState) : super(initialState);

  @override
  Stream<FaceXState> mapEventToState(FaceXEvent event) async* {
    if (event is registrasiEvent) {
      print("masukregistrasi");
      PageButtonModel? button;
      PengaturanBahasa().button().then((value) => button = value);
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon =
          await UserApi().faceRegistration(event.matrix, event.listImage);
      ProgressDialogDelayed.hide(pd);
      if (basicRespon.success!) {
        if(event.shiftLepas!){
        BlocProvider.of<AuthBloc>(event.context!)
            .add(GetUserDataTerkiniEvent(event.context, event.scaffoldKey));
          CustomPopUpShiftLepas.show(basicRespon.message, event.context,button!.button!.btnTutup,
            doublePop: false, isDismissible: false, closeCustom:(){
          BlocProvider.of<NavigatorBloc>(event.context!)
                  .add(NavigateToAbsensiReplace(event.context!));
            });
        }else{
        BlocProvider.of<AuthBloc>(event.context!)
            .add(GetUserDataTerkiniEvent(event.context, event.scaffoldKey));
        CustomPopUp.show(basicRespon.message, event.context, button!.button!.btnTutup,
            isDismissible: false, doublePop: false);
        }
      } else {
        ScaffoldMessenger.of(event.context!)
            .showSnackBar(SnackBar(content: Text(basicRespon.message!)));
      }
    } else if (event is InitialDialog) {
      FaceRegistrationInfoRespon faceRegistrationInfoRespon =
          await FaceRecognitionApi().getDataPeringatanRegistrasi();
      if (faceRegistrationInfoRespon.success!) {
        yield FaceXStateInit(faceRegistrationInfoRespon.data);
        print("INITIAL DIALOG1" + faceRegistrationInfoRespon.data!.toString());
        // CustomPopUpRegistrasiWajah.show(faceRegistrationInfoRespon.data, event.context);
        // firstInit = false;
      }
    }
  }
}
