import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/CameraIOS/Constants.dart';
import 'package:absenkuv3/UI/Template/CameraIOS/NativeCamera.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class CameraIosPage extends StatefulWidget {
  double absensi;
  CameraIosPage(this.absensi);

  @override
  State<CameraIosPage> createState() => _CameraIosPageState();
}

class _CameraIosPageState extends State<CameraIosPage> {

  final Map<String, dynamic> creationParams = {};

  void setDimension() async {
    final screenSize = MediaQuery.of(context).size;
    Future.delayed(Duration(milliseconds: 500), () async {
      await Constants.channel.invokeMethod(Constants.setDimension, {
        'width': screenSize.width,
        'height': screenSize.height,
        'absensi': widget.absensi
      });
    });

  }

  @override
  void initState() {
    Future.delayed(Duration.zero).then((_) => setDimension());
    SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual, overlays: [SystemUiOverlay.bottom]);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {

    void takePhoto() async {
      final Uint8List data = await NativeCamera.takePhoto();
      // CameraXRespon cameraXRespon = CameraXRespon(matrix: data.toString());
      Navigator.pop(context, data);
    }

    void switchCamera() async {
      await NativeCamera.switchCamera();
    }

    Widget _buildTakePhotoButton() => Stack(
      children: [
        Align(
          alignment: Alignment.bottomCenter,
          child: GestureDetector(
            onTap: takePhoto,
            child: Container(
              width: 68,
              height: 68,
              decoration: BoxDecoration(
                color: Colors.white,
                image: DecorationImage(image: AssetImage(ValueImage.camera2Icon)),
                shape: BoxShape.circle,
                // border: Border.all(width: 4, color: Colors.grey),
              ),
            ),
          ),
        ),
        widget.absensi == 1
          ? Container()
          : Align(
              alignment: Alignment.bottomCenter,
              child: Container(
                margin: EdgeInsets.only(left: 137, bottom: 11),
                child: GestureDetector(
                  onTap: switchCamera,
                  child: Container(
                    width: 40,
                    height: 40,
                    decoration: BoxDecoration(
                      color: Colors.transparent.withOpacity(0.05),
                      image: DecorationImage(image: AssetImage(ValueImage.flipIcon)),
                      shape: BoxShape.circle,
                      // border: Border.all(width: 4, color: Colors.grey),
                    ),
                  ),
                ),
              ),
            ),
      ],
    );

    return Scaffold(
      backgroundColor: Colors.black,
      body: UiKitView(
          // viewType: 'MySwiftUiView',
        viewType: Constants.viewType,
        layoutDirection: TextDirection.ltr,
        creationParams: creationParams,
        creationParamsCodec: StandardMessageCodec(),
      ),
      floatingActionButtonLocation: FloatingActionButtonLocation.centerFloat,
      floatingActionButton: _buildTakePhotoButton(),
    );
  }
}
