import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class AutoCompleteShiftEvent {}

class GetPegawai extends AutoCompleteShiftEvent {
  String? keywords;
  ModelFilter? modelFilter;
  GetPegawai(this.keywords, this.modelFilter);
}

class SetPegawai extends AutoCompleteShiftEvent {
  DataDropdown? pegawai;
  SetPegawai(this.pegawai);
}

abstract class AutoCompleteShiftState {
  List<DataDropdown>? listPegawai;
}

class GetPegawaiSuccess extends AutoCompleteShiftState {
  GetPegawaiSuccess(List<DataDropdown>? _listPegawai) {
    listPegawai = _listPegawai;
  }
}

class SetPegawaiSuccess extends AutoCompleteShiftState {
  DataDropdown? pegawai;
  SetPegawaiSuccess(this.pegawai);
}

class ErrorState extends AutoCompleteShiftState {}

class ProgressState extends AutoCompleteShiftState {}

class AutoCompleteShiftBloc
    extends Bloc<AutoCompleteShiftEvent, AutoCompleteShiftState> {
  List<DataDropdown>? listPegawai = <DataDropdown>[];

  AutoCompleteShiftBloc(AutoCompleteShiftState initialState)
      : super(initialState);

  @override
  Stream<AutoCompleteShiftState> mapEventToState(
      AutoCompleteShiftEvent event) async* {
    if (event is GetPegawai) {
      yield ProgressState();
      listPegawai!.clear();
      if (event.keywords != null && event.keywords != '') {
        DropdownRespon dropdownRespon =
            await DropdownApi().getPegawai(event.keywords, event.modelFilter);
        if (dropdownRespon.success!) {
          listPegawai = dropdownRespon.data;
          yield GetPegawaiSuccess(listPegawai);
        } else {
          yield ErrorState();
        }
      }
    } else if (event is SetPegawai) {
      yield SetPegawaiSuccess(event.pegawai);
    }
  }
}
