import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompleteFilterPerusahaanBloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';
import '../../style.dart';
import '../../templateForm.dart';
// ignore: must_be_immutable
// class AutoCompletePerusahaanFilterKanban extends StatefulWidget {
//   ModelFilter? modelFilter;
//   String? initialData;
//   double? formHeight;
//   double? radius;
//   String? title;
//   double? fontSize;
//   Icon? prefixIcon;
//   AutoCompletePerusahaanFilterKanban(this.modelFilter,{this.radius, this.formHeight, this.initialData, this.title, this.prefixIcon, this.fontSize});
//   @override
//   _AutoCompletePerusahaanFilterKanbanState createState() => _AutoCompletePerusahaanFilterKanbanState();
// }
//
// class _AutoCompletePerusahaanFilterKanbanState extends State<AutoCompletePerusahaanFilterKanban> {
//   TextEditingController keyword = new TextEditingController();
//   ModelFilter modelFilter = new ModelFilter();
//   bool openDropdown = false;
//   DataDropdown? selectedPerusahaan;
//
//   @override
//   void initState() {
//     super.initState();
//     modelFilter = new ModelFilter();
//     keyword.addListener(cariListener);
//   }
//
//   cariListener() {
//     BlocProvider.of<AutoCompleteFilterPerusahaanBloc>(context).add(GetFilterPerusahaan(keyword.text));
//     if(keyword.text.trim().isNotEmpty){
//       setState(() {
//         openDropdown = true;
//       });
//     }else{
//       setState(() {
//         openDropdown = false;
//       });
//     }
//
//   }
//
//   @override
//   Widget build(BuildContext context) {
//     return  FutureBuilder<String>(
//         future: PengaturanBahasa().getDataBahasa(),
//         builder: (context, snapshot) {
//           return Container(
//             margin: EdgeInsets.only(bottom: 12),
//             child: Column(
//               crossAxisAlignment: CrossAxisAlignment.start,
//               children: <Widget>[
//                 BlocBuilder<AutoCompleteFilterPerusahaanBloc, AutoCompleteFilterPerusahaanState>(
//                   builder: (BuildContext context, AutoCompleteFilterPerusahaanState state){
//                     if(state is SetFilterPerusahaanSuccess && state.perusahaan!=null) {
//                       selectedPerusahaan = state.perusahaan;
//                       return TemplateFormFilterKanban(
//                         fontSize:widget.fontSize??null,
//                         titleText:widget.title??null,
//                         prefixIcon: widget.prefixIcon??null,
//                         hintText: selectedPerusahaan!=null?selectedPerusahaan!.nama: snapshot.data == null || snapshot.data == 'en' ? "All Customer" : "Semua Pelanggan",
//                         controller: keyword,
//                         color: CustomStyle.fontColorBlack,
//                         formHeight: widget.formHeight,
//                         radius: widget.radius,
//                         bottomMargin: 0,
//                         buttonEnd: GestureDetector(
//                             onTap: ()=>BlocProvider.of<AutoCompleteFilterPerusahaanBloc>(context).add(SetFilterPerusahaan(null)),
//                             child: Icon(Icons.close, color: Colors.red, size: 22,)),
//                       );
//                     }
//                     else {
//                       selectedPerusahaan = null;
//                       return TemplateFormFilterKanban(
//                         fontSize:widget.fontSize??null,
//                         titleText:widget.title??null,
//                         prefixIcon: widget.prefixIcon??null,
//                         hintText: selectedPerusahaan!=null?selectedPerusahaan!.nama:snapshot.data == null || snapshot.data == 'en' ? "All Customer" : "Semua Pelanggan",
//                         controller: keyword,
//                         color: CustomStyle.fontColorBlack,
//                         formHeight: widget.formHeight,
//                         radius: widget.radius,
//                         bottomMargin: 0,);
//                     }},
//                 ),
//                 openDropdown?BlocBuilder<AutoCompleteFilterPerusahaanBloc, AutoCompleteFilterPerusahaanState>(
//                     builder: (BuildContext context, AutoCompleteFilterPerusahaanState state){
//                       if(state is GetFilterPerusahaanSuccess) return Container(
//                         margin: EdgeInsets.only(top: 6),
//                         padding: EdgeInsets.fromLTRB(8,4,8,12),
//                         decoration: BoxDecoration(
//                             boxShadow: [
//                               BoxShadow(
//                                 color: Colors.grey.withOpacity(0.16),
//                                 spreadRadius: 1,
//                                 blurRadius: 7,
//                                 offset: Offset(0, 1), // changes position of shadow
//                               ),
//                             ],
//                             color: Colors.white,
//                             borderRadius: new BorderRadius.all(Radius.circular(0))
//                         ),
//                         child: Column(
//                           crossAxisAlignment: CrossAxisAlignment.start,
//                           children: state.listPerusahaan!
//                               .map((item) => templateContentAutoComplete(item))
//                               .toList(),
//                         ),
//                       );
//                       else if(state is ProgressState) return Container(
//                           height: 100,
//                           child: Center(child: CircularProgressIndicator(strokeWidth: 8,)));
//                       else return Container(
//                             height: 100,
//                             child: Center(child: Text(snapshot.data == null || snapshot.data == 'en' ? "Customer not found" : "Pelanggan tidak ditemukan", style: TextStyle(fontSize: CustomStyle.fontSizeSmall),),));
//                     }):Container(),
//               ],
//             ),
//           );
//         }
//     );
//
//
//
//   }
//
//   Widget templateContentAutoComplete(DataDropdown data){
//     return GestureDetector(
//       onTap: (){
//         setState(() {
//           keyword.text = "";
//           selectedPerusahaan = data;
//           openDropdown = false;
//           FocusScopeNode currentFocus = FocusScope.of(context);
//
//           if (!currentFocus.hasPrimaryFocus) {
//             currentFocus.unfocus();
//           }
//         });
//         BlocProvider.of<AutoCompleteFilterPerusahaanBloc>(context).add(SetFilterPerusahaan(data));
//       },
//       child: Container(
//           width: MediaQuery.of(context).size.width,
//           decoration: BoxDecoration(
//               border: Border(
//                 bottom: BorderSide( //                   <--- left side
//                   color: Colors.grey[300]!,
//                   width: 0.5,
//                 ),
//               )),
//           padding: EdgeInsets.fromLTRB(14,16,14,16),
//           child: Text(data.nama!, style: TextStyle(fontSize: widget.fontSize??CustomStyle.fontSizeSmall),)),
//     );
//   }
// }


// ignore: must_be_immutable
class AutoCompletePerusahaanFilterKanban extends StatefulWidget {
  ModelFilter? modelFilter;
  String title;
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  double marginHorizontal;
  AutoCompletePerusahaanFilterKanban(this.modelFilter, this.title, {this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.marginHorizontal = 0});

  @override
  _AutoCompletePerusahaanFilterKanbanState createState() => _AutoCompletePerusahaanFilterKanbanState();
}

class _AutoCompletePerusahaanFilterKanbanState extends State<AutoCompletePerusahaanFilterKanban> {
  TextEditingController _controller = TextEditingController();
  ModelFilter modelFilter = new ModelFilter();

  @override
  void initState() {
    super.initState();
    modelFilter = new ModelFilter();
    // BlocProvider.of<AutoCompleteFilterPerusahaanBloc>(context).add(GetFilterPerusahaan(_controller.text));
    // if(widget.initialData != null){
    //   _controller.text = widget.initialData!;
    // }
    _controller.addListener(cariListener);
  }

  cariListener() {
    BlocProvider.of<AutoCompleteFilterPerusahaanBloc>(context).add(GetFilterPerusahaanNoLoading(_controller.text));
    // setState(() {
    //     openDropdown = true;
    // });
  }

  @override
  Widget build(BuildContext context) {
    if(widget.initialData != null){
      _controller.text = widget.initialData!;
    }
    return Container(
      margin: EdgeInsets.only(bottom: 12, top: 0, right: widget.marginHorizontal, left: widget.marginHorizontal),
      child: BlocBuilder<AutoCompleteFilterPerusahaanBloc, AutoCompleteFilterPerusahaanState>(
        builder: (BuildContext context, AutoCompleteFilterPerusahaanState state){
          if(state is GetFilterPerusahaanSuccess || state is SetFilterPerusahaanSuccess) return Container(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                SizedBox(height: 7),
                DropdownMenu(
                  dropdownMenuEntries: state.listPerusahaan!.map((item) {
                    return DropdownMenuEntry(
                        value: item,
                        label: item.nama!
                    );
                  }).toList(),
                  selectedTrailingIcon: Container(child: Text("data")),
                  inputDecorationTheme: InputDecorationTheme(
                    contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                    enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
                  ),
                  controller: _controller,
                  onSelected: (value)=>BlocProvider.of<AutoCompleteFilterPerusahaanBloc>(context).add(SetFilterPerusahaan(value)),
                  label: Row(
                    children: [
                      Text(widget.title, style: TextStyle( fontSize: widget.fontSize, fontWeight: FontWeight.w400)),
                      SizedBox(width: 7),
                      Text('*', style: TextStyle(color: Colors.red, fontSize: widget.fontSize)),
                    ],
                  ),
                  textStyle: TextStyle(fontSize: 13),
                  requestFocusOnTap: true,
                  width: MediaQuery.of(context).size.width-50,
                ),
              ],
            ),
          );
          else return Container(
            height: widget.formHeight??CustomStyle.formHeight,
            margin: EdgeInsets.only(top: 17),
            width: MediaQuery.of(context).size.width,
            child: Shimmer.fromColors(
              baseColor: Colors.grey[200]!,
              highlightColor: Colors.white,
              period: Duration(seconds: 4),
              child: Card(),
            ),
          );
        },
      ),
    );
  }
}