import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompleteFilterGroupAreaBloc.dart';
import 'package:absenkuv3/UI/Template/templateFormKanban.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../style.dart';

typedef void AutoCompleteGroupAreaFilterKanbanCallback(DataDropdown? val);
// ignore: must_be_immutable
class AutoCompleteGroupAreaFilterKanban extends StatefulWidget {
  ModelFilter? modelFilter;
  String? initialData;
  double? formHeight;
  double? radius;
  String? title;
  double? fontSize;
  Icon? prefixIcon;
  AutoCompleteGroupAreaFilterKanbanCallback? dataCallback;
  AutoCompleteGroupAreaFilterKanban(this.modelFilter,{this.radius, this.formHeight, this.initialData, this.title, this.prefixIcon, this.fontSize, this.dataCallback});
  @override
  _AutoCompleteGroupAreaFilterKanbanState createState() => _AutoCompleteGroupAreaFilterKanbanState();
}

class _AutoCompleteGroupAreaFilterKanbanState extends State<AutoCompleteGroupAreaFilterKanban> {
  TextEditingController keyword = new TextEditingController();
  // ModelFilter modelFilter = new ModelFilter();
  bool openDropdown = false;
  DataDropdown? selectedGroup;

  @override
  void initState() {
    super.initState();
    if(widget.modelFilter!.namaGroup != null){
      keyword.text = widget.modelFilter!.namaGroup!;
      selectedGroup = DataDropdown(id: widget.modelFilter!.idGroup, nama: widget.modelFilter!.namaGroup);
      keyword.addListener(cariListener);
    }else{
      keyword.addListener(cariListener);
    }

  }

  cariListener() {
    BlocProvider.of<AutoCompleteFilterGroupAreaBloc>(context).add(GetFilterGroupAreaNoLoading(keyword.text));
    // setState(() {
        openDropdown = true;
    // });
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return Container(
            margin: EdgeInsets.only(bottom: 12),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                BlocBuilder<AutoCompleteFilterGroupAreaBloc, AutoCompleteFilterGroupAreaState>(
                  builder: (BuildContext context, AutoCompleteFilterGroupAreaState state){
                    if(state is SetFilterGroupAreaSuccess && state.GroupArea!=null) {
                      selectedGroup = state.GroupArea;
                      return TemplateFormKanban(
                        fontSize:widget.fontSize??null,
                        titleText:widget.title??null,
                        prefixIcon: widget.prefixIcon??null,
                        hintText: selectedGroup!=null?selectedGroup!.nama: snapshot.data == null || snapshot.data == 'en' ? "All Group / Area" : "Semua Group / Area",
                        controller: keyword,
                        color: CustomStyle.fontColorBlack,
                        formHeight: widget.formHeight,
                        radius: widget.radius,
                        contentPadding: EdgeInsets.fromLTRB(0, 0, 0, 21),
                        bottomMargin: 0,
                        dataCallback: (v){
                          if(v == false){
                            setState(() {
                              openDropdown = false;
                            });
                          }
                        },
                        suffixIcon: GestureDetector(
                            onTap: (){
                              setState(() {
                                selectedGroup = null;
                                keyword.clear();
                                openDropdown = false;
                                widget.dataCallback!(null);
                              });
                            },
                            child: Container(
                                margin: EdgeInsets.only(bottom: 13),
                                child: Icon(Icons.close, color: Colors.red, size: 22,)))
                      );
                    }
                    else {
                      if(state is SetFilterGroupAreaSuccess && state.GroupArea == null) {
                        keyword.text = "";
                        openDropdown = false;
                      }
                      if(keyword.text.trim().isEmpty){
                        selectedGroup = null;
                      }
                      return TemplateFormKanban(
                        fontSize:widget.fontSize??null,
                        titleText:widget.title??null,
                        prefixIcon: widget.prefixIcon??null,
                        hintText: selectedGroup!=null?selectedGroup!.nama:snapshot.data == null || snapshot.data == 'en' ? "All Group / Area" : "Semua Group / Area",
                        controller: keyword,
                        color: CustomStyle.fontColorBlack,
                        suffixIcon: selectedGroup!=null
                            ? GestureDetector(
                                onTap: (){
                                  setState(() {
                                    selectedGroup = null;
                                    keyword.clear();
                                    openDropdown = false;
                                    widget.dataCallback!(null);
                                  });
                                },
                                child: Container(
                                  margin: EdgeInsets.only(bottom: 13),
                                  child: Icon(Icons.close, color: Colors.red, size: 22,)))
                            : Container(
                                margin: EdgeInsets.only(bottom: 13),
                                child: Icon(Icons.arrow_drop_down)),
                        formHeight: widget.formHeight,
                        radius: widget.radius,
                        contentPadding: EdgeInsets.fromLTRB(0, 0, 0, 21),
                        dataCallback: (v){
                          if(v == false){
                            setState(() {
                              openDropdown = false;
                            });
                          }else{
                            setState(() {
                              openDropdown = true;
                            });
                          }
                        },
                        bottomMargin: 0,);
                    }},
                ),
                openDropdown?BlocBuilder<AutoCompleteFilterGroupAreaBloc, AutoCompleteFilterGroupAreaState>(
                    builder: (BuildContext context, AutoCompleteFilterGroupAreaState state){
                      if(state is GetFilterGroupAreaSuccess) return Container(
                        margin: EdgeInsets.only(top: 6),
                        padding: EdgeInsets.fromLTRB(8,4,8,12),
                        decoration: BoxDecoration(
                            boxShadow: [
                              BoxShadow(
                                color: Colors.grey.withOpacity(0.16),
                                spreadRadius: 1,
                                blurRadius: 7,
                                offset: Offset(0, 1), // changes position of shadow
                              ),
                            ],
                            color: Colors.white,
                            borderRadius: new BorderRadius.all(Radius.circular(0))
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: state.listGroupArea!
                              .map((item) => templateContentAutoComplete(item))
                              .toList(),
                        ),
                      );
                      else if(state is GroupProgressState) return Container(
                          height: 100,
                          child: Center(child: CircularProgressIndicator(strokeWidth: 8,)));
                      else return Container(
                            height: 100,
                            child: Center(child: Text(snapshot.data == null || snapshot.data == 'en' ? "Group not found" : "Group tidak ditemukan", style: TextStyle(fontSize: CustomStyle.fontSizeSmall),),));
                    }):Container(),
              ],
            ),
          );
        }
    );
  
  }

  Widget templateContentAutoComplete(DataDropdown data){
    return GestureDetector(
      onTap: (){
        setState(() {
          keyword.text = data.nama!;
          selectedGroup = data;
          openDropdown = false;
          widget.dataCallback!(selectedGroup);
          FocusScopeNode currentFocus = FocusScope.of(context);

          if (!currentFocus.hasPrimaryFocus) {
            currentFocus.unfocus();
          }
        });
      },
      child: Container(
          width: MediaQuery.of(context).size.width,
          decoration: BoxDecoration(
              border: Border(
                bottom: BorderSide(
                  color: Colors.grey[300]!,
                  width: 0.5,
                ),
              )),
          padding: EdgeInsets.fromLTRB(14,16,14,16),
          child: Text(data.nama!, style: TextStyle(fontSize: widget.fontSize??CustomStyle.fontSizeSmall),)),
    );
  }
}
