import 'package:absenkuv3/Bloc/Shift/TukarShiftBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mTukarShift.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateForm.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import '../../../../Bloc/CustomFunction.dart';

class TemplateDialogKeterangan {
  openDialogKeterangan(
      BuildContext context,
      ModelTukarShift model,
      GlobalKey<ScaffoldState> scaffoldKey,
      GlobalKey<FormState> formKey, String jenis, String konteks, PageTukarShiftModel redaksional) {
    TextEditingController keterangan = new TextEditingController();
    final GlobalKey<FormState> formKey = GlobalKey<FormState>();

    showDialog(
        context: context,
        builder: (BuildContext context) {
          return Container(
            child: AlertDialog(
              titlePadding: EdgeInsets.zero,
              title: Container(
                  height: MediaQuery.of(context).size.height * 0.07,
                  child: Center(
                      child: Text(redaksional.menuTukarShift!.data!.header!, style: TextStyle(color: Colors.white))),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.only(topLeft: Radius.circular(10.0), topRight: Radius.circular(10.0)),
                    color: CustomStyle.color1,
                  )
              ),
              content: templateContent(context, model, scaffoldKey, formKey, keterangan, jenis, konteks, redaksional),
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(10.0),
              ),
            ),
          );
        });
  }

  Widget templateContent(BuildContext context, ModelTukarShift model, GlobalKey<ScaffoldState> scaffoldKey, GlobalKey<FormState> formKey, TextEditingController keterangan, String jenis, String konteks, PageTukarShiftModel redaksional){
    return Container(
      width: MediaQuery.of(context).size.width,
      child: Stack(
        children: [
          SingleChildScrollView(
            child: Column(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    decoration: BoxDecoration(
                        border: Border.all(width: 0.5, color: CustomStyle.fontColorGrey!),
                        borderRadius: new BorderRadius.all(Radius.circular(10))),
                    child: Padding(
                      padding: const EdgeInsets.all(8.0),
                      child: Column(
                        children: [
                          Row(
                            children: [
                              Icon(Icons.calendar_month, color: CustomStyle.fontColorGrey),
                              SizedBox(width: 10),
                              Container(
                                  child: Text(
                                      DateFormat('EEEE, d MMMM yyyy', redaksional.menuTukarShift!.locale).format(DateTime.parse(model.tglShift!)).toUpperCase(),
                                      style: TextStyle(
                                          fontSize: CustomStyle.fontSizeSmall,
                                          fontWeight: FontWeight.w500,
                                          color: CustomStyle.fontColorGrey))),
                            ],
                          ),
                          SizedBox(height: 2),
                          Divider(thickness: 1),
                          SizedBox(height: 3),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: Column(
                                  children: [
                                    Text(redaksional.menuTukarShift!.data!.shiftAnda!, style: TextStyle(
                                        fontSize: CustomStyle.fontSizeSmall,
                                        color: Colors.black)),
                                    SizedBox(height: 7),
                                    Container(
                                      padding: EdgeInsets.fromLTRB(10, 10, 10, 10),
                                      decoration: BoxDecoration(
                                          border: Border.all(width: 0.3, color: CustomStyle.fontColorGrey!),
                                          borderRadius: new BorderRadius.all(Radius.circular(10))),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          Text(model.namaShiftAwal.toString(),
                                            textScaleFactor: 1.0,
                                            style: TextStyle(fontSize: CustomStyle.fontSizeSmall, fontWeight: FontWeight.bold),
                                          ),
                                          SizedBox(height: 2),
                                          Text(model.masukAwal.toString() + ' - '+model.pulangAwal.toString(),
                                            textScaleFactor: 1.0,
                                            style: TextStyle(
                                                fontSize: CustomStyle.fontSizeSmall - 1,
                                                color: CustomStyle.fontColorGrey),
                                          ),
                                          SizedBox(height: 2),
                                          Text(model.kodeShiftAwal.toString(),
                                            textScaleFactor: 1.0,
                                            style: TextStyle(
                                                fontSize: CustomStyle.fontSizeSmall - 1,
                                                color: CustomStyle.fontColorGrey),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              SizedBox(width: 5),
                              Column(
                                children: [
                                  Icon(
                                      Icons.arrow_forward,
                                      color: CustomStyle.fontColorGrey,
                                      size: 15),
                                  Icon(
                                      Icons.arrow_back,
                                      color: CustomStyle.fontColorGrey,
                                      size: 15),
                                ],
                              ),
                              SizedBox(width: 5),
                              Expanded(
                                child: Column(
                                  children: [
                                    Text(redaksional.menuTukarShift!.data!.shiftTeman!,
                                        style: TextStyle(
                                            fontSize: CustomStyle.fontSizeSmall,
                                            color: Colors.black)),
                                    SizedBox(height: 7),
                                    Container(
                                      padding: EdgeInsets.fromLTRB(10, 10, 10, 10),
                                      decoration: BoxDecoration(
                                          border: Border.all(width: 0.3, color: CustomStyle.fontColorGrey!),
                                          borderRadius: new BorderRadius.all(Radius.circular(10))),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          Text(model.namaShiftBaru.toString(),
                                              textScaleFactor: 1.0,
                                              style: TextStyle(
                                                  fontSize: CustomStyle.fontSizeSmall,
                                                  fontWeight: FontWeight.bold)),
                                          SizedBox(height: 2),
                                          Text(model.masukBaru.toString() + ' - ' + model.pulangBaru.toString(),
                                              textScaleFactor: 1.0,
                                              style: TextStyle(
                                                  fontSize: CustomStyle.fontSizeSmall - 1,
                                                  color: CustomStyle.fontColorGrey)),
                                          SizedBox(height: 2),
                                          Text(model.kodeShiftBaru.toString(),
                                            textScaleFactor: 1.0,
                                            style: TextStyle(
                                                fontSize: CustomStyle.fontSizeSmall - 1,
                                                color: CustomStyle.fontColorGrey),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ],
                          ),
                          SizedBox(height: 10),
                        ],
                      ),
                    ),
                  ),
                  SizedBox(height: 10),
                  TemplateForm(
                    minLine: 5,
                    maxLine: 5,
                    formHeight: 85,
                    adaValidasi: true,
                    controller: keterangan,
                    color: CustomStyle.fontColorGrey,
                    titleText: redaksional.menuTukarShift!.data!.keterangan,
                    radius: CustomStyle.formRadius,
                    contentPadding: EdgeInsets.all(7),
                    hintText: redaksional.menuTukarShift!.data!.keterangan,
                    buttonEnd: Container(),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceAround,
                    children: [
                      Expanded(
                          child: TemplateButton(
                              radius: 10,
                              bold: true,
                              color: Colors.grey,
                              contentColor: Colors.white,
                              expandText: false,
                              fontSize: 13,
                              label: redaksional.menuTukarShift!.button!.btnBack,
                              onClick: () {
                                Navigator.of(context).pop();
                              })),
                      SizedBox(width: 9),
                      Expanded(
                          child: TemplateButton(
                              radius: 10,
                              bold: true,
                              color: CustomStyle.color1,
                              contentColor: Colors.white,
                              fontSize: 13,
                              expandText: false,
                              label: redaksional.menuTukarShift!.button!.btnSubmit,
                              onClick: () {
                                ModelTukarShift model2 = model;
                                model2.keterangan = keterangan.text;
                                if(keterangan.text.trim() == ""){
                                  showSnackBarDelayed(scaffoldKey, redaksional.menuTukarShift!.data!.messageKeteranganEmpty, context);
                                }else{
                                  BlocProvider.of<TukarShiftBloc>(context).add(
                                      pengajuanTukarShift(
                                          model2,
                                          context,
                                          scaffoldKey,
                                          formKey,
                                          ModelFilter(),
                                          konteks));






                                  // BlocProvider.of<DraftTukarShiftBloc>(context).add(
                                  //     masukkanDraftTukarShift(
                                  //         model2,
                                  //         context,
                                  //         scaffoldKey,
                                  //         formKey,
                                  //         ModelFilter(),
                                  //         'ShiftTeman',
                                  //         jenis));
                                }
                              })),
                    ],
                  )
                ]),
          ),
          // Positioned(
          //     width: MediaQuery.of(context).size.width * 0.65,
          //     bottom: 5,
          //     child: Row(
          //       mainAxisAlignment: MainAxisAlignment.spaceBetween,
          //       children: [
          //         Container(
          //             width: MediaQuery.of(context).size.width / 4,
          //             child: TemplateButton(
          //                 radius: 10,
          //                 bold: true,
          //                 color: Colors.grey,
          //                 contentColor: Colors.white,
          //                 expandText: false,
          //                 fontSize: 13,
          //                 label: 'Kembali',
          //                 onClick: () {
          //                   Navigator.of(context).pop();
          //                 })),
          //         Container(
          //             width: MediaQuery.of(context).size.width / 4,
          //             child: TemplateButton(
          //                 radius: 10,
          //                 bold: true,
          //                 color: CustomStyle.color1,
          //                 contentColor: Colors.white,
          //                 fontSize: 13,
          //                 expandText: false,
          //                 label: 'Ajukan',
          //                 onClick: () {
          //                   ModelTukarShift model2 = model;
          //                   model2.keterangan = keterangan.text;
          //                   BlocProvider.of<ShiftBloc>(context).add(
          //                       pengajuanTukarShift(
          //                           model2,
          //                           context,
          //                           scaffoldKey,
          //                           formKey,
          //                           ModelFilter(),
          //                           'ShiftTeman'));
          //                 })),
          //       ],
          //     ))
        ],
      ),
    );
  }

  openDialogKeteranganJadwalTeman(BuildContext context, ModelTukarShift model, GlobalKey<ScaffoldState> scaffoldKey, GlobalKey<FormState> formKey, String jenis, String konteks, PageTukarShiftModel redaksional) {
    TextEditingController keterangan = new TextEditingController();

    showDialog(
        context: context,
        builder: (BuildContext context) {
          return Container(
            child: AlertDialog(
              titlePadding: EdgeInsets.zero,
              title: Container(
                height: MediaQuery.of(context).size.height * 0.07,
                child: Center(child: Text(redaksional.menuTukarShift!.data!.header!, style: TextStyle(color: Colors.white))),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.only(
                    topLeft: Radius.circular(10.0),
                    topRight: Radius.circular(10.0),
                  ),
                  color: CustomStyle.color1,
                ),
              ),
              content: BlocBuilder<TukarShiftBloc, TukarShiftState>(
                  builder: (BuildContext context, TukarShiftState state) {
                    if (state is getListShiftTemanSuccessState || state is LoadMoreTukarShiftProgressState) {
                      model.kodeShiftAwal = state.datum![0].kodeShift;
                      model.namaShiftAwal = state.datum![0].namaShift;
                      model.masukAwal = state.datum![0].masuk;
                      model.pulangAwal = state.datum![0].pulang;
                      return templateContent(
                          context, model, scaffoldKey, formKey,
                          keterangan, jenis, konteks, redaksional);
                    }
                    else  return Container(
                      width: MediaQuery.of(context).size.width / 3 * 2,
                      height: MediaQuery.of(context).size.height / 3,
                      child: Center(child: CircularProgressIndicator(strokeWidth: 8,color: CustomStyle.color1,),),
                    );
                  }
              ),
              shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10.0)),
            ),
          );
        });
  }
}