import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Shift/PilihShiftBloc.dart';
import 'package:absenkuv3/Bloc/Shift/TukarShiftBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mShiftTeman.dart';
import 'package:absenkuv3/Repository/Model/mTukarShift.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Shift/KomponenShift.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/Template/TemplateDialogKeterangan.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateForm.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

class BottomSheetContent extends StatefulWidget {
  final String? tanggal;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final GlobalKey<FormState> formKey;
  final Datum data;
  final bool tukarShift; // TRUE = TUKAR SHIFT; FALSE = TUKAR OFF
  final String konteks;
  final PageTukarShiftModel redaksional;
  BottomSheetContent(this.tanggal, this.scaffoldKey, this.formKey, this.data, this.tukarShift, this.konteks, this.redaksional);

  @override
  State<BottomSheetContent> createState() => _BottomSheetContentState();
}

class _BottomSheetContentState extends State<BottomSheetContent> {
  TextEditingController keyword = TextEditingController();
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  Datum? Shift;

  @override
  void initState() {
    BlocProvider.of<TukarShiftBloc>(context)
        .add(getListShiftTemanEvent(context, widget.tanggal!, '', widget.tukarShift?'tukar_shift':'tukar_off'));
    keyword.addListener(cariListener);
    _scrollController.addListener(() => BlocProvider.of<TukarShiftBloc>(context)
        .add(LoadMoreListShiftTemanEvent(
            context, widget.tanggal!, '', widget.tukarShift?'tukar_shift':'tukar_off', _scrollController)));
    super.initState();
  }

  cariListener() {
    if (keyword.text.length > 2) {
      BlocProvider.of<TukarShiftBloc>(context)
          .add(getListShiftTemanEvent(context, widget.tanggal!, keyword.text, widget.tukarShift?'tukar_shift':'tukar_off'));
    }
  }

  VoidCallback? handleRadioValueChange1(Datum? value) {
    BlocProvider.of<PilihShiftBloc>(context).add(SetShift(value!));
    return null;
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: BlocBuilder<TukarShiftBloc, TukarShiftState>(
          builder: (BuildContext context, TukarShiftState state) {
            return BlocBuilder<PilihShiftBloc, Datum>(
              builder: (BuildContext context, Datum state2) {
                Shift = state2;
                return Container(
                  child: SingleChildScrollView(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                            padding: EdgeInsets.only(left: 10, top: 10, right: 10),
                            child: Text(widget.tukarShift?widget.redaksional.menuTukarShift!.data!.pilihShift! : widget.redaksional.menuTukarShift!.data!.pilihTeman!, style: TextStyle(fontWeight: FontWeight.bold, fontSize: 14),)),
                        Padding(
                          padding: EdgeInsets.only(left: 10, top: 10, right: 10, bottom: 7),
                          child: Container(
                            width: MediaQuery.of(context).size.width - 20,
                            child: TemplateForm(
                                fontSize: CustomStyle.fontSizeNormal-2,
                                prefixIcon: Icon(
                                  Icons.search,
                                  size: 20,
                                ),
                                hintText: widget.tukarShift?widget.redaksional.menuTukarShift!.data!.cariShift:widget.redaksional.menuTukarShift!.data!.cariNama,
                                controller: keyword,
                                color: CustomStyle.fontColorBlack,
                                formHeight: 35,
                                radius: CustomStyle.formRadius,
                                bottomMargin: 0,
                                buttonEnd: keyword.text.length != 0
                                    ? GestureDetector(
                                    onTap: () {
                                      keyword.clear();
                                      BlocProvider.of<TukarShiftBloc>(context)
                                          .add(getListShiftTemanEvent(context, widget.tanggal!, '', widget.tukarShift?'tukar_shift':'tukar_off'));
                                    },
                                    child: Icon(
                                      Icons.close,
                                      color: Colors.red,
                                      size: 22,
                                    ))
                                    : Container()),
                          ),
                        ),
                        state is getListShiftTemanSuccessState || state is LoadMoreShiftTemanProgressState
                            ? Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Divider(thickness: 1.5, indent: 9, endIndent: 9),
                            SizedBox(height: MediaQuery.of(context).size.height * 0.008),
                            Container(
                              height: MediaQuery.of(context).size.height / 3.5,
                              child: ListView.builder(
                                  controller: _scrollController,
                                  itemCount: state.datum!.length,
                                  itemBuilder: (BuildContext context, i) {
                                    return Container(
                                      padding: const EdgeInsets.only(left: 10.0, right: 10),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.center,
                                        children: [
                                          Container(
                                            padding: EdgeInsets.fromLTRB(5, 10, 5, 10),
                                            decoration: BoxDecoration(
                                                border: Border.all(width: 0.5, color: CustomStyle.fontColorGrey!),
                                                color: !state.datum![i].enabled! ? Colors.grey.shade300 : Colors.white,
                                                borderRadius: new BorderRadius.all(Radius.circular(10))),
                                            child: Row(
                                              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                              children: [
                                                SizedBox(width: 10),
                                                Container(
                                                  width: MediaQuery.of(context).size.width * 0.075,
                                                  child: Column(
                                                    crossAxisAlignment: CrossAxisAlignment.center,
                                                    children: [
                                                      Text(DateFormat('EE', widget.redaksional.menuTukarShift!.locale).format(DateTime.parse(widget.tanggal!)).toUpperCase(),
                                                          style: TextStyle(
                                                              fontSize: 12,
                                                              color: CustomStyle.fontColorGrey,
                                                              fontWeight: FontWeight.w400)),
                                                      SizedBox(height: 2),
                                                      Text(DateFormat('dd').format(DateTime.parse(widget.tanggal!)),
                                                          style: TextStyle(
                                                              fontSize: 16,
                                                              fontWeight: FontWeight.w600)),
                                                      SizedBox(height: 2),
                                                      Text(
                                                          DateFormat('MMM').format(DateTime.parse(widget.tanggal!)),
                                                          style: TextStyle(
                                                              fontSize: 12,
                                                              color: CustomStyle.fontColorGrey,
                                                              fontWeight: FontWeight.w400)),
                                                    ],
                                                  ),
                                                ),
                                                SizedBox(width: 10),
                                                VerticalDividerWidget(color: Colors.grey, height: 50),
                                                SizedBox(width: 10),
                                                Container(
                                                  width: MediaQuery.of(context).size.width * 0.6,
                                                  child: Column(
                                                    crossAxisAlignment: CrossAxisAlignment.start,
                                                    children: [
                                                      Text(
                                                          state.datum![i].kodeShift! + ' - ' + state.datum![i].namaShift!,
                                                          textScaleFactor: 1.0,
                                                          style: TextStyle(
                                                              fontSize: 13,
                                                              fontWeight: FontWeight.bold)),
                                                      SizedBox(height: 5),
                                                      Text(
                                                          state.datum![i].masuk.toString() + ' - ' + state.datum![i].pulang.toString(),
                                                          textScaleFactor: 1.0,
                                                          style: TextStyle(fontSize: 12)),
                                                      SizedBox(height: 5),
                                                      state.datum![i].namaLengkap!.isEmpty
                                                          ? Container()
                                                          : Text(state.datum![i].nik! + ' - ' + state.datum![i].namaLengkap.toString(),
                                                          textScaleFactor: 1.0,
                                                          maxLines: 2,
                                                          style: TextStyle(fontSize: 12)),
                                                    ],
                                                  ),
                                                ),
                                                !state.datum![i].enabled! ? Container() :
                                                Radio<Datum?>(
                                                  materialTapTargetSize: MaterialTapTargetSize.padded,
                                                  value: state.datum![i],
                                                  activeColor: CustomStyle.color1,
                                                  groupValue: Shift,
                                                  onChanged: handleRadioValueChange1,
                                                ),
                                              ],
                                            ),
                                          ),
                                          SizedBox(height: 10)
                                        ],
                                      ),
                                    );
                                  }),
                            ),
                            state is LoadMoreShiftTemanProgressState
                                ? Center(child: CircularProgressIndicator(strokeWidth: 8))
                                : Container(),
                            Container(
                              height: MediaQuery.of(context).size.height * 0.1,
                              width: MediaQuery.of(context).size.width,
                              color: Colors.white12,
                              child: Padding(
                                padding: const EdgeInsets.only(left: 10.0, right: 10.0),
                                child: Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      GestureDetector(
                                        onTap: () {
                                          BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
                                        },
                                        child: Container(
                                          width: MediaQuery.of(context).size.width / 2.5,
                                          height: MediaQuery.of(context).size.height * 0.06,
                                          decoration: BoxDecoration(
                                              border: Border.all(width: 1.5, color: CustomStyle.color1),
                                              color: Colors.white12,
                                              borderRadius: BorderRadius.all(Radius.circular(20))),
                                          child: Center(
                                              child: Text(widget.redaksional.menuTukarShift!.button!.btnCancel!,
                                                style: TextStyle(
                                                    color: CustomStyle.color1,
                                                    fontSize: 15,
                                                    fontWeight: FontWeight.bold),
                                              )),
                                        ),
                                      ),
                                      GestureDetector(
                                        onTap: () async {
                                          if(state2.kodeShift == null){
                                            showSnackBarDelayed(scaffoldKey, widget.redaksional.menuTukarShift!.data!.messageBelumPilihShift, context);
                                          }else{
                                            ModelTukarShift model = ModelTukarShift(
                                                widget.tanggal,
                                                widget.data.kodeShift,
                                                widget.data.namaShift,
                                                widget.data.masuk,
                                                widget.data.pulang,
                                                state2.idKaryawan,
                                                state2.kodeShift,
                                                state2.namaShift,
                                                state2.masuk,
                                                state2.pulang,
                                                'tukar-shift');
                                            TemplateDialogKeterangan().openDialogKeterangan(
                                                context,
                                                model,
                                                widget.scaffoldKey,
                                                widget.formKey, widget.tukarShift?'tukar_shift':'tukar_off', widget.konteks, widget.redaksional);
                                          }
                                        },
                                        child: Container(
                                          width: MediaQuery.of(context).size.width / 2.5,
                                          height: MediaQuery.of(context).size.height * 0.06,
                                          decoration: BoxDecoration(
                                              color: CustomStyle.color1,
                                              borderRadius: BorderRadius.all(Radius.circular(20))),
                                          child: Center(
                                              child: Text(widget.redaksional.menuTukarShift!.button!.btnNext!,
                                                  style: TextStyle(
                                                      color: Colors.white,
                                                      fontSize: 15,
                                                      fontWeight: FontWeight.bold))),
                                        ),
                                      )
                                    ]),
                              ),
                            ),
                          ],
                        )
                            : state is TukarShiftProgressState
                            ? Center(
                          child: Container(
                            height: MediaQuery.of(context).size.height / 2.5,
                            child: Center(
                                child: CircularProgressIndicator(
                                  color: CustomStyle.color1,
                                  strokeWidth: 8,
                                )),
                          ),
                        )
                            : Center(
                          child: Container(
                            height: MediaQuery.of(context).size.height / 2.5,
                            child: Center(
                              child: Container(
                                height: MediaQuery.of(context).size.height / 5,
                                child: Image.asset(ValueImage.noData),
                              ),
                            ),
                          ),
                        )
                      ],
                    ),
                  ),
                );
              },
            );
          }),
    )

      ;
  }
}
