import 'package:absenkuv3/Bloc/Shift/TukarShiftBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/Template/KomponenPengajuan.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ListPengajuanTeman extends StatefulWidget {
  final PageTukarShiftModel redaksional;
  ListPengajuanTeman(this.redaksional);

  @override
  State<ListPengajuanTeman> createState() => _ListPengajuanTemanState();
}

class _ListPengajuanTemanState extends State<ListPengajuanTeman> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  final GlobalKey<FormState> formKey = GlobalKey<FormState>();

  @override
  void initState() {
    BlocProvider.of<TukarShiftBloc>(context).add(getListPermintaanEvent(context));
    super.initState();
    _scrollController.addListener(()=>BlocProvider.of<TukarShiftBloc>(context).add(loadMoreTukarShiftTemanEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<TukarShiftBloc, TukarShiftState>(
              builder: (BuildContext context, TukarShiftState state) {
                print(state);
                print('status teman');
                if (state is getListPengajuanTemanSuccessState ||
                    state is LoadMorePengajuanTukarShiftTamanProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.datumPengajuan!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardPengajuan(state.datumPengajuan![index],
                                'shiftTeman', scaffoldKey, formKey, widget.redaksional);
                          }),
                      state is LoadMorePengajuanTukarShiftTamanProgressState
                          ? Positioned(
                          bottom: 16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(
                                  child: CircularProgressIndicator(
                                    strokeWidth: 8,
                                    color: CustomStyle.color1,
                                  ))))
                          : Container(),
                    ],
                  );
                else if (state is TukarShiftProgressState)
                  return Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                      color: CustomStyle.color1,
                    ),
                  );
                else
                  return Center(
                    child: Image.asset(
                      ValueImage.noData,
                      height: 250,
                    ),
                  );
              }),
        ],
      ),
    );
  }
}
