import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Bloc/Shift/TukarShiftBloc.dart';
import 'package:absenkuv3/Bloc/Shift/TukarShiftDetailBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mPengajuanSaya.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

class HalamanDetailTukarShiftPengajuanSaya extends StatefulWidget {
  final data; //[0] = data, [1] = konteks
  HalamanDetailTukarShiftPengajuanSaya(this.data);

  @override
  _HalamanDetailTukarShiftPengajuanSayaState createState() =>
      _HalamanDetailTukarShiftPengajuanSayaState();
}

class _HalamanDetailTukarShiftPengajuanSayaState
    extends State<HalamanDetailTukarShiftPengajuanSaya> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  bool refresh = false;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<TukarShiftDetailBloc>(context)
        .add(GetListTukarShiftDetailEvent(context, widget.data![0], widget.data![1]));
    BlocProvider.of<NotifBloc>(context).add(BacaNotif(widget.data[0], 'shift', context));
  }

  Future<bool> keluar() async {
    Navigator.pop(context, refresh);
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageTukarShiftModel>(
        future: PengaturanBahasa().tukarShift(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocListener<NotifBloc, NotifState>(
                listener: (context, stateNotifBloc) {
                  if(stateNotifBloc is SuccessBacaNotifState){
                    refresh = true;
                  }
                },
              child: Scaffold(
                  key: scaffoldKey,
                  backgroundColor: Colors.white,
                  appBar: AppBar(
                    leading: IconButton(
                      icon: Icon(Icons.arrow_back, color: Colors.white),
                      onPressed: () => keluar(),
                    ),
                    flexibleSpace: Image(
                      image: AssetImage(ValueImage.headerBiruDashboard),
                      fit: BoxFit.cover,
                    ),
                    backgroundColor: Colors.transparent,
                    centerTitle: true,
                    title: Text(snapshot.data!.menuTukarShift!.tabDetail!,
                        style: TextStyle(fontSize: CustomStyle.fontSizeTitle)),
                  ),
                  body: BlocBuilder<TukarShiftDetailBloc, TukarShiftDetailState>(
                      builder: (BuildContext context, TukarShiftDetailState state) {
                        if (state is GetShiftDetailSuccessState) {
                          DataPengajuanSaya dataPengajuanSaya = state.data![0];
                          print(dataPengajuanSaya.button.toString());
                          return Stack(
                            children: [
                              Positioned(top: 0, left: 0, right: 0, bottom: 50,
                                child: Container(
                                  height: double.infinity,
                                  child: SingleChildScrollView(
                                    child: Padding(
                                      padding: const EdgeInsets.fromLTRB(16, 18, 16, 16),
                                      child: Column(
                                        mainAxisSize: MainAxisSize.min,
                                        children: [
                                          Container(
                                            margin: const EdgeInsets.only(bottom: 80),
                                            padding: const EdgeInsets.only(bottom: 12, top: 6),
                                            child: SingleChildScrollView(
                                              child: Column(
                                                crossAxisAlignment: CrossAxisAlignment.start,
                                                children: [
                                                  Row(
                                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                    children: [
                                                      Row(
                                                        children: [
                                                          Icon(Icons.calendar_month, size: 28),
                                                          SizedBox(width: 8),
                                                          TemplateColumn(
                                                              title: snapshot.data!.menuTukarShift!.data!.tanggalPengajuan,
                                                              value: dataPengajuanSaya.tglPengajuan),
                                                        ],
                                                      ),
                                                      Container(
                                                        padding: EdgeInsets.all(8),
                                                        decoration: BoxDecoration(
                                                          borderRadius: BorderRadius.circular(7),
                                                          color: Color(int.parse(dataPengajuanSaya.status!.color!)),
                                                        ),
                                                        child: Text(
                                                            dataPengajuanSaya.status!.status!,
                                                            style: TextStyle(
                                                                fontWeight: FontWeight.bold,
                                                                fontSize: 13,
                                                                color: Color(int.parse(dataPengajuanSaya.status!.fontColor!)))),
                                                      ),
                                                    ],
                                                  ),
                                                  SizedBox(height: 16),
                                                  Divider(),
                                                  TemplateColumn(title: snapshot.data!.menuTukarShift!.data!.nomor, value: dataPengajuanSaya.noPengajuan),
                                                  SizedBox(height: 16),
                                                  TemplateColumn(
                                                    title: snapshot.data!.menuTukarShift!.data!.ditukarDengan,
                                                    value: widget.data[1] == 'shiftTeman'
                                                        ? "${dataPengajuanSaya.shiftAwal!.nik} - ${dataPengajuanSaya.shiftAwal!.karyawan}"
                                                        : "${dataPengajuanSaya.shiftBaru!.nik} - ${dataPengajuanSaya.shiftBaru!.karyawan}",
                                                  ),
                                                  SizedBox(height: 16),
                                                  Container(
                                                    width: MediaQuery.of(context).size.width,
                                                    decoration: BoxDecoration(
                                                        border: Border.all(color: Colors.grey),
                                                        borderRadius: new BorderRadius.all(Radius.circular(8))),
                                                    child: Column(
                                                      crossAxisAlignment: CrossAxisAlignment.start,
                                                      children: [
                                                        Padding(
                                                          padding: const EdgeInsets.fromLTRB(13,7,7,7),
                                                          child: Row(
                                                            // crossAxisAlignment: CrossAxisAlignment.start,
                                                            children: [
                                                              Icon(Icons.calendar_month_sharp),
                                                              SizedBox(width: 8),
                                                              Column(
                                                                crossAxisAlignment: CrossAxisAlignment.start,
                                                                children: [
                                                                  Text(DateFormat('EEEE, d MMMM yyyy', snapshot.data!.menuTukarShift!.locale).format(DateTime.parse(dataPengajuanSaya.tglShift!)).toUpperCase(),
                                                                      style: TextStyle(
                                                                          fontSize: 12,
                                                                          fontWeight: FontWeight.w600,
                                                                          color: CustomStyle.fontColorBlack)),
                                                                  dataPengajuanSaya.ketButton! == "" ? Container() :
                                                                  Container(
                                                                      margin: EdgeInsets.only(top: 3),
                                                                      padding: EdgeInsets.fromLTRB(5, 3, 5, 3),
                                                                      decoration: BoxDecoration(
                                                                          color: Colors.red,
                                                                          borderRadius: BorderRadius.circular(17)
                                                                      ),
                                                                      child: Text(dataPengajuanSaya.ketButton!,
                                                                          style: TextStyle(
                                                                              fontSize: 12,
                                                                              fontWeight: FontWeight.w600,
                                                                              color: Colors.white))),
                                                                ],
                                                              ),
                                                            ],
                                                          ),
                                                        ),
                                                        Divider(thickness: 1, color: Colors.grey, height: 0),
                                                        Padding(
                                                          padding: const EdgeInsets.all(16.0),
                                                          child: Column(
                                                            crossAxisAlignment: CrossAxisAlignment.start,
                                                            children: [
                                                              Row(
                                                                crossAxisAlignment: CrossAxisAlignment.center,
                                                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                                children: [
                                                                  Column(
                                                                    children: [
                                                                      Text(snapshot.data!.menuTukarShift!.data!.shiftSaya!,
                                                                          style: TextStyle(fontSize: 12, color: CustomStyle.fontColorGrey)),
                                                                      SizedBox(height: 8),
                                                                      Container(
                                                                        width: MediaQuery.of(context).size.width / 3.5,
                                                                        padding: const EdgeInsets.all(8),
                                                                        constraints: BoxConstraints(minHeight: 80),
                                                                        decoration: BoxDecoration(
                                                                          border: Border.all(color: Colors.grey),
                                                                          borderRadius: new BorderRadius.all(Radius.circular(8)),
                                                                        ),
                                                                        child: Column(
                                                                          crossAxisAlignment: CrossAxisAlignment.start,
                                                                          children: [
                                                                            widget.data[1] == 'shiftTeman'
                                                                                ? Text(dataPengajuanSaya.shiftAwal!.namaShift!,
                                                                                style: TextStyle(
                                                                                    fontSize: 14,
                                                                                    color: Colors.black,
                                                                                    fontWeight: FontWeight.bold))
                                                                                : Text(
                                                                                dataPengajuanSaya.shiftAwal!.namaShift!,
                                                                                style: TextStyle(
                                                                                    fontSize: 14,
                                                                                    color: Colors.black,
                                                                                    fontWeight: FontWeight.bold)),
                                                                            SizedBox(height: 8),
                                                                            widget.data[1] == 'shiftTeman'
                                                                                ? Text("${dataPengajuanSaya.shiftAwal!.masuk} - ${dataPengajuanSaya.shiftAwal!.pulang}",
                                                                                style: TextStyle(
                                                                                    fontSize: 12,
                                                                                    color: CustomStyle.fontColorGrey))
                                                                                : Text("${dataPengajuanSaya.shiftAwal!.masuk} - ${dataPengajuanSaya.shiftAwal!.pulang}",
                                                                                style: TextStyle(
                                                                                    fontSize: 12,
                                                                                    color: CustomStyle.fontColorGrey)),
                                                                            SizedBox(height: 8),
                                                                            Text("${dataPengajuanSaya.shiftAwal!.nik} - ${dataPengajuanSaya.shiftAwal!.karyawan}",
                                                                                style: TextStyle(
                                                                                    fontSize: 12,
                                                                                    color: CustomStyle.fontColorGrey)),
                                                                          ],
                                                                        ),
                                                                      )
                                                                    ],
                                                                  ),
                                                                  Icon(Icons.swap_horiz, size: 40),
                                                                  Column(
                                                                    children: [
                                                                      Text(snapshot.data!.menuTukarShift!.data!.shiftTeman!,
                                                                          style: TextStyle(fontSize: 12, color: CustomStyle.fontColorGrey)),
                                                                      SizedBox(height: 8),
                                                                      Container(
                                                                        width: MediaQuery.of(context).size.width / 3.5,
                                                                        padding: const EdgeInsets.all(8),
                                                                        constraints: BoxConstraints(minHeight: 80),
                                                                        decoration: BoxDecoration(
                                                                          border: Border.all(color: Colors.grey),
                                                                          borderRadius: new BorderRadius.all(Radius.circular(8)),
                                                                        ),
                                                                        child: Column(
                                                                          crossAxisAlignment: CrossAxisAlignment.start,
                                                                          children: [
                                                                            Text(dataPengajuanSaya.shiftBaru!.namaShift!,
                                                                                style: TextStyle(
                                                                                    fontSize: 14,
                                                                                    color: Colors.black,
                                                                                    fontWeight: FontWeight.bold)),
                                                                            SizedBox(height: 8),
                                                                            Text("${dataPengajuanSaya.shiftBaru!.masuk} - ${dataPengajuanSaya.shiftBaru!.pulang}",
                                                                                style: TextStyle(
                                                                                    fontSize: 12,
                                                                                    color: CustomStyle.fontColorGrey)),
                                                                            SizedBox(height: 8),
                                                                            Text("${dataPengajuanSaya.shiftBaru!.nik} - ${dataPengajuanSaya.shiftBaru!.karyawan} ",
                                                                                style: TextStyle(
                                                                                    fontSize: 12,
                                                                                    color: CustomStyle.fontColorGrey)),
                                                                          ],
                                                                        ),
                                                                      )
                                                                    ],
                                                                  ),
                                                                ],
                                                              ),
                                                              SizedBox(height: 8),
                                                              Text(snapshot.data!.menuTukarShift!.data!.keterangan!,
                                                                  style: TextStyle(
                                                                      fontSize: 12,
                                                                      fontWeight: FontWeight.w400,
                                                                      color: CustomStyle.fontColorGrey)),
                                                              SizedBox(height: 8),
                                                              Text(dataPengajuanSaya.keterangan!)
                                                            ],
                                                          ),
                                                        ),
                                                      ],
                                                    ),
                                                  ),
                                                  SizedBox(height: 16),
                                                  Text(snapshot.data!.menuTukarShift!.data!.approval!,
                                                      style: TextStyle(
                                                          fontSize: 12,
                                                          fontWeight: FontWeight.w400,
                                                          color: CustomStyle.fontColorGrey)),
                                                  SizedBox(height: 8),
                                                  Wrap(
                                                    spacing: 8,
                                                    direction: Axis.vertical,
                                                    runSpacing: 4,
                                                    children: dataPengajuanSaya.listApproval!.map((item) =>
                                                        TemplateButton(
                                                          label: item.statusApproval,
                                                          color: Color(int.parse(item.warnaStatus!)),
                                                          heightButton: 24,
                                                          radius: 4,
                                                          paddingTopBottom: 0,
                                                          contentColor: Color(int.parse(item.warnaFont!)),
                                                          bold: true,
                                                        ),
                                                    ).toList(),
                                                  ),
                                                  // Container(
                                                  //   padding: EdgeInsets.all(8),
                                                  //   decoration: BoxDecoration(
                                                  //     borderRadius: BorderRadius.circular(7),
                                                  //     color: Color(int.parse(dataPengajuanSaya.status!.color!)),
                                                  //   ),
                                                  //   child: Text(dataPengajuanSaya.status!.status!,
                                                  //       style: TextStyle(
                                                  //           fontWeight: FontWeight.bold,
                                                  //           fontSize: 13,
                                                  //           color: Color(int.parse(dataPengajuanSaya.status!.fontColor!))))),
                                                ],
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                              dataPengajuanSaya.button!
                                  ? Positioned(
                                bottom: 20,
                                child: Container(
                                  padding: EdgeInsets.only(left: 25, right: 25),
                                  decoration: BoxDecoration(color: Colors.white),
                                  width: MediaQuery.of(context).size.width,
                                  child: Row(
                                    children: <Widget>[
                                      Expanded(
                                        child: TemplateButton(
                                          onClick: () => {
                                            BlocProvider.of<TukarShiftBloc>(context)
                                                .add(tolak(widget.data![0], context, scaffoldKey, 'detailTukarShift', widget.data[1]))
                                          },
                                          label: snapshot.data!.menuTukarShift!.button!.btnTolak,
                                          color: Colors.white,
                                          contentColor: CustomStyle.color1,
                                          fontSize: CustomStyle.fontSizeNormal,
                                          bold: true,
                                        ),
                                      ),
                                      SizedBox(width: 12),
                                      Expanded(
                                          child: TemplateButton(
                                              onClick: () => {
                                                BlocProvider.of<TukarShiftBloc>(context)
                                                    .add(setujui(widget.data![0], context, scaffoldKey, 'detailTukarShift', widget.data[1]))
                                              },
                                              label: snapshot.data!.menuTukarShift!.button!.btnTerima,
                                              color: CustomStyle.color1,
                                              fontSize: CustomStyle.fontSizeNormal,
                                              bold: true)),
                                      SizedBox(width: 16),
                                    ],
                                  ),
                                ),
                              )
                                  : Container()
                            ],
                          );
                        } else if (state is TukarShiftDetailProgressState) {
                          return Container(
                              height: MediaQuery.of(context).size.height,
                              width: MediaQuery.of(context).size.width,
                              child: Center(
                                  child: CircularProgressIndicator(strokeWidth: 8)));
                        } else
                          return Container();
                      })),
            );
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
      ),
    );
  }
}

class TemplateColumn extends StatelessWidget {
  String? title;
  String? value;

  TemplateColumn({super.key, this.title, this.value});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(title!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w400,
              color: CustomStyle.fontColorGrey),
        ),
        SizedBox(height: 3),
        Text(value!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w600,
              color: CustomStyle.fontColorBlack),
        ),
      ],
    );
  }
}
