import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Sos/SosBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSosPage.dart';
import 'package:absenkuv3/Repository/Model/mSos.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePickerV2.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImageSOS.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateTextFormV2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanPengajuanSos extends StatefulWidget {
  const HalamanPengajuanSos({super.key});

  @override
  State<HalamanPengajuanSos> createState() => _HalamanPengajuanSosState();
}

class _HalamanPengajuanSosState extends State<HalamanPengajuanSos> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  final GlobalKey<FormState> formKey = GlobalKey<FormState>();
  TextEditingController keterangan = new TextEditingController();
  List<MultiImagePickerModel>? listImage;
  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageSosModel>(
        future: PengaturanBahasa().sos(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Scaffold(
              key: scaffoldKey,
              backgroundColor: Colors.white,
              appBar: AppBar(
                centerTitle: true,
                title: Text(
                  snapshot.data!.menuSos!.title!.parentTitle!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
                actions: [
                  GestureDetector(
                    onTap: () => BlocProvider.of<NavigatorBloc>(context)
                        .add(NavigateToHalamanListSos(context)),
                    child: Container(
                        margin: EdgeInsets.only(right: 14),
                        child: Icon(
                          Icons.list_alt_rounded,
                          size: 26,
                        )),
                  ),
                ],
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
              ),
              body: Column(children: [
                Expanded(
                  child: SingleChildScrollView(
                    padding: EdgeInsets.fromLTRB(14, 24, 14, 18),
                    child: Form(
                        child: Column(
                      children: [
                        TemplateTextFormV2(
                          adaValidasi: true,
                          controller: keterangan,
                          color: Colors.black,
                          maxLine: 5,
                          fontSize: 13,
                          titleText: snapshot.data!.menuSos!.data!.keterangan
                              .toString(),
                          radius: CustomStyle.formRadius,
                          // hintText: "Email",
                        ),
                        BlocListener<MultiImagePickerBloc,
                            MultiImagePickerState>(
                          listener: (BuildContext context,
                              MultiImagePickerState state) {
                            if (state is MultiImageSuccessState)
                              listImage = state.listData;
                          },
                          child: TemplateMultiImageSOS(
                            fromCamera: true,
                            defaultCamera: 'back',
                            maxUpload: 2,
                          ),
                        ),
                      ],
                    )),
                  ),
                ),
                Container(
                  color: Colors
                      .white, // Optional: add background color to the button
                  padding: EdgeInsets.all(14), // Padding around the button
                  child: TemplateButton(
                    onClick: () {
                      if (keterangan.text.trim().isEmpty) {
                        showSnackBarDelayed(
                            scaffoldKey,
                            '${snapshot.data!.menuSos!.pesanKonfirmasi!.ketIsEmpty}',
                            context);
                      } else if (listImage == null || listImage!.length == 0) {
                        showSnackBarDelayed(
                            scaffoldKey,
                            '${snapshot.data!.menuSos!.pesanKonfirmasi!.fileIsEmpty}',
                            context);
                      } else {
                        BlocProvider.of<SosBloc>(context).add(pengajuanSos(
                            ModelPengajuanSos(keterangan.text, listImage),
                            context,
                            scaffoldKey,
                            formKey));
                      }
                    },
                    radius: CustomStyle.formRadius + 6,
                    label: "Submit",
                    color: CustomStyle.color1,
                    expand: true,
                    bold: true,
                    heightButton: 40,
                  ),
                ),
              ]),
            );
          } else {
            return Container();
          }
        });
  }
}
