import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/ApproverBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataLayananDetailBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TahapanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalDataLayananDetailBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mMasterTahapan.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/komponenDataAktivitas.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/komponenDataPelanggan.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/komponenDataProdukLayanan.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/templeteCRUDLayanan.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class HalamanDetailKanbanBoard extends StatefulWidget {
  var data; // 0=DataKanban; 1=DefaultChipSelected
  HalamanDetailKanbanBoard(this.data);

  @override
  State<HalamanDetailKanbanBoard> createState() => _HalamanDetailKanbanBoardState();
}

class _HalamanDetailKanbanBoardState extends State<HalamanDetailKanbanBoard> {
  String selected = 'Data Pelanggan';
  List<String> chipData= ['Data Pelanggan', 'Produk/Layanan', 'Aktivitas'];
  ScrollController _controller = ScrollController(initialScrollOffset: 0);
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  DataTahapan? dataTahapan;
  String refresh = "";
  ModelFilter? _modelFilter;
  
  @override
  void initState() {
    super.initState();
    selected = widget.data[1];
    if(widget.data[2] != null){
      if(widget.data[2] == 'refresh'){
        refresh = 'refresh';
      }
    }
    BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, ModelFilter(monthYear: DateTime(int.parse(widget.data[0].tglInput!.split("-")[2]), int.parse(widget.data[0].tglInput!.split("-")[1])))));
  }
  Future<bool> keluar2() async {
    // BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    Navigator.pop(context, [refresh, widget.data[3]]);
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar2,
      child: Scaffold(
        backgroundColor: Colors.white,
        key: scaffoldKey,
          appBar: AppBar(
              centerTitle: true,
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
              title: Text('Detail', style: TextStyle(fontSize: CustomStyle.fontSizeTitle)),
          ),
        body: Stack(
          children: [
            Container(
              margin: EdgeInsets.only(bottom: widget.data[0].button!.buttonApprove! ? 65 : 0),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    margin: EdgeInsets.fromLTRB(27, 13, 27, 13),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        BlocBuilder<TahapanBloc, TahapanState>(
                          builder: (context, state) {
                            if (state is TahapanSuccessState) {
                              state.dataColumn!.forEach((element) {
                                if(element.id == widget.data[0].idTahapanM){
                                  dataTahapan = element;
                                }
                              });
                              return Row(
                                children: [
                                  Container(
                                    padding: EdgeInsets.only(left: 13, right: widget.data[0].button!.buttonUbahTahapan! ? 7 : 13, top: 7, bottom: 7),
                                    decoration: BoxDecoration(
                                      color: Color(int.parse(dataTahapan!.warna!)),
                                      borderRadius: BorderRadius.only(
                                        topLeft: Radius.circular(7),
                                        bottomLeft: Radius.circular(7),
                                        bottomRight: widget.data[0].button!.buttonUbahTahapan! ? Radius.circular(0) : Radius.circular(7),
                                        // bottomRight: widget.data[0].button!.buttonUbahTahapan! || widget.data[0].button!.buttonApprove! ? Radius.circular(0) : Radius.circular(7),
                                        // topRight: widget.data[0].button!.buttonUbahTahapan! || widget.data[0].button!.buttonApprove! ? Radius.circular(0) : Radius.circular(7)
                                        topRight: widget.data[0].button!.buttonUbahTahapan! ? Radius.circular(0) : Radius.circular(7)
                                      ),
                                    ),
                                    child: Text(dataTahapan==null?"-":dataTahapan!.nama!, style: TextStyle(fontSize: 12, fontWeight: FontWeight.w700, color: Color(int.parse(dataTahapan!.warnaText!)))),
                                  ),
                                  SizedBox(width: 1),
                                  widget.data[0].button!.buttonUbahTahapan!
                                      // && !widget.data[0].button!.buttonApprove!
                                    ? GestureDetector(
                                        onTap: (){
                                          if(dataTahapan!=null){
                                            // showDialogPindahTahapan(context, state.dataColumn!, widget.data[0], dataTahapan!.id!, dataTahapan!.nama!, dataTahapan!.warna!, dataTahapan!.warnaText!);
                                            TemplateCRUDLayanan().showDialogPindahTahapan(context, state.dataColumn!, widget.data[0], dataTahapan!.id!, dataTahapan!.nama!, dataTahapan!.warna!, dataTahapan!.warnaText!, 'detail', selected)
                                              .then((values){
                                                refresh = values[1];
                                                if(values[0]){
                                                  if(selected == chipData[1]){
                                                    setState(() {
                                                      BlocProvider.of<TotalDataLayananDetailBloc>(context).add(getTotalDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                                                      BlocProvider.of<DataLayananDetailBloc>(context).add(getDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                                                      selected = chipData[1];
                                                    });
                                                  }
                                                }
                                            });
                                          }else{
                                            showSnackBarDelayed(scaffoldKey, "Gagal mengambil data tahapan", context);
                                          }
                                        },
                                        child: Container(
                                          padding: EdgeInsets.only(left: 7, right: 7, top: 7, bottom: 7),
                                          decoration: BoxDecoration(
                                            color: Color(int.parse(dataTahapan!.warna!)),
                                            borderRadius: BorderRadius.only(
                                              topRight: Radius.circular(7),
                                              bottomRight: Radius.circular(7),
                                            ),
                                          ),
                                          child: Icon(Icons.arrow_forward_ios, size: 14, color: Color(int.parse(dataTahapan!.warnaText!))),
                                        ),
                                      )
                                    // : !widget.data[0].button!.buttonUbahTahapan! && widget.data[0].button!.buttonApprove!
                                    //   ? GestureDetector(
                                    //       onTap: (){
                                    //         if(dataTahapan!=null){
                                    //           // showDialogPindahTahapan(context, state.dataColumn!, widget.data[0], dataTahapan!.id!, dataTahapan!.nama!, dataTahapan!.warna!, dataTahapan!.warnaText!);
                                    //           TemplateCRUDLayanan().showDialogApproval(context, widget.data[0], dataTahapan!.id!, dataTahapan!.jenis!, selected)
                                    //               .then((values){
                                    //             refresh = values[1];
                                    //             if(values[1] == 'refresh'){
                                    //               if(selected == chipData[1]){
                                    //                 setState(() {
                                    //                   BlocProvider.of<TotalDataLayananDetailBloc>(context).add(getTotalDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                                    //                   BlocProvider.of<DataLayananDetailBloc>(context).add(getDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                                    //                   selected = chipData[1];
                                    //                 });
                                    //               }
                                    //             }
                                    //           });
                                    //         }else{
                                    //           showSnackBarDelayed(scaffoldKey, "Gagal mengambil data tahapan", context);
                                    //         }
                                    //       },
                                    //       child: Container(
                                    //         padding: EdgeInsets.only(left: 7, right: 7, top: 7, bottom: 7),
                                    //         decoration: BoxDecoration(
                                    //           color: Color(int.parse(dataTahapan!.warna!)),
                                    //           borderRadius: BorderRadius.only(
                                    //             topRight: Radius.circular(7),
                                    //             bottomRight: Radius.circular(7),
                                    //           ),
                                    //         ),
                                    //         child: Icon(Icons.arrow_forward_ios, size: 14, color: Color(int.parse(dataTahapan!.warnaText!))),
                                    //       ),
                                    //     )
                                      : Container(),
                                ],
                              );
                            }else{
                              return Container(
                                // margin: EdgeInsets.only(top: 7),
                                height: 35,
                                width: 80,
                                child: Shimmer.fromColors(
                                  baseColor: Colors.grey[200]!,
                                  highlightColor: Colors.white,
                                  period: Duration(seconds: 4),
                                  child: Card(),
                                ),
                              );
                            }
                          }
                        ),
                        Row(
                          children: [
                            Icon(
                              Icons.calendar_month_outlined,
                              size: 21,
                              color: Colors.grey.shade600,
                            ),
                            SizedBox(
                              width: 10,
                            ),
                            Text(
                              widget.data[0].tglPengajuan!,
                              style: TextStyle(fontSize: 12),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  Divider(thickness: 1, height: 1),
                  Container(
                    height: 50,
                    width: MediaQuery.of(context).size.width * 1.5,
                    padding: EdgeInsets.only(left: 5.0, top: 5),
                    child: ListView.builder(
                        itemCount: chipData.length,
                        scrollDirection: Axis.horizontal,
                        controller: _controller,
                        itemBuilder: (BuildContext context, index) {
                          return Row(
                            children: [
                              SizedBox(width: 2),
                              ChoiceChip(
                                shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.only(
                                        topRight: Radius.circular(21),
                                        bottomRight: Radius.circular(21),
                                        topLeft: Radius.circular(21),
                                        bottomLeft: Radius.circular(21))),
                                backgroundColor: Colors.grey.shade200,
                                labelPadding: EdgeInsets.only(left: 17, right: 17, top: 1.5, bottom: 1.5),
                                selectedColor: CustomStyle.color1,
                                selected: selected == chipData[index],
                                label: Text(chipData[index] ?? ''),
                                labelStyle: TextStyle(
                                    color: selected == chipData[index]
                                        ? Colors.white
                                        : CustomStyle.color1, fontSize: 13),
                                elevation: 1,
                                onSelected: (_) {
                                  setState(() {
                                    selected = chipData[index];
                                  });
                                  // BlocProvider.of<TahapanBloc>(context).add(SelectedTahapanEvent(state.dataColumn!, state.dataColumn![index].value!, state.dataColumn![index].id!));
                                },
                              ),
                              SizedBox(width: 11)
                            ],
                          );
                        }
                    ),
                  ),
                  selected == 'Data Pelanggan'
                      ? Expanded(child: KomponenDataPelanggan(widget.data[0].idPelanggan!, widget.data[0].idPipelineMain!))
                      : selected == 'Produk/Layanan'
                        ? Expanded(
                            child: Stack(
                              children: [
                                // komponenDataProdukLayanan(widget.data[0], dataTahapan!.id!, scaffoldKey),
                                komponenDataProdukLayanan(widget.data[0], widget.data[0].idTahapanM, scaffoldKey),
                                !widget.data[0].button!.buttonLayanan! ? Container() :
                                Positioned(
                                  bottom: 27,
                                  right: 17,
                                  child: GestureDetector(
                                    onTap: () =>
                                      TemplateCRUDLayanan().showDialogAddLayanan(
                                          context, scaffoldKey,
                                          widget.data[0].idPipelineMain,
                                          dataTahapan!.id!).then((value) => refresh = value),
                                    child: Container(
                                      padding: EdgeInsets.all(13),
                                      decoration: BoxDecoration(
                                        shape: BoxShape.circle,
                                        color: CustomStyle.color1,
                                      ),
                                      child: Icon(Icons.add, color: Colors.white),
                                    ),
                                  ),
                                )
                              ],
                            )
                          )
                        : Expanded(child: Stack(
                          children: [
                            KomponenDataAktivitas(widget.data[0].idPelanggan!, widget.data[0].namaPerusahaan!, widget.data[0], scaffoldKey),
                            widget.data[0].button!.buttonAktivitas!
                              ? Positioned(
                                  bottom: 27,
                                  right: 17,
                                  child: GestureDetector(
                                    onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                        .add(NavigateToAddAktivitasSalesPage(context, [widget.data[0].idPelanggan!, widget.data[0].namaPerusahaan!, widget.data[0].idPipelineMain, widget.data[0], widget.data[3]])),
                                    child: Container(
                                      padding: EdgeInsets.all(13),
                                      decoration: BoxDecoration(
                                        shape: BoxShape.circle,
                                        color: CustomStyle.color1),
                                      child: Icon(Icons.add, color: Colors.white),
                                    ),
                                  ),
                                )
                              : Container()
                          ],
                        ))
                ],
              ),
            ),
            BlocListener<ApproverBloc, ApproverState>(
              listener: (context, stateApproval) {
                if (stateApproval is TolakSuccessState) {
                  refresh = 'refresh';
                  setState(() {
                    widget.data[0] = stateApproval.dataKanban;
                    if(selected == chipData[1]){
                      BlocProvider.of<TotalDataLayananDetailBloc>(context).add(getTotalDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                      BlocProvider.of<DataLayananDetailBloc>(context).add(getDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                      selected = chipData[1];
                    }
                  });
                }else if(stateApproval is SetujuiSuccessState){
                  refresh = 'refresh';
                  setState(() {
                    widget.data[0] = stateApproval.dataKanban;
                    if(selected == chipData[1]){
                      BlocProvider.of<TotalDataLayananDetailBloc>(context).add(getTotalDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                      BlocProvider.of<DataLayananDetailBloc>(context).add(getDataLayananDetailEvent(context, widget.data[0].idPipelineMain));
                      selected = chipData[1];
                    }
                  });
                }
              },
              child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                listener: (BuildContext context, FilterBottomSheetState stateFilter) {
                  if (stateFilter is setFilterSuccess) {
                    print("kakaka $stateFilter");
                    if(stateFilter != null){
                      _modelFilter = stateFilter.modelFilter;
                    }
                  }
                },
                child: Positioned(
                  bottom: 0,
                  child: widget.data[0].button!.buttonApprove!
                      ? Container(
                    padding: EdgeInsets.only(left: 22, right: 22),
                    decoration: BoxDecoration(
                        boxShadow: [
                          BoxShadow(
                            color: Colors.grey.withOpacity(0.4),
                            spreadRadius: 2,
                            blurRadius: 7,
                            offset: Offset(
                                0, 1), // changes position of shadow
                          ),
                        ],
                        color: Colors.white,
                        borderRadius: new BorderRadius.only(
                            topLeft: Radius.circular(CustomStyle.boxRadius + 4),
                            topRight: Radius.circular(CustomStyle.boxRadius + 4))),
                    height: 62,
                    width: MediaQuery.of(context).size.width,
                    child: Row(
                      children: <Widget>[
                        Expanded(
                          child: TemplateButton(
                            onClick: () =>
                                TemplateConfirmationDialog(
                                    marginHeight: 13,
                                    'Apakah anda yakin akan menolak pengajuan kanban ini?',
                                        () {
                                      BlocProvider.of<ApproverBloc>(context)
                                          .add(TolakKanbanEvent(
                                          context,
                                          selected,
                                          widget.data[0],
                                          widget.data[0].idPipelineMain,
                                          widget.data[0].idPipelineMainLog,
                                          widget.data[0].idTahapanM,
                                          widget.data[0].jenisTahapan,
                                          _modelFilter, 'detail'));
                                    },
                                    context),
                            label: "Tolak",
                            color: Colors.grey[500],
                            heightButton: 28,
                            radius: CustomStyle.boxRadius + 4,
                            icon: Icons.close,
                            bold: true,
                            fontSize: CustomStyle.fontSizeSmall - 1,
                            iconSize: 16,
                            paddingTopBottom: 0,
                          ),
                        ),
                        SizedBox(
                          width: 12,
                        ),
                        Expanded(
                          child: TemplateButton(
                            onClick: () {
                              TemplateConfirmationDialog(
                                  marginHeight: 13,
                                  'Apakah anda yakin akan menyetujui pengajuan kanban ini?',
                                      () {
                                    BlocProvider.of<ApproverBloc>(context)
                                        .add(SetujuiKanbanEvent(
                                        context,
                                        // selected,
                                        widget.data[0],
                                        widget.data[0].idPipelineMain,
                                        widget.data[0].idPipelineMainLog,
                                        widget.data[0].idTahapanM,
                                        _modelFilter, 'detail'));
                                  },
                                  context);

                              // BlocProvider.of<DataDailyAktivitasSalesBloc>(context)
                              //     .add(TolakActivitySalesEvent(
                              //     context,
                              //     widget.data[1], state.data![0], 'detailActivity'));
                              //
                              // refresh = 'refresh';
                            },
                            label: "Setujui",
                            color: CustomStyle.color1,
                            heightButton: 28,
                            radius: CustomStyle.boxRadius + 4,
                            icon: Icons.check,
                            bold: true,
                            fontSize: CustomStyle.fontSizeSmall - 1,
                            iconSize: 16,
                            paddingTopBottom: 0,
                          ),
                        ),
                        SizedBox(
                          width: 16,
                        ),
                        GestureDetector(
                            onTap: () =>
                                BlocProvider.of<NavigatorBloc>(context)
                                    .add(NavigatePop(context)),
                            child: Icon(
                              Icons.chevron_left,
                              size: 34,
                              color: CustomStyle.fontColorGrey,
                            ))
                      ],
                    ),
                  )
                      : Container(),
                ),
              ),
            )
          ],
        ),
      ),
    );
  }

  // Future<bool> keluar() async {
  //   return false;
  // }

  // Future showDialogPindahTahapan(BuildContext context, List<DataTahapan> dataTahapan, DataKanban _dataKanban, String idSelected, String selectedName, String color, String textColor){
  //   GlobalKey<ScaffoldState> __scaffoldKey = GlobalKey();
  //   GlobalKey<ScaffoldState> ___scaffoldKey = GlobalKey();
  //   DataTahapan? _selected;
  //   TextEditingController keterangan = TextEditingController();
  //   bool refreshProduct = false;
  //
  //   return showModalBottomSheet(
  //       context: context,
  //       showDragHandle: true,
  //       isDismissible: false,
  //       shape: RoundedRectangleBorder(
  //           borderRadius: BorderRadius.circular(18)
  //       ),
  //       builder: (BuildContext _context){
  //         return Scaffold(
  //           body: WillPopScope(
  //             onWillPop: keluar,
  //             child: StatefulBuilder(
  //                 builder: (BuildContext con, StateSetter setState) {
  //                   return Stack(
  //                     children: [
  //                       Column(
  //                         crossAxisAlignment: CrossAxisAlignment.start,
  //                         mainAxisAlignment: MainAxisAlignment.start,
  //                         children: [
  //                           Container(
  //                             margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                             child: Row(
  //                               mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                               children: [
  //                                 Text("Pindah Tahapan", style: TextStyle(fontWeight: FontWeight.w700, fontSize: 14),),
  //                                 GestureDetector(
  //                                     onTap: ()=> Navigator.pop(context),
  //                                     child: Icon(Icons.close, size: 21))
  //                               ],
  //                             ),
  //                           ),
  //                           SizedBox(height: 7),
  //                           Divider(thickness: 1, color: Colors.grey.shade400),
  //                           SizedBox(height: 7),
  //                           Row(
  //                             mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                             children: [
  //                               Container(
  //                                   margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                                   child: Text("Tahapan Sekarang", style: TextStyle(fontSize: 13, color: Colors.grey))),
  //                               Container(
  //                                   margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                                   padding: EdgeInsets.fromLTRB(17, 7, 17, 7),
  //                                   decoration: BoxDecoration(
  //                                     borderRadius: BorderRadius.circular(9),
  //                                     color: Color(int.parse(color)),
  //                                   ),
  //                                   child: Text(selectedName, style: TextStyle(fontSize: 14, color: Color(int.parse(textColor))))),
  //                             ],
  //                           ),
  //                           // SizedBox(height: 3),
  //
  //                           SizedBox(height: 3),
  //                           Divider(thickness: 1),
  //                           Container(
  //                               margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                               child: Text("Pindah Ke", style: TextStyle(fontSize: 13, color: Colors.grey))),
  //                           SizedBox(height: 3),
  //                           Expanded(
  //                             child: Container(
  //                               margin: EdgeInsets.only(bottom: 60, top: 7),
  //                               child: ListView.builder(
  //                                   itemCount: dataTahapan.length,
  //                                   // physics: NeverScrollableScrollPhysics(),
  //                                   shrinkWrap: true,
  //                                   itemBuilder: (context, index){
  //                                     return Container(
  //                                       margin: EdgeInsets.fromLTRB(27, 0, 27, 3),
  //                                       child: Row(
  //                                         mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                         children: [
  //                                           Text(dataTahapan[index].nama!),
  //                                           dataTahapan[index].id == idSelected
  //                                             ? Container(
  //                                                 width: 19,
  //                                                 height: 19,
  //                                                 margin: EdgeInsets.only(right: 14, bottom: 9, top: 9),
  //                                                 decoration: BoxDecoration(
  //                                                   shape: BoxShape.circle,
  //                                                   border: Border.all(color: Colors.grey.shade600),
  //                                                   color: Colors.grey.shade400,
  //                                                 ),
  //                                               )
  //                                             : Radio<DataTahapan>(
  //                                                 visualDensity: VisualDensity(vertical: -3),
  //                                                 value: dataTahapan[index],
  //                                                 onChanged: (DataTahapan? value) {
  //                                                   setState(() {
  //                                                     _selected = value;
  //                                                   });
  //                                                 },
  //                                                 groupValue: _selected,
  //                                               ),
  //                                         ],
  //                                       ),
  //                                     );
  //                                   }
  //                               ),
  //                             ),
  //                           )
  //                         ],
  //                       ),
  //                       Positioned(
  //                           bottom: 0,
  //                           child: Container(
  //                             padding: EdgeInsets.only(left: 22, right: 22, top: 7, bottom: 7),
  //                             decoration: BoxDecoration(
  //                               boxShadow: [
  //                                 BoxShadow(
  //                                     color: Colors.grey.shade300,
  //                                     spreadRadius: 2
  //                                 ),
  //                               ],
  //                               color: Colors.white,
  //                             ),
  //                             height: 51,
  //                             width: MediaQuery.of(context).size.width,
  //                             child: TemplateButton(
  //                               onClick: () async {
  //
  //                                 if(_selected == null){
  //                                   showSnackBarDelayed(__scaffoldKey, "Pilih tujuan tahapan terlebih dahulu", context, backgroundColor: Colors.red, textColor: Colors.white);
  //                                 }else if(_selected!.id == idSelected){
  //                                   showSnackBarDelayed(__scaffoldKey, "Tahapan sekarang sama dengan tahapan tujuan", context, backgroundColor: Colors.red, textColor: Colors.white);
  //                                 }else{
  //                                   if(_selected!.jenis == 'wont'){
  //                                     BlocProvider.of<DataLayananDetailByIdBloc>(_context).add(getDataLayananDetailByIdEvent(_context, _dataKanban.idPipelineMain));
  //                                     // DataLayananDetailRespon _dataLayananDetail = await SalesActivityApi().getDataLayananDetailById(_dataKanban.idPipelineMain);
  //                                     showModalBottomSheet(
  //                                         context: context,
  //                                         showDragHandle: true,
  //                                         isDismissible: false,
  //                                         isScrollControlled: true,
  //                                         backgroundColor: Colors.white,
  //                                         shape: RoundedRectangleBorder(
  //                                             borderRadius: BorderRadius.circular(18)
  //                                         ),
  //                                         builder: (context){
  //                                           // List<Layanan> layananDetail = _dataLayananDetail.dataLayananDetail!;
  //                                           return Container(
  //                                             height: MediaQuery.of(context).size.height/1.2,
  //                                             child:  BlocBuilder<DataLayananDetailByIdBloc, DataLayananDetailByIdState>(
  //                                                 builder: (con, stateLayananById) {
  //                                                   if(stateLayananById is getDataLayananDetailByIdSuccessState){
  //                                                     return Container(
  //                                                       child: Container(
  //                                                         height: double.infinity,
  //                                                         margin: EdgeInsets.fromLTRB(9,0,9,13),
  //                                                         child: SingleChildScrollView(
  //                                                           child: Column(
  //                                                             mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                                             crossAxisAlignment: CrossAxisAlignment.start,
  //                                                             children: [
  //                                                               Container(
  //                                                                 margin: EdgeInsets.symmetric(horizontal: 23),
  //                                                                 child: Row(
  //                                                                   mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                                                   children: [
  //                                                                     Text('Produk/Layanan', style: TextStyle(
  //                                                                         fontWeight: FontWeight.w500,
  //                                                                         fontSize: 15
  //                                                                     )),
  //                                                                     GestureDetector(
  //                                                                         onTap: ()=> Navigator.pop(context),
  //                                                                         child: Icon(Icons.close, size: 21))
  //                                                                   ],
  //                                                                 ),
  //                                                               ),
  //                                                               SizedBox(height: 7),
  //                                                               Divider(thickness: 1),
  //                                                               Scrollbar(
  //                                                                 showTrackOnHover: true,
  //                                                                 interactive: true,
  //                                                                 child: Container(
  //                                                                   height: stateLayananById.dataLayananDetail!.length == 1
  //                                                                       ? 60
  //                                                                       : stateLayananById.dataLayananDetail!.length == 2
  //                                                                         ? 135
  //                                                                         : 220,
  //                                                                   margin: EdgeInsets.symmetric(horizontal: 23),
  //                                                                   color: Colors.grey.shade200,
  //                                                                   child: ListView.builder(
  //                                                                       itemCount: stateLayananById.dataLayananDetail!.length,
  //                                                                       shrinkWrap: true,
  //                                                                       key: ___scaffoldKey,
  //                                                                       // physics: NeverScrollableScrollPhysics(),
  //                                                                       itemBuilder: (_con, ind){
  //                                                                         return Column(
  //                                                                           children: [
  //                                                                             CardLayananPage(
  //                                                                                 _dataKanban,
  //                                                                                 stateLayananById.dataLayananDetail![ind],
  //                                                                                 ___scaffoldKey,
  //                                                                                 true,
  //                                                                                 marginHorizontal: 0,
  //                                                                                 dataCallback: (val){
  //                                                                                   if(val == 'refresh'){
  //                                                                                     refreshProduct = true;
  //                                                                                   }
  //                                                                                 }),
  //                                                                             ind == stateLayananById.dataLayananDetail!.length-1
  //                                                                                 ? Container(height: 3, color: Colors.white)
  //                                                                                 : Container(
  //                                                                                 color: Colors.white,
  //                                                                                 child: Divider(thickness: 1))
  //                                                                           ],
  //                                                                         );
  //                                                                       }
  //                                                                   ),
  //                                                                 ),
  //                                                               ),
  //                                                               Container(
  //                                                                 margin: EdgeInsets.only(top: 7),
  //                                                                 child: Container(
  //                                                                     margin: EdgeInsets.symmetric(horizontal: 23),
  //                                                                     child: Column(
  //                                                                       children: [
  //                                                                         TemplateDashLine(color: Colors.grey.shade400),
  //                                                                         Container(
  //                                                                           margin: EdgeInsets.only(top: 14),
  //                                                                           child: Row(
  //                                                                             mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                                                             children: [
  //                                                                               Text("Total Item ", style: TextStyle(fontSize: 12)),
  //                                                                               Text("Rp ${stateLayananById.totalDataLayananDetail!.totalItem}", style: TextStyle(fontSize: 12)),
  //                                                                               // Text("Rp ${_dataLayananDetail[ind].totalItem}", style: TextStyle(fontSize: 12)),
  //                                                                             ],
  //                                                                           ),
  //                                                                         ),
  //                                                                         Container(
  //                                                                           margin: EdgeInsets.only(top: 5),
  //                                                                           child: Row(
  //                                                                             mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                                                             children: [
  //                                                                               Text("Total Diskon ", style: TextStyle(fontSize: 12)),
  //                                                                               Text("Rp ${stateLayananById.totalDataLayananDetail!.totalDiskon}", style: TextStyle(fontSize: 12)),
  //                                                                               // Text("( Rp ${dataTotal!.totalDiskon} )", style: TextStyle(fontSize: 12)),
  //                                                                             ],
  //                                                                           ),
  //                                                                         ),
  //                                                                         Container(
  //                                                                           margin: EdgeInsets.only(top: 5),
  //                                                                           child: Row(
  //                                                                             mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                                                             children: [
  //                                                                               Text("Total Harga ", style: TextStyle(fontSize: 12, fontWeight: FontWeight.w700)),
  //                                                                               Text("Rp ${stateLayananById.totalDataLayananDetail!.totalHarga}", style: TextStyle(fontSize: 12, fontWeight: FontWeight.w700)),
  //                                                                               // Text("Rp ${_dataLayananDetail[ind].totalHarga}", style: TextStyle(fontSize: 12, fontWeight: FontWeight.w700)),
  //                                                                             ],
  //                                                                           ),
  //                                                                         ),
  //                                                                       ],
  //                                                                     )),
  //                                                               ),
  //                                                               SizedBox(height: 27),
  //                                                               Container(
  //                                                                 margin: EdgeInsets.symmetric(horizontal: 23),
  //                                                                 child: TemplateTextFieldForm(
  //                                                                   adaValidasi: true,
  //                                                                   controller: keterangan,
  //                                                                   color: Colors.grey[600],
  //                                                                   maxLine: 5,
  //                                                                   minLine: 5,
  //                                                                   titleText: "Keterangan",
  //                                                                   radius: CustomStyle.formRadius,
  //                                                                   hintText: "Keterangan",
  //                                                                 ),
  //                                                               ),
  //                                                               Container(
  //                                                                 margin: EdgeInsets.only(
  //                                                                     top: stateLayananById.dataLayananDetail!.length == 1
  //                                                                         ? 265
  //                                                                         : stateLayananById.dataLayananDetail!.length == 2
  //                                                                           ? 197
  //                                                                           : 110),
  //                                                                 child: TemplateButton(
  //                                                                   expand: true,
  //                                                                   onClick: (){
  //                                                                     if(keterangan.text.trim().isEmpty){
  //                                                                       showSnackBarDelayed(scaffoldKey, "Keterangan wajib diisi", _context, backgroundColor: Colors.red, textColor: Colors.white);
  //                                                                     }else{
  //                                                                       TemplateConfirmationDialog(
  //                                                                           "Apakah Anda yakin akan mengubah tahapan ini ke ${_selected!.nama}?",
  //                                                                               () { BlocProvider.of<KambanBloc>(context)
  //                                                                               .add(ubahTahapanKambanEvent(context, _dataKanban, idSelected, _dataKanban.statusPengajuan!.value, idSelected, selectedName, _selected!.id, _selected!.nama, false, keterangan.text, ""));
  //                                                                           refresh = "refresh";
  //                                                                           },
  //                                                                           context);
  //                                                                     }
  //                                                                   },
  //                                                                   label: 'SUBMIT',
  //                                                                 ),
  //                                                               )
  //                                                             ],
  //                                                           ),
  //                                                         ),
  //                                                       ),
  //                                                     );
  //                                                   }else{
  //                                                     return Center(child: CircularProgressIndicator(strokeWidth: 8));
  //                                                   }
  //                                                 }
  //                                             ),
  //                                           );
  //                                         }
  //                                     );
  //                                   }
  //                                   else if(_selected!.jenis == 'lost'){
  //                                     showModalBottomSheet(
  //                                         context: context,
  //                                         showDragHandle: true,
  //                                         isDismissible: false,
  //                                         shape: RoundedRectangleBorder(
  //                                             borderRadius: BorderRadius.circular(18)
  //                                         ),
  //                                         builder: (_context){
  //                                           return Scaffold(
  //                                             body: Container(
  //                                               height: double.infinity,
  //                                               margin: EdgeInsets.fromLTRB(9,0,9,13),
  //                                               child: SingleChildScrollView(
  //                                                 child: Column(
  //                                                   children: [
  //                                                     TemplateTextFieldForm(
  //                                                       adaValidasi: true,
  //                                                       controller: keterangan,
  //                                                       color: Colors.grey[600],
  //                                                       maxLine: 5,
  //                                                       minLine: 5,
  //                                                       titleText: "Keterangan",
  //                                                       radius: CustomStyle.formRadius,
  //                                                       hintText: "Keterangan",
  //                                                     ),
  //                                                     Container(
  //                                                       margin: EdgeInsets.only(top: 197),
  //                                                       child: TemplateButton(
  //                                                         expand: true,
  //                                                         onClick: (){
  //                                                           if(keterangan.text.trim().isEmpty){
  //                                                             showSnackBarDelayed(scaffoldKey, "Keterangan wajib diisi", _context, backgroundColor: Colors.red, textColor: Colors.white);
  //                                                           }else{
  //                                                             TemplateConfirmationDialog(
  //                                                                 "Apakah Anda yakin akan mengubah tahapan ini ke ${_selected!.nama}?",
  //                                                                     () {
  //                                                                         BlocProvider.of<KambanBloc>(context)
  //                                                                           .add(ubahTahapanKambanEvent(context, _dataKanban, idSelected, _dataKanban.statusPengajuan!.value, idSelected, selectedName, _selected!.id, _selected!.nama, false, "", keterangan.text));
  //                                                                         refresh = "refresh";
  //                                                                       },
  //                                                                 context);
  //                                                           }
  //                                                         },
  //                                                         label: 'SUBMIT',
  //                                                       ),
  //                                                     )
  //                                                   ],
  //                                                 ),
  //                                               ),
  //                                             ),
  //                                           );
  //                                         }
  //                                     );
  //                                   }
  //                                   else{
  //                                     TemplateConfirmationDialog(
  //                                         "Apakah Anda yakin akan mengubah tahapan ke ${_selected!.nama}?",
  //                                             () {
  //                                           BlocProvider.of<KambanBloc>(
  //                                               context)
  //                                               .add(ubahTahapanKambanEvent(
  //                                               context,
  //                                               _dataKanban,
  //                                               idSelected,
  //                                               _dataKanban.statusPengajuan!.value,
  //                                               idSelected,
  //                                               selectedName,
  //                                               _selected!.id,
  //                                               _selected!.nama,
  //                                               true, "", ""));
  //                                           refresh = "refresh";
  //                                         },
  //                                         context);
  //                                   }
  //                                 }
  //
  //                               },
  //                               label: "SUBMIT",
  //                               color: CustomStyle.color1,
  //                               heightButton: 28,
  //                               radius: CustomStyle.boxRadius + 4,
  //                               bold: true,
  //                               fontSize: CustomStyle.fontSizeSmall - 1,
  //                               iconSize: 16,
  //                               paddingTopBottom: 0,
  //                             ),
  //                           )
  //                       )
  //                     ],
  //                   );
  //                 }
  //             ),
  //           ),
  //         );
  //       }
  //   ).then((value) => refreshProduct);
  // }
}