import 'package:absenkuv3/Bloc/Pkwt/DataCallbackPkwtBloc.dart';
import 'package:absenkuv3/Bloc/Pkwt/PkwtBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mPkwtPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Pkwt/komponen/komponenPkwt.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListPkwtSaya extends StatefulWidget {
  @override
  State<HalamanListPkwtSaya> createState() => _HalamanListPkwtSayaState();
}

class _HalamanListPkwtSayaState extends State<HalamanListPkwtSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  @override
  void initState() {
    super.initState();
    BlocProvider.of<PkwtBloc>(context).add(getListPkwtEvent(context, 'list'));
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PagePkwtModel>(
      future: PengaturanBahasa().pkwt(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          return Scaffold(
            key: scaffoldKey,
            appBar: AppBar(
              centerTitle: true,
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
              title: Text(
                snapshot.data!.menuPkwt!.title!.parentTitle.toString(),
                maxLines: 2,
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
            ),
            body: Stack(
              children: [
                BlocBuilder<PkwtBloc, PkwtState>(
                    builder: (BuildContext context, PkwtState state) {
                  if (state is getListPkwtSuccessState)
                    return ListView.builder(
                      physics: AlwaysScrollableScrollPhysics(),
                      itemCount: state.data!.length,
                      itemBuilder: (BuildContext context, index) {
                        return CardPkwt(state.data![index], scaffoldKey,
                            dataCallback: (value) {
                          List? dataCallback = context
                              .read<DataCallbackPkwtCubit>()
                              .getDataCallback();
                          // print("ini bloc callback ${dataCallback![0]}");
                          if (dataCallback != null) {
                            if (dataCallback[0] == true) {
                              // print("ada update");
                              final status = dataCallback[1] == 'setujui'
                                  ? snapshot.data!.menuPkwt!.data!.statusSetuju
                                      .toString()
                                  : snapshot.data!.menuPkwt!.data!.statusDitolak
                                      .toString();
                              final warnaFont = dataCallback[1] == 'setujui'
                                  ? '0XFF2F80ED'
                                  : '0XFFDB2D2D';
                              final warnaStatus = dataCallback[1] == 'setujui'
                                  ? '0X332F80ED'
                                  : '0X33DB2D2D';
                              BlocProvider.of<PkwtBloc>(context).add(
                                ChangePkwtStatusEvent(
                                  index: index,
                                  status: status,
                                  warnaFont: warnaFont,
                                  warnaStatus: warnaStatus,
                                ),
                              );
                            }
                          }
                        });
                      },
                    );
                  else if (state is PkwtProgressState)
                    return Center(
                      child: CircularProgressIndicator(
                        strokeWidth: 8,
                      ),
                    );
                  else
                    return Center(
                      child: Image.asset(
                        ValueImage.noData,
                        height: 250,
                      ),
                    );
                })
              ],
            ),
          );
        } else {
          return Container();
        }
      },
    );
  }
}
