import 'package:absenkuv3/Bloc/Patroli/JadwalPatroliBloc.dart';
import 'package:absenkuv3/Repository/Model/mChekpoint.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
// import 'package:lottie/lottie.dart';

class ListJadwalPatroli extends StatefulWidget {
  final Function(List<JadwalChekpoint>) onValuesChanged;
  ListJadwalPatroli({required this.onValuesChanged});
  @override
  _ListJadwalPatroliState createState() => _ListJadwalPatroliState();
}

class _ListJadwalPatroliState extends State<ListJadwalPatroli> {
  JadwalChekpoint? selectedJadwalChekpoint;
  @override
  Widget build(BuildContext context) {
    return BlocBuilder<JadwalPatroliBloc, JadwalPatroliState>(
        builder: (context, state) {
      if (state is JadwalPatroliProgressState) {
        return Center(child: CircularProgressIndicator());
        // return Container();
      } else if (state is getListJadwalPatroliSuccessState) {
        return ListView.builder(
            itemCount: state.data!.length,
            shrinkWrap: true,
            itemBuilder: (BuildContext ct, index) {
              bool isSelected = selectedJadwalChekpoint == state.data![index];

              bool isJadwalActive = state.data![index].isActive ??
                  true; // Default to true if not specified
              return InkWell(
                onTap: () {
                  if (isJadwalActive) {
                    setState(() {
                      selectedJadwalChekpoint =
                          isSelected ? null : state.data![index];
                    });
                    widget.onValuesChanged(selectedJadwalChekpoint != null
                        ? [selectedJadwalChekpoint!]
                        : []);
                  }
                },
                child: Container(
                  padding: const EdgeInsets.all(8.0),
                  margin: const EdgeInsets.all(8.0),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8.0),
                    border: Border.all(width: 0.1),
                    color: isJadwalActive
                        ? Colors.white
                        : Colors.grey.withOpacity(0.3),
                  ),
                  child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Row(
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  state.data![index].nmJadwal.toString(),
                                  style: TextStyle(fontWeight: FontWeight.bold),
                                ),
                                Text(
                                    "${state.data![index].minAbsen.toString()} - ${state.data![index].maxAbsen.toString()}"),
                              ],
                            ),
                          ],
                        ),
                        // Checkbox(
                        //   value: isSelected && isJadwalActive,
                        //   onChanged: (value) {
                        //     if (isJadwalActive) {
                        //       setState(() {
                        //         selectedJadwalChekpoint =
                        //             isSelected ? null : state.data![index];
                        //       });
                        //       widget.onValuesChanged(
                        //           selectedJadwalChekpoint != null
                        //               ? [selectedJadwalChekpoint!]
                        //               : []);
                        //     }
                        //   },
                        // )
                        Radio(
                          value: state.data![index],
                          groupValue: selectedJadwalChekpoint,
                          onChanged: (value) {
                            if (isJadwalActive) {
                              setState(() {
                                selectedJadwalChekpoint = value;
                              });
                              widget.onValuesChanged(
                                  selectedJadwalChekpoint != null
                                      ? [selectedJadwalChekpoint!]
                                      : []);
                            }
                          },
                        )
                      ]),
                ),
              );
            });
      }
      // return SizedBox.shrink();
      return Container(
        child: Center(
          child: 
          Column(
            children: [
          // Lottie.asset(
          // 'assets/empty.json',
          // width: 250,
          // height: 250,
          // fit: BoxFit.fill,
          //   ),
          //   Text("Maaf data jadwal tidak di temukan",style: TextStyle(
          //   fontSize: 13,
          //   fontWeight: FontWeight.bold,
          //   color: Colors.grey
          //   ),)
            ],
          )
        ),
      );
    });
  }
}
