import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mChekpoint.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardPatroli extends StatefulWidget{
  DataChekpoint dataChekpoint;
  GlobalKey<ScaffoldState> scaffoldKey;
  String konteks;
  CardPatroli(this.dataChekpoint,this.scaffoldKey,this.konteks);

  @override
  _CardPatroliState createState() => _CardPatroliState();
}

class _CardPatroliState extends State<CardPatroli>{
  @override
  Widget build(BuildContext context){
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(NavigateToDetailPatroli(context, [widget.dataChekpoint.idChekpoint,widget.konteks])),
      child: Container(
        decoration: CustomStyle.boxDecoration,
        padding: EdgeInsets.all(14),
        margin: EdgeInsets.only(top: 12,left: 17,right: 17),
        child: Column(crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
          children: [
            Column(
            children: [
              Text(widget.dataChekpoint.hari!, style: TextStyle(fontSize: 12, color: Color(0xFF828282), fontWeight: FontWeight.w400)),
              SizedBox(height: 3),
              Text(widget.dataChekpoint.tanggal!, style: TextStyle(fontSize: 14, fontWeight: FontWeight.w700)),
              SizedBox(height: 3),
              Text(widget.dataChekpoint.bulan!, style: TextStyle(fontSize: 12, color: Color(0xFF828282), fontWeight: FontWeight.w400)),
            ],
            ),
            VerticalDividerAbsenku(),
            Expanded(
            child: widget.konteks=='checkpointPegawai' ? 
            Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(widget.dataChekpoint.namaKaryawan!, style: TextStyle(fontSize: 14, fontWeight: FontWeight.w700)),
              SizedBox(height: 7),
              Text("${widget.dataChekpoint.waktu!}  -  ${widget.dataChekpoint.lokasi!} - ${widget.dataChekpoint.nm_qr!}", style: TextStyle(fontSize: 12, color: Color(0xFF828282), fontWeight: FontWeight.w400)),
            ],
            ):Column(
              crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(widget.dataChekpoint.waktu!, style: TextStyle(fontSize: 14, fontWeight: FontWeight.w700)),
              SizedBox(height: 7),
              Text(widget.dataChekpoint.nm_qr!, style: TextStyle(fontSize: 12, color: Color(0xFF828282), fontWeight: FontWeight.w400)),
            ],
            ),
            )
          ],
          ),
        ],
        ),
      ),
    );
  }
}
class buttonTambahChekpoint extends StatelessWidget {
  String label;
  var onClick;
  bool enable; //enable / disable button
  bool? mulai; // variable untuk flag mulai atau selesai
  buttonTambahChekpoint({
    this.mulai = true,
    this.enable = true,
    this.label = "Mulai",
    this.onClick,
 });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: enable ? onClick : null,
      child: Container(
        padding: const EdgeInsets.all(10),
        decoration: BoxDecoration(
            color: enable ? mulai! ? Colors.green : Colors.redAccent : Colors.grey,
            borderRadius: new BorderRadius.all(
              Radius.circular(16.0),
            )),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(15, 5, 6, 5),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: Center(
                  child: Text(
                    "${label}",
                    style: TextStyle(color: Colors.white, fontSize: CustomStyle.fontSizeSmall),
                  ),
                ),
              ),
              Container(
                  decoration: BoxDecoration(
                      color: Colors.white, shape: BoxShape.circle),
                  child: Padding(
                    padding: const EdgeInsets.all(1.0),
                    child: Icon(
                      mulai!
                          ? Icons.keyboard_arrow_right
                          : Icons.keyboard_arrow_left,
                      size: 20,
                      color: enable
                          ? mulai! ? Colors.green : Colors.red
                          : Colors.grey,
                    ),
                  ))
            ],
          ),
        ),
      ),
    );
  }
}