import 'package:absenkuv3/Bloc/Patroli/PatroliPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Patroli/KomponenPatroli.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListPatroliPegawai extends StatefulWidget {
  @override
  _HalamanListPatroliPegawaiState createState() => _HalamanListPatroliPegawaiState();
}

class _HalamanListPatroliPegawaiState extends State<HalamanListPatroliPegawai> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  ModelFilter? modelFilter;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(SetDate([DateTime.now(),DateTime.now()]));
    BlocProvider.of<PatroliPegawaiBloc>(context).add(getListPatroliEvent(context, null));
    _scrollController.addListener(()=>BlocProvider.of<PatroliPegawaiBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<PatroliPegawaiBloc, PatroliPegawaiState>(
              builder: (BuildContext context, PatroliPegawaiState state){
                if(state is getListPatroliSuccessState || state is LoadMoreProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardPatroli(state.data![index],scaffoldKey, 'checkpointPegawai');
                          }
                      ),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                else if(state is PatroliProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
              }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                listener: (BuildContext context, FilterBottomSheetState state){
                  if(state is setFilterSuccess){
                    modelFilter = state.modelFilter;
                    BlocProvider.of<PatroliPegawaiBloc>(context).add(getListPatroliEvent(context, modelFilter));
                  }
                },
                child: FilterBottomSheet()
            ),
          )
        ],
      ),
    );
  }
}

