import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/DetailPatroliBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mPatroliPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSosPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDetailPatroli extends StatefulWidget {
  var data;
  HalamanDetailPatroli(this.data);
  @override
  _HalamanDetailPatroliState createState() => _HalamanDetailPatroliState();
}

class _HalamanDetailPatroliState extends State<HalamanDetailPatroli> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  @override
  void initState() {
    super.initState();
    BlocProvider.of<DetailPatroliBloc>(context)
        .add(GetDetailPatroli(widget.data[0]));
  }

  @override
  Widget build(BuildContext context) {
    return 
    FutureBuilder<PagePatroliModel>(
    future: PengaturanBahasa().patroli(),
    builder: (BuildContext context, snapshot) {
    if (snapshot.connectionState == ConnectionState.done) {
    return 
      Scaffold(
        key: scaffoldKey,
        appBar: AppBar(
          flexibleSpace: Image(
            image: AssetImage(ValueImage.headerBiruDashboard),
            fit: BoxFit.cover,
          ),
          backgroundColor: Colors.transparent,
          centerTitle: true,
          title: Text(
            snapshot.data!.menuPatroli!.title!.titleDetail.toString(),
            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
          ),
        ),

        body: BlocBuilder<DetailPatroliBloc, DetailPatroliState>(
            builder: (BuildContext context, DetailPatroliState state) {
          if (state is DetailPatroliSuccess)
            return Stack(
              children: [
                Container(
                  height: double.infinity,
                  child: SingleChildScrollView(
                    child: Padding(
                      padding: const EdgeInsets.fromLTRB(16, 18, 16, 16),
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Padding(
                            padding: const EdgeInsets.only(bottom: 12, top: 6),
                            child: SingleChildScrollView(
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    children: [
                                      Icon(
                                        Icons.calendar_month_sharp,
                                        size: 30,
                                        color: CustomStyle.fontColorBlack,
                                      ),
                                      // Image.asset('images/kalender_icon.png', height: 25),
                                      SizedBox(
                                        width: 10,
                                      ),
                                      Text(
                                        state.checkpointRespon.data![0]
                                            .tanggalRaw!,
                                        style: TextStyle(
                                            fontSize:
                                                CustomStyle.fontSizeSmall + 1,
                                            color: CustomStyle.fontColorBlack,
                                            fontWeight: FontWeight.w600),
                                      ),
                                      SizedBox(
                                        width: 12,
                                      ),
                                    ],
                                  ),
                                  SizedBox(
                                    height: 6,
                                  ),
                                  Divider(
                                    thickness: 1,
                                  ),
                                  SizedBox(
                                    height: 4,
                                  ),
                                  Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        snapshot.data!.menuPatroli!.data!.patroli.toString(),
                                        style: TextStyle(
                                            fontWeight: FontWeight.w600,
                                            color: CustomStyle.color1,
                                            fontSize:
                                                CustomStyle.fontSizeSubTitle -
                                                    1),
                                      ),
                                      SizedBox(
                                        height: 10,
                                      ),
                                      Card(
                                        elevation: 2,
                                        shape: RoundedRectangleBorder(
                                            borderRadius:
                                                BorderRadius.circular(13)),
                                        child: Row(
                                          children: [
                                            GestureDetector(
                                              onTap: () => BlocProvider.of<
                                                      NavigatorBloc>(context)
                                                  .add(
                                                      NavigateToDetailImageClicked(
                                                          context,
                                                          state
                                                              .checkpointRespon
                                                              .data![0]
                                                              .image!)),
                                              child: Container(
                                                width: 100,
                                                height: 122,
                                                decoration: BoxDecoration(
                                                    borderRadius:
                                                        BorderRadius.only(
                                                            topLeft: Radius
                                                                .circular(13),
                                                            bottomLeft:
                                                                Radius.circular(
                                                                    13)),
                                                    image: DecorationImage(
                                                        image: NetworkImage(state
                                                            .checkpointRespon
                                                            .data![0]
                                                            .image!),
                                                        fit: BoxFit.fill)),
                                              ),
                                            ),
                                            SizedBox(width: 27),
                                            Expanded(
                                              child: Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  SizedBox(height: 15),
                                                  Row(
                                                    mainAxisAlignment:
                                                        MainAxisAlignment
                                                            .spaceBetween,
                                                    children: [
                                                      Expanded(
                                                        child: Column(
                                                          crossAxisAlignment:
                                                              CrossAxisAlignment
                                                                  .start,
                                                          children: [
                                                            Text(snapshot.data!.menuPatroli!.data!.lokasi.toString(),
                                                              overflow: TextOverflow.ellipsis,
                                                                style: TextStyle(
                                                                    fontSize: 12,
                                                                    color: Color(
                                                                        0xFF828282),
                                                                    fontWeight:
                                                                        FontWeight
                                                                            .w400)),
                                                            SizedBox(height: 5),
                                                            Text(
                                                                state
                                                                    .checkpointRespon
                                                                    .data![0]
                                                                    .lokasi!,
                                                              overflow: TextOverflow.ellipsis,
                                                                style: TextStyle(
                                                                    fontSize: 13,
                                                                    fontWeight:
                                                                        FontWeight
                                                                            .w500)),
                                                          ],
                                                        ),
                                                      ),
                                                      Container(
                                                        margin: EdgeInsets.only(
                                                            right: 15),
                                                        child: GestureDetector(
                                                          onTap: () => BlocProvider
                                                                  .of<NavigatorBloc>(
                                                                      context)
                                                              .add(NavigateToDetailMap(
                                                                  context,
                                                                  ModelDetailMap(
                                                                      "Location Patroli",
                                                                      double.parse(state
                                                                          .checkpointRespon
                                                                          .data![
                                                                              0]
                                                                          .latitude!),
                                                                      double.parse(state
                                                                          .checkpointRespon
                                                                          .data![
                                                                              0]
                                                                          .longitude!)))),
                                                          child: Icon(
                                                            Icons.pin_drop,
                                                            size: 30,
                                                            color: Colors
                                                                .redAccent,
                                                          ),
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                  SizedBox(height: 17),
                                                  Text(snapshot.data!.menuPatroli!.data!.area.toString(),
                                                      style: TextStyle(
                                                          fontSize: 13,
                                                          color:
                                                              Color(0xFF828282),
                                                          fontWeight:
                                                              FontWeight.w400)),
                                                  SizedBox(height: 5),
                                                  Text(
                                                      state.checkpointRespon
                                                          .data![0].nm_qr!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        fontWeight:
                                                            FontWeight.w600,
                                                      )),
                                                  SizedBox(height: 17),
                                                  Text(snapshot.data!.menuPatroli!.data!.jam.toString(),
                                                      style: TextStyle(
                                                          fontSize: 13,
                                                          color:
                                                              Color(0xFF828282),
                                                          fontWeight:
                                                              FontWeight.w400)),
                                                  SizedBox(height: 5),
                                                  Text(
                                                      state.checkpointRespon
                                                          .data![0].waktu!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        fontWeight:
                                                            FontWeight.w600,
                                                      )),
                                                  SizedBox(height: 17),
                                                ],
                                              ),
                                            )
                                          ],
                                        ),
                                      ),
                                      SizedBox(height: 17),
                                      BlocBuilder<AuthBloc, LoginRespon>(
                                          builder: (BuildContext context,
                                              LoginRespon loginRespon) {
                                        return widget.data[1] !=
                                                'checkpointSaya'
                                            ? Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Text(snapshot.data!.menuPatroli!.data!.namaKaryawan.toString(),
                                                      style: TextStyle(
                                                          fontSize: 13,
                                                          fontWeight:
                                                              FontWeight.w400)),
                                                  SizedBox(height: 5),
                                                  Text(
                                                      state
                                                              .checkpointRespon
                                                              .data![0]
                                                              .namaKaryawan ??
                                                          '',
                                                      style: TextStyle(
                                                          fontSize: 15,
                                                          fontWeight:
                                                              FontWeight.w500)),
                                                  SizedBox(height: 17),
                                                  Text(snapshot.data!.menuPatroli!.data!.jabatan.toString(),
                                                      style: TextStyle(
                                                          fontSize: 13,
                                                          color:
                                                              Color(0xFF828282),
                                                          fontWeight:
                                                              FontWeight.w400)),
                                                  SizedBox(height: 5),
                                                  Text(
                                                      state
                                                              .checkpointRespon
                                                              .data![0]
                                                              .namajabatan ??
                                                          '',
                                                      style: TextStyle(
                                                          fontSize: 15,
                                                          fontWeight:
                                                              FontWeight.w500)),
                                                  SizedBox(height: 17),
                                                  Text(snapshot.data!.menuPatroli!.data!.cabang.toString(),
                                                      style: TextStyle(
                                                          fontSize: 13,
                                                          color:
                                                              Color(0xFF828282),
                                                          fontWeight:
                                                              FontWeight.w400)),
                                                  SizedBox(height: 5),
                                                  Text(
                                                      state
                                                              .checkpointRespon
                                                              .data![0]
                                                              .namaCabang ??
                                                          '',
                                                      style: TextStyle(
                                                          fontSize: 15,
                                                          fontWeight:
                                                              FontWeight.w500)),
                                                  SizedBox(height: 17),
                                                  Text(snapshot.data!.menuPatroli!.data!.departemen.toString(),
                                                      style: TextStyle(
                                                          fontSize: 13,
                                                          color:
                                                              Color(0xFF828282),
                                                          fontWeight:
                                                              FontWeight.w400)),
                                                  SizedBox(height: 5),
                                                  Text(
                                                      state
                                                              .checkpointRespon
                                                              .data![0]
                                                              .namaDepartemen ??
                                                          '',
                                                      style: TextStyle(
                                                          fontSize: 15,
                                                          fontWeight:
                                                              FontWeight.w500)),
                                                  SizedBox(height: 17),
                                                ],
                                              )
                                            : Container();
                                      }),
                                      Text(snapshot.data!.menuPatroli!.data!.keterangan.toString(),
                                          style: TextStyle(
                                              fontSize: 13,
                                              color: Color(0xFF828282),
                                              fontWeight: FontWeight.w400)),
                                      SizedBox(height: 7),
                                      Text(
                                          state.checkpointRespon.data![0]
                                              .keterangan!,
                                          style: TextStyle(
                                              fontSize: 15,
                                              fontWeight: FontWeight.w500)),
                                      SizedBox(height: 17),
                                    ],
                                  ),
                                ],
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ],
            );
          else if (state is DetailPatroliProgress)
            return Container(
                height: MediaQuery.of(context).size.height,
                width: MediaQuery.of(context).size.width,
                child: Center(
                    child: CircularProgressIndicator(
                  strokeWidth: 8,
                )));
          else
            return Container();
        }));
  
    } else {
    return Container();
    }},);
  
  }
}
