import 'package:absenkuv3/Bloc/MonitorAbsensi/MonitorListIzinBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Absensi/KomponenAbsensi.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/KomponenMonitorAbsen/KomponenMonitorIzinAbsen.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListIzinMonitor extends StatefulWidget {
  var data;
  HalamanListIzinMonitor(this.data);

  @override
  State<HalamanListIzinMonitor> createState() => _HalamanListIzinMonitorState();
}

class _HalamanListIzinMonitorState extends State<HalamanListIzinMonitor> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  @override
  void initState() {
    BlocProvider.of<
        MonitorListIzinBloc>(
        context)
        .add(GetMonitorListIzinEvent(
        context,
        widget.data[0],
        ModelFilter(monthYear: widget.data[1])));
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return FutureBuilder(future: PengaturanBahasa().monitorAbsen(), builder: (context,snapshot){
      if(snapshot.connectionState == ConnectionState.done){
        return Scaffold(
          appBar: AppBar(
            title: Text(
              snapshot.data!.menuMonitorAbsensi!.titleIzin!,
              style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
            ),
            centerTitle: true,
            flexibleSpace: Image(
              image: AssetImage(ValueImage.headerBiruDashboard),
              fit: BoxFit.cover,
            ),
          ),
          body: Stack(
            children: [
              BlocBuilder<MonitorListIzinBloc,MonitorListIzinMonitorState>(builder: (BuildContext context, MonitorListIzinMonitorState state){
                if(state is SuccessMonitorListIzinMonitorState){
                  return Stack(
                    children: [
                      ListView.builder(
                      physics: AlwaysScrollableScrollPhysics(),
                      controller: _scrollController,
                      itemCount: state.dataMonitorList!.length,
                      itemBuilder: (BuildContext context, index) {
                        return CardMonitorIzinAbsenV2(
                            state.dataMonitorList![index], snapshot.data!);
                      }),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                }else if(state is ProgressMonitorListIzinMonitorState){
                  return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                }else{
                  return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                }
              })
          ],
        ));
      }else{
        return Container();
      }
    });
  }
}