import 'package:aad_oauth/aad_oauth.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLoginPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/oauth_config.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogConfirmation.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:pretty_dio_logger/pretty_dio_logger.dart';
import '../../Template/style.dart';
import '../../Template/templateButton.dart';

class HalamanLoginSSO extends StatefulWidget {
  @override
  State<HalamanLoginSSO> createState() => _HalamanLoginSSOState();
}

class _HalamanLoginSSOState extends State<HalamanLoginSSO> {
  late AadOAuth oauth;
  final GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey<ScaffoldState>();
  String bahasa = '';

  @override
  void initState() {
    PengaturanBahasa().getDataBahasa().then((value) => {
          setState(() {
            bahasa = value;
          })
        });
    oauth = OAuthService.oauth;
    super.initState();
  }

  Future<Response> getUserDetails({required String token}) async {
    var dio = Dio();
    dio.options.headers = {'Authorization': 'Bearer $token'};
    dio.interceptors.add(PrettyDioLogger());

    try {
      return await dio.get('https://undip.absenku.com/api/auth/microsoft');
    } catch (e) {
      print('Http Error: ${e.toString()}');
      rethrow;
    }
  }

  void _loginAndFetchUser() async {
    try {
      await oauth.login();
      final accessToken = await oauth.getAccessToken();
      print('Access Token: $accessToken');

      if (accessToken != null && accessToken.isNotEmpty) {
        BlocProvider.of<AuthBloc>(context)
            .add(LoginSSOEvent(accessToken, context, _scaffoldKey));
      } else {
        ScaffoldMessenger.of(context).showSnackBar(
          SnackBar(content: Text('Gagal mendapatkan access token.')),
        );
      }
    } catch (e) {
      print('Login error: $e');
      ScaffoldMessenger.of(context).showSnackBar(
        SnackBar(content: Text('Login error: $e')),
      );
    }
  }

  void _logout() async {
    try {
      await oauth.logout();
      print('Logout berhasil');
      ScaffoldMessenger.of(context).showSnackBar(
        const SnackBar(content: Text("Logout berhasil")),
      );
    } catch (e) {
      print('Logout error: $e');
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: _scaffoldKey,
      body: FutureBuilder<PageLoginModel>(
          future: PengaturanBahasa().login(),
          builder: (context, snapshot) {
            Future<bool> keluar() async {
              showDialog(
                barrierDismissible: false,
                context: context,
                builder: (BuildContext context) => AlertConfirmation(
                    message: snapshot.data!.message!.exit!,
                    textBtnCancel: snapshot.data!.message!.btnTidak!,
                    textBtnSubmit: snapshot.data!.message!.btnYa!,
                    onClick: () {
                      SystemNavigator.pop();
                    }),
              );
              return false;
            }

            return WillPopScope(
              onWillPop: keluar,
              child: SingleChildScrollView(
                child: Container(
                  height: MediaQuery.of(context).size.height,
                  child: Stack(
                    children: <Widget>[
                      Column(
                        children: <Widget>[
                          Container(
                            width: double.infinity,
                            height: MediaQuery.of(context).size.height / 2.6,
                            child: Image.asset(
                              ValueImage.headerBiruLogin,
                              fit: BoxFit.fitWidth,
                            ),
                          ),
                          Expanded(
                            child: Container(
                              width: double.infinity,
                              height: MediaQuery.of(context).size.height / 3,
                              child: Image.asset(
                                ValueImage.backgroundLogin,
                                fit: BoxFit.fitWidth,
                              ),
                            ),
                          ),
                        ],
                      ),
                      Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: <Widget>[
                          Container(
                            margin: EdgeInsets.only(left: 16, right: 16),
                            width: double.infinity,
                            padding: const EdgeInsets.fromLTRB(18, 24, 18, 32),
                            decoration: BoxDecoration(
                                boxShadow: [
                                  BoxShadow(
                                    color: Colors.grey.withOpacity(0.3),
                                    spreadRadius: 3,
                                    blurRadius: 7,
                                    offset: Offset(
                                        0, 1), // changes position of shadow
                                  ),
                                ],
                                color: Colors.white,
                                borderRadius:
                                    new BorderRadius.all(Radius.circular(18))),
                            child: Column(
                              children: <Widget>[
                                Padding(
                                  padding: const EdgeInsets.symmetric(
                                      horizontal: 50),
                                  child: Image.asset(
                                    ValueImage.logoAbsenku,
                                    fit: BoxFit.fill,
                                  ),
                                ),
                                SizedBox(
                                  height: CustomStyle.marginPerWidget + 16,
                                ),
                                TemplateButton(
                                  onClick: () async {
                                    _loginAndFetchUser();
                                  },
                                  label: snapshot.data == null
                                      ? ""
                                      : snapshot.data!.menuLogin!.btnMasuk,
                                  color: CustomStyle.color1,
                                  fontSize: CustomStyle.fontSizeNormal,
                                  paddingTopBottom: 8,
                                  expand: true,
                                  borderColor: Colors.white,
                                  radius: 24,
                                  heightButton: 42,
                                ),
                                SizedBox(
                                  height: 20,
                                ),
                                TemplateButton(
                                  onClick: () async {
                                    _logout();
                                  },
                                  label: 'Reset SSO',
                                  color: CustomStyle.color1,
                                  fontSize: CustomStyle.fontSizeNormal,
                                  paddingTopBottom: 8,
                                  expand: true,
                                  borderColor: Colors.white,
                                  radius: 24,
                                  heightButton: 42,
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
              ),
            );
            // }else{
            //   return Container();
            // }
          }),
    );
    //   }
    // }
    // );
  }
}
