import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/EmailBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLoginPage.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/LupaPassword/HalamanUsername.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogConfirmation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../Template/style.dart';
import '../../Template/templateButton.dart';
import '../../Template/templateForm.dart';
import '../../Template/templateFormPassword.dart';

class HalamanLogin extends StatefulWidget {
  @override
  State<HalamanLogin> createState() => _HalamanLoginState();
}

class _HalamanLoginState extends State<HalamanLogin> {
  final GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey<ScaffoldState>();

  final TextEditingController username = new TextEditingController();

  final TextEditingController password = new TextEditingController();

  final TextEditingController email = new TextEditingController();
  String bahasa = '';

  @override
  void initState() {
    PengaturanBahasa().getDataBahasa().then((value) =>
    {setState(() {
    bahasa = value;
    })});
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    // openDialog() {
    //   TextEditingController email = new TextEditingController();
    //   showDialog(
    //       context: context,
    //       builder: (BuildContext context) {
    //         return AlertDialog(
    //           shape: RoundedRectangleBorder(
    //               borderRadius:
    //               BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
    //           content: Column(
    //             mainAxisSize: MainAxisSize.min,
    //             children: [
    //               Container(
    //                 padding: const EdgeInsets.only(bottom: 12, top: 6),
    //                 width: MediaQuery.of(context).size.width,
    //                 child: SingleChildScrollView(
    //                   child: Column(
    //                     crossAxisAlignment: CrossAxisAlignment.start,
    //                     children: [
    //                       TemplateForm(
    //                         controller: email,
    //                         color: CustomStyle.formColor,
    //                         radius: CustomStyle.formRadius,
    //                         formHeight: CustomStyle.formHeight,
    //                         titleText: "Email",
    //                       ),
    //                       BlocBuilder<ResetPasswordBloc, ResetPasswordState>(
    //                           builder: (BuildContext context, ResetPasswordState state) {
    //                             if (state is CekPasswordFalseState)
    //                               return Text(
    //                                 state.message!,
    //                                 style: TextStyle(
    //                                     fontSize: CustomStyle.fontSizeSmall,
    //                                     color: Colors.redAccent),
    //                               );
    //                             else
    //                               return Container();
    //                           })
    //                     ],
    //                   ),
    //                 ),
    //               ),
    //               Row(
    //                 mainAxisAlignment: MainAxisAlignment.spaceBetween,
    //                 children: [
    //                   TemplateButton(
    //                     onClick: () => BlocProvider.of<NavigatorBloc>(context)
    //                         .add(NavigatePop(context)),
    //                     label: "Tutup",
    //                     color: Colors.transparent,
    //                     contentColor: CustomStyle.color1,
    //                     fontSize: CustomStyle.fontSizeNormal,
    //                     bold: true,
    //                   ),
    //                   TemplateButton(
    //                     onClick: () {
    //                       // Navigator.of(context).pop();
    //                       BlocProvider.of<ResetPasswordBloc>(context)
    //                         .add(CekEmailEvent(context, email.text));
    //                     },
    //                     label: "RESET",
    //                     color: Colors.transparent,
    //                     contentColor: CustomStyle.color1,
    //                     fontSize: CustomStyle.fontSizeNormal,
    //                     bold: true,
    //                   )
    //                 ],
    //               )
    //             ],
    //           ),
    //         );
    //       });
    // }
    // return FutureBuilder<PageLoginModel>(
    //   future: PengaturanBahasa().login(),
    //   builder: (context, snapshot){
    //     if(snapshot.connectionState == ConnectionState.done){

          return Scaffold(
            key: _scaffoldKey,
            body: FutureBuilder<PageLoginModel>(
                future: PengaturanBahasa().login(),
                builder: (context, snapshot){
                  // if(snapshot.connectionState == ConnectionState.done){
                  // String bahasa = 'en';
                  // PengaturanBahasa().getDataBahasa().then((value) =>
                  // {bahasa = value, print("papapa : $value")});
                    Future<bool> keluar() async{
                      showDialog(
                        barrierDismissible: false,
                        context: context,
                        builder: (BuildContext context) => AlertConfirmation(
                            message: snapshot.data!.message!.exit!,
                            textBtnCancel: snapshot.data!.message!.btnTidak!,
                            textBtnSubmit: snapshot.data!.message!.btnYa!,
                            onClick: () {
                              SystemNavigator.pop();
                            }),
                      );
                      return false;
                    }
                    return WillPopScope(
                      onWillPop: keluar,
                      child: SingleChildScrollView(
                        child: Container(
                          height: MediaQuery.of(context).size.height,
                          child: Stack(
                            children: <Widget>[
                              Column(
                                children: <Widget>[
                                  Container(
                                    width: double.infinity,
                                    height: MediaQuery.of(context).size.height / 2.6,
                                    child: Image.asset(
                                      ValueImage.headerBiruLogin,
                                      fit: BoxFit.fitWidth,
                                    ),
                                  ),
                                  Expanded(
                                    child: Container(
                                      width: double.infinity,
                                      height: MediaQuery.of(context).size.height / 3,
                                      child: Image.asset(
                                        ValueImage.backgroundLogin,
                                        fit: BoxFit.fitWidth,
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                              Column(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: <Widget>[
                                  Container(
                                    margin: EdgeInsets.only(left: 16, right: 16),
                                    width: double.infinity,
                                    padding: const EdgeInsets.fromLTRB(18, 24, 18, 32),
                                    decoration: BoxDecoration(
                                        boxShadow: [
                                          BoxShadow(
                                            color: Colors.grey.withOpacity(0.3),
                                            spreadRadius: 3,
                                            blurRadius: 7,
                                            offset:
                                            Offset(0, 1), // changes position of shadow
                                          ),
                                        ],
                                        color: Colors.white,
                                        borderRadius:
                                        new BorderRadius.all(Radius.circular(18))),
                                    child: Column(
                                      children: <Widget>[
                                        Padding(
                                          padding: const EdgeInsets.symmetric(horizontal: 50),
                                          child: Image.asset(
                                            ValueImage.logoAbsenku,
                                            fit: BoxFit.fill,
                                          ),
                                        ),
                                        SizedBox(
                                          height: CustomStyle.marginPerWidget + 16,
                                        ),
                                        TemplateForm(
                                            formHeight: 42,
                                            hintText: snapshot.data == null ? "" : snapshot.data!.menuLogin!.username,
                                            controller: username,
                                            adaValidasi: true,
                                            color: Colors.grey,
                                            radius: 24,
                                            prefixIcon: Icon(
                                              Icons.person,
                                              size: 20,
                                            )),
                                        SizedBox(
                                          height: 8,
                                        ),
                                        TemplateFormPassword(
                                          formHeight: 42,
                                          hintText: snapshot.data == null ? "" : snapshot.data!.menuLogin!.password,
                                          controller: password,
                                          color: Colors.grey,
                                          radius: 24,
                                          prefixIcon: Icon(
                                            Icons.lock,
                                            size: 18,
                                          ),
                                        ),
                                        SizedBox(
                                          height: 8,
                                        ),
                                        InkWell(
                                          onTap: ()=> Navigator.push(context, MaterialPageRoute(builder: (_)=> HalamanUsername(snapshot.data!))),
                                          child: Align(
                                            alignment: Alignment.centerRight,
                                            child: Text(
                                              snapshot.data == null ? "" : "${snapshot.data!.menuLogin!.lupaPassword}?",
                                              style: TextStyle(
                                                  fontSize: CustomStyle.fontSizeSmall,
                                                  color: CustomStyle.color1),
                                            ),
                                          ),
                                        ),
                                        SizedBox(
                                          height: 18,
                                        ),
                                        TemplateButton(
                                          onClick: () async {
                                            BlocProvider.of<AuthBloc>(context).add(LoginEvent(
                                                username.text,
                                                password.text,
                                                context,
                                                _scaffoldKey));
                                          },
                                          label: snapshot.data == null ? "" : snapshot.data!.menuLogin!.btnMasuk,
                                          color: CustomStyle.color1,
                                          fontSize: CustomStyle.fontSizeNormal,
                                          paddingTopBottom: 8,
                                          expand: true,
                                          borderColor: Colors.white,
                                          radius: 24,
                                          heightButton: 42,
                                        ),
                                        SizedBox(
                                          height: 20,
                                        ),
                                        /*Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: <Widget>[
                              Text(
                                "Belum Punya Akun?",
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall,
                                    color: CustomStyle.fontColorGrey),
                              ),
                              SizedBox(
                                width: 6,
                              ),
                              Text(
                                "Daftar Sekarang",
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall,
                                    color: CustomStyle.color1),
                              ),
                            ],
                          ),*/
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                              // Container(
                              //   margin: EdgeInsets.fromLTRB(0, 50, 17, 0),
                              //   // color: Colors.white,
                              //   child: Align(
                              //     alignment: Alignment.topRight,
                              //     child: ToggleSwitch(
                              //       // minWidth: 65.0,
                              //       cornerRadius: 20.0,
                              //       activeBgColors: [[Colors.blue[800]!], [Colors.blue[800]!]],
                              //       activeFgColor: Colors.white,
                              //       inactiveBgColor: Colors.white,
                              //       inactiveFgColor: Colors.black,
                              //       borderColor: [Colors.white],
                              //       // icons: [Icons.add, Icons.access_time_filled],
                              //       borderWidth: 0.0,
                              //       fontSize: 11,
                              //       initialLabelIndex: bahasa == '' || bahasa == 'en' ? 1 : 0,
                              //       totalSwitches: 2,
                              //       customWidths: [68,60],
                              //       labels: ['Indonesia', 'English'],
                              //       radiusStyle: true,
                              //       onToggle: (index) async {
                              //         print('switched to: $index');
                              //         // ProgressDialog pd = ProgressDialog(
                              //         //   context: context
                              //         // ).show(barrierDismissible: true);
                              //         if(index == 0){
                              //           await sharedPreferences().setBahasa('id');
                              //         }else{
                              //           await sharedPreferences().setBahasa('en');
                              //         }
                              //         print('HHHHH : ${await sharedPreferences().getBahasa()}');
                              //         // BlocProvider.of<NavigatorBloc>(context)
                              //         //     .add(NavigateRemoveToLogin(context));
                              //         // pd.close();
                              //         setState(() async {
                              //           bahasa = await sharedPreferences().getBahasa();
                              //         });
                              //       },
                              //     ),
                              //   ),
                              // ),
                            ],
                          ),
                        ),
                      ),
                    );
                  // }else{
                  //   return Container();
                  // }
                }
            ),
          );
      //   }
      // }
    // );
  }
}
