import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Lembur/DetailLemburBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/LemburPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/Bloc/date_pick_bloc.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/CustomCupertinoDateTimePicker.dart';
import 'package:absenkuv3/UI/Template/Snackbar/CustomSnackbar.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../../Repository/Model/mLembur.dart';
import '../../Template/halamanDetailMap.dart';
import 'package:intl/intl.dart';

class HalamanDetailLembur extends StatefulWidget {
  final data; //[0] = data, [1] = konteks
  HalamanDetailLembur(this.data);
  @override
  _HalamanDetailLemburState createState() => _HalamanDetailLemburState();
}

class _HalamanDetailLemburState extends State<HalamanDetailLembur> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  bool refresh = false;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DetailLemburBloc>(context)
        .add(GetDetailLembur(widget.data![0], widget.data![1]));
    BlocProvider.of<NotifBloc>(context)
        .add(BacaNotif(widget.data![0], 'lembur', context));
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  Future<bool> keluar2() async {
    if(widget.data[2] == 'notif'){
      Navigator.pop(context, refresh);
    }else{
      BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    }
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar2,
      child: FutureBuilder<PageLemburModel>(
        future: PengaturanBahasa().lembur(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return BlocListener<NotifBloc, NotifState>(
              listener: (context, stateNotifBloc) {
                if(stateNotifBloc is SuccessBacaNotifState){
                  refresh = true;
                }
              },
              child: Scaffold(
                  key: scaffoldKey,
                  backgroundColor: Colors.white,
                  appBar: AppBar(
                    flexibleSpace: Image(
                      image: AssetImage(ValueImage.headerBiruDashboard),
                      fit: BoxFit.cover,
                    ),
                    backgroundColor: Colors.transparent,
                    centerTitle: true,
                    title: Text(
                      snapshot.data!.menuLembur!.titleDetail!,
                      style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                    ),
                  ),
                  body: BlocBuilder<DetailLemburBloc, DetailLemburState>(
                      builder: (BuildContext context, DetailLemburState state) {
                        if (state is DetailLemburSuccess) {
                          DataLembur dataLembur = state.lemburRespon!.data![0];
                          return Stack(
                            children: [
                              Container(
                                height: double.infinity,
                                child: SingleChildScrollView(
                                  child: Padding(
                                    padding: const EdgeInsets.fromLTRB(16, 18, 16, 16),
                                    child: Column(
                                      mainAxisSize: MainAxisSize.min,
                                      children: [
                                        Container(
                                          margin: const EdgeInsets.only(
                                            bottom: 80,
                                          ),
                                          padding:
                                          const EdgeInsets.only(bottom: 12, top: 6),
                                          child: SingleChildScrollView(
                                            child: Column(
                                              crossAxisAlignment: CrossAxisAlignment.start,
                                              children: [
                                                Row(
                                                  children: [
                                                    Icon(
                                                      Icons.calendar_month,
                                                      size: 28,
                                                    ),
                                                    SizedBox(
                                                      width: 8,
                                                    ),
                                                    TemplateColumn(
                                                      title: snapshot.data!.menuLembur!.data!.tanggalPengajuan,
                                                      value: DateFormat('EEEE, dd MMMM yyyy', snapshot.data!.menuLembur!.locale).format(DateTime.parse(dataLembur.tglAbsenMasuk!)),
                                                    ),
                                                  ],
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                Divider(),
                                                widget.data![1] == "lemburPegawai" ||
                                                    widget.data![1] == "rekapPegawai"
                                                    ? Column(
                                                  crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                                  children: [
                                                    Text(
                                                      snapshot.data!.menuLembur!.data!.dataKaryawan!,
                                                      style: TextStyle(
                                                          fontSize: 22,
                                                          fontWeight:
                                                          FontWeight.bold),
                                                    ),
                                                    SizedBox(
                                                      height: 16,
                                                    ),
                                                    TemplateColumn(
                                                      title: snapshot.data!.menuLembur!.data!.namaKaryawan,
                                                      value: dataLembur.nama,
                                                    ),
                                                    SizedBox(
                                                      height: 16,
                                                    ),
                                                    TemplateColumn(
                                                      title: snapshot.data!.menuLembur!.data!.jabatan,
                                                      value: dataLembur.jabatan,
                                                    ),
                                                    SizedBox(
                                                      height: 16,
                                                    ),
                                                    TemplateColumn(
                                                      title: snapshot.data!.menuLembur!.data!.cabang,
                                                      value: dataLembur.cabang,
                                                    ),
                                                    SizedBox(
                                                      height: 16,
                                                    ),
                                                    TemplateColumn(
                                                      title: snapshot.data!.menuLembur!.data!.departemen,
                                                      value: dataLembur.departemen,
                                                    ),
                                                    SizedBox(
                                                      height: 32,
                                                    ),
                                                    Divider(),
                                                  ],
                                                )
                                                    : Container(),
                                                Text(
                                                  snapshot.data!.menuLembur!.data!.header!,
                                                  style: TextStyle(
                                                      fontSize: 22,
                                                      fontWeight: FontWeight.bold),
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                TemplateColumn(
                                                  title: snapshot.data!.menuLembur!.data!.totalLembur,
                                                  value: dataLembur.totalJamLembur,
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                Text(
                                                  snapshot.data!.menuLembur!.data!.approval!,
                                                  style: TextStyle(
                                                      fontSize: 12,
                                                      fontWeight: FontWeight.w400,
                                                      color: CustomStyle.fontColorGrey),
                                                ),
                                                SizedBox(
                                                  height: 8,
                                                ),
                                                state.lemburRespon!.data![0].listApproval !=
                                                    null
                                                    ? Column(
                                                  crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                                  children: [
                                                    Wrap(
                                                      spacing: 8,
                                                      direction: Axis.vertical,
                                                      runSpacing: 4,
                                                      children: state.lemburRespon!
                                                          .data![0].listApproval!
                                                          .map(
                                                            (item) => TemplateButton(
                                                          label:
                                                          item.statusApproval,
                                                          color: Color(int.parse(
                                                              item.warnaStatus!)),
                                                          heightButton: 24,
                                                          radius: 4,
                                                          paddingTopBottom: 0,
                                                          contentColor: Color(
                                                              int.parse(item
                                                                  .warnaFont!)),
                                                          bold: true,
                                                        ),
                                                      )
                                                          .toList(),
                                                    ),
                                                    SizedBox(
                                                      height: 6,
                                                    ),
                                                    Divider(
                                                      thickness: 1,
                                                    ),
                                                    SizedBox(
                                                      height: 4,
                                                    ),
                                                  ],
                                                )
                                                    : Container(),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                KomponenCardAbsensi(
                                                  data: dataLembur,
                                                  redaksional: snapshot.data,
                                                )
                                              ],
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ),
                              Positioned(
                                bottom: 0,
                                child: widget.data![1] == 'lemburPegawai' &&
                                    state.lemburRespon!.data![0].aksi!
                                    ? Container(
                                  padding: EdgeInsets.only(left: 22, right: 22),
                                  decoration: BoxDecoration(
                                      boxShadow: [
                                        BoxShadow(
                                          color: Colors.grey.withOpacity(0.4),
                                          spreadRadius: 2,
                                          blurRadius: 7,
                                          offset: Offset(
                                              0, 1), // changes position of shadow
                                        ),
                                      ],
                                      color: Colors.white,
                                      borderRadius: new BorderRadius.only(
                                          topLeft: Radius.circular(
                                              CustomStyle.boxRadius + 4),
                                          topRight: Radius.circular(
                                              CustomStyle.boxRadius + 4))),
                                  height: 62,
                                  width: MediaQuery.of(context).size.width,
                                  child: Row(
                                    children: <Widget>[
                                      Expanded(
                                        child: TemplateButton(
                                          onClick: () => 
                                          TemplateConfirmationDialog(
                                              state.lemburRespon!.data![0].buttonApprovalHrd!
                                                  ? snapshot.data!.menuLembur!.messageKonfirmasi!.tolakSemua!
                                                  : snapshot.data!.menuLembur!.messageKonfirmasi!.tolak!,
                                                  () => state.lemburRespon!.data![0]
                                                  .buttonApprovalHrd!
                                                  ? BlocProvider.of<LemburPegawaiBloc>(context)
                                                  .add(MewakiliTolakLembur(
                                                  state.lemburRespon!.data![0]
                                                      .idLemmulai,
                                                  context,
                                                  scaffoldKey,
                                                  'detailLembur'))
                                                  : BlocProvider.of<LemburPegawaiBloc>(context)
                                                  .add(tolakLembur(
                                                  state.lemburRespon!.data![0]
                                                      .idLemmulai,
                                                  context,
                                                  scaffoldKey,
                                                  'detailLembur')),
                                              context),
                                          label: state.lemburRespon!.data![0]
                                              .buttonApprovalHrd!
                                              ? snapshot.data!.menuLembur!.button!.btnTolakSemua!
                                              : snapshot.data!.menuLembur!.button!.btnTolak!,
                                          color: Colors.grey[500],
                                          heightButton: 28,
                                          radius: CustomStyle.boxRadius + 4,
                                          icon: Icons.close,
                                          bold: true,
                                          fontSize: CustomStyle.fontSizeSmall - 1,
                                          iconSize: 16,
                                          paddingTopBottom: 0,
                                        ),
                                      ),
                                      SizedBox(
                                        width: 12,
                                      ),
                                      Expanded(
                                        child: TemplateButton(
                                          onClick: () => 
                                          state.lemburRespon!.data![0].firstApproval! ? openBottomSheet(
                                              context,
                                              state.lemburRespon!.data![0].jamMulai!,
                                              state
                                                  .lemburRespon!.data![0].jamSelesai!,
                                              state.lemburRespon!.data![0]
                                                  .buttonApprovalHrd!,
                                              state
                                                  .lemburRespon!.data![0].idLemmulai!,
                                              scaffoldKey,snapshot.data!.menuLembur!):
                                          TemplateConfirmationDialog(
                                              state.lemburRespon!.data![0].buttonApprovalHrd!
                                                  ? snapshot.data!.menuLembur!.messageKonfirmasi!.setujuiSemua!
                                                  : snapshot.data!.menuLembur!.messageKonfirmasi!.setujui!,
                                                  () => state.lemburRespon!.data![0]
                                                  .buttonApprovalHrd!
                                                  ? BlocProvider.of<LemburPegawaiBloc>(context)
                                                  .add(MewakiliSetujuiLembur(
                                                  state.lemburRespon!.data![0]
                                                      .idLemmulai,
                                                  context,
                                                  scaffoldKey,
                                                  'detailLembur'))
                                                  : BlocProvider.of<LemburPegawaiBloc>(context)
                                                  .add(setujuiLembur(
                                                  state.lemburRespon!.data![0]
                                                      .idLemmulai,
                                                  context,
                                                  scaffoldKey,
                                                  'detailLembur')),
                                              context),
                                          label: state.lemburRespon!.data![0]
                                              .buttonApprovalHrd!
                                              ? snapshot.data!.menuLembur!.button!.btnSetujuiSemua!
                                              : snapshot.data!.menuLembur!.button!.btnSetujui!,
                                          color: CustomStyle.color1,
                                          heightButton: 28,
                                          radius: CustomStyle.boxRadius + 4,
                                          icon: Icons.check,
                                          bold: true,
                                          fontSize: CustomStyle.fontSizeSmall - 1,
                                          iconSize: 16,
                                          paddingTopBottom: 0,
                                        ),
                                      ),
                                      SizedBox(
                                        width: 16,
                                      ),
                                      GestureDetector(
                                          onTap: () =>
                                              BlocProvider.of<NavigatorBloc>(context)
                                                  .add(NavigatePop(context)),
                                          child: Icon(
                                            Icons.chevron_left,
                                            size: 34,
                                            color: CustomStyle.fontColorGrey,
                                          ))
                                    ],
                                  ),
                                )
                                    : Container(),
                              )
                            ],
                          );
                        } else if (state is DetailLemburProgress)
                          return Container(
                              height: MediaQuery.of(context).size.height,
                              width: MediaQuery.of(context).size.width,
                              child: Center(
                                  child: CircularProgressIndicator(
                                    strokeWidth: 8,
                                  )));
                        else
                          return Container();
                      })),
            );
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
      ),
    );
  }
}

class KomponenCardAbsensi extends StatelessWidget {
  final DataLembur? data;
  final String? title;
  final PageLemburModel? redaksional;

  KomponenCardAbsensi({Key? key, this.data, this.title, this.redaksional}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    String? titleMulai;
    String? titleSelesai;
    // String? jamAbsenMasuk;
    String? keteranganMasuk;
    String? fotoMasuk;
    String? latMasuk;
    String? longMasuk;

    // String? jamAbsenPulang;
    String? keteranganPulang;
    String? fotoPulang;
    String? latPulang;
    String? longPulang;
    titleMulai = redaksional!.menuLembur!.data!.lemburMulai!;
    titleSelesai = redaksional!.menuLembur!.data!.lemburSelesai!;
    // jamAbsenMasuk = data!.jamMasuk;
    keteranganMasuk = data!.ketLemburMasuk;
    fotoMasuk = data!.fotoMasuk;
    latMasuk = data!.latMulai;
    longMasuk = data!.longMulai;

    // jamAbsenPulang = data!.jamPulang;
    keteranganPulang = data!.ketLemburPulang;
    fotoPulang = data!.fotoPulang;
    latPulang = data!.latSelesai;
    longPulang = data!.longSelesai;

    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          decoration: BoxDecoration(
              color: Colors.green,
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          child: Container(
              margin: EdgeInsets.only(left: 5),
              decoration: CustomStyle.boxDecoration2,
              child: Container(
                padding: EdgeInsets.all(15),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Expanded(
                      flex: 2,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            titleMulai,
                            style: TextStyle(
                                fontSize: 12,
                                fontWeight: FontWeight.w400,
                                color: CustomStyle.fontColorGrey),
                          ),
                          SizedBox(
                            height: 8,
                          ),
                          Text(
                            data!.lokasiMasuk.toString(),
                            style: TextStyle(
                                fontSize: 12, fontWeight: FontWeight.w600),
                          ),
                          SizedBox(
                            height: 12,
                          ),
                          Text(
                            redaksional!.menuLembur!.data!.keterangan!,
                            style: TextStyle(
                                fontSize: 12,
                                fontWeight: FontWeight.w400,
                                color: CustomStyle.fontColorGrey),
                          ),
                          SizedBox(
                            height: 8,
                          ),
                          Text(
                            keteranganMasuk.toString(),
                            style: TextStyle(
                                fontSize: 12, fontWeight: FontWeight.w600),
                          ),
                          SizedBox(
                            height: 12,
                          ),
                        ],
                      ),
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Row(
                          children: [
                            //image
                            GestureDetector(
                                onTap: () =>
                                    BlocProvider.of<NavigatorBloc>(context).add(
                                        NavigateToDetailImageClicked(
                                            context, fotoMasuk)),
                                child: ClipOval(
                                  child: Image.network(
                                    fotoMasuk.toString(),
                                    height: 30,
                                    width: 30,
                                    fit: BoxFit.cover,
                                    errorBuilder: (BuildContext context,
                                        Object exception,
                                        StackTrace? stackTrace) {
                                      return Icon(
                                        Icons.image,
                                        size: 30,
                                      );
                                    },
                                  ),
                                )),

                            SizedBox(
                              width: 4,
                            ),
                            GestureDetector(
                              onTap: () =>
                                  BlocProvider.of<NavigatorBloc>(context).add(
                                      NavigateToDetailMap(
                                          context,
                                          ModelDetailMap(
                                              "${redaksional!.menuLembur!.data!.lokasiAbsen} $title",
                                              double.parse(latMasuk!),
                                              double.parse(longMasuk!)))),
                              child: Icon(
                                Icons.pin_drop,
                                size: 30,
                                color: Colors.redAccent,
                              ),
                            ),
                          ],
                        )
                      ],
                    )
                  ],
                ),
              )),
        ),
        SizedBox(
          height: 12,
        ),
        Container(
          decoration: BoxDecoration(
              color: Colors.redAccent,
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          child: Container(
            margin: EdgeInsets.only(left: 5),
            decoration: CustomStyle.boxDecoration2,
            child: Container(
              padding: EdgeInsets.all(15),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Expanded(
                    flex: 2,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          titleSelesai,
                          style: TextStyle(
                              fontSize: 12,
                              fontWeight: FontWeight.w400,
                              color: CustomStyle.fontColorGrey),
                        ),
                        SizedBox(
                          height: 8,
                        ),
                        Text(
                          data!.lokasiPulang.toString(),
                          style: TextStyle(
                              fontSize: 12, fontWeight: FontWeight.w600),
                        ),
                        SizedBox(
                          height: 12,
                        ),
                        Text(
                          redaksional!.menuLembur!.data!.keterangan!,
                          style: TextStyle(
                              fontSize: 12,
                              fontWeight: FontWeight.w400,
                              color: CustomStyle.fontColorGrey),
                        ),
                        SizedBox(
                          height: 8,
                        ),
                        Text(
                          keteranganPulang.toString(),
                          style: TextStyle(
                              fontSize: 12, fontWeight: FontWeight.w600),
                        ),
                        SizedBox(
                          height: 12,
                        ),
                      ],
                    ),
                  ),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        children: [
                          //image
                          GestureDetector(
                              onTap: () =>
                                  BlocProvider.of<NavigatorBloc>(context).add(
                                      NavigateToDetailImageClicked(
                                          context, fotoPulang)),
                              child: ClipOval(
                                child: Image.network(
                                  fotoPulang.toString(),
                                  height: 30,
                                  width: 30,
                                  fit: BoxFit.cover,
                                  errorBuilder: (BuildContext context,
                                      Object exception,
                                      StackTrace? stackTrace) {
                                    return Icon(
                                      Icons.image,
                                      size: 30,
                                    );
                                  },
                                ),
                              )),

                          SizedBox(
                            width: 4,
                          ),
                          GestureDetector(
                            onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                .add(NavigateToDetailMap(
                                    context,
                                    ModelDetailMap(
                                        "${redaksional!.menuLembur!.data!.lokasiAbsen} $title",
                                        double.parse(latPulang!),
                                        double.parse(longPulang!)))),
                            child: Icon(
                              Icons.pin_drop,
                              size: 30,
                              color: Colors.redAccent,
                            ),
                          ),
                        ],
                      )
                    ],
                  )
                ],
              ),
            ),
          ),
        )
      ],
    );
  }
}

class TemplateColumn extends StatelessWidget {
  final String? title;
  final String? value;
  TemplateColumn({super.key, this.title, this.value});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w400,
              color: CustomStyle.fontColorGrey),
        ),
        SizedBox(
          height: 8,
        ),
        Text(
          value!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w600,
              color: CustomStyle.fontColorBlack),
        ),
      ],
    );
  }
}

void openBottomSheet(BuildContext contextA, String mulai, String selesai,
    bool buttonApvHrd, String idLembur, GlobalKey<ScaffoldState> scaffoldKey,MenuLembur redaksional) {
  final TextEditingController jamMulai = TextEditingController();
  final TextEditingController jamMulaiDisplay = TextEditingController();
  final TextEditingController jamSelesai = TextEditingController();
  final TextEditingController jamSelesaiDisplay = TextEditingController();


  DateFormat format = DateFormat('dd-MM-yyyy HH:mm');
  DateTime setmulai = format.parse(mulai);
  DateTime setselesai = format.parse(selesai);

  BlocProvider.of<DatePickBloc>(contextA).add(PickStartDateEvent(setmulai));
  BlocProvider.of<DatePickBloc>(contextA).add(PickEndDateEvent(setselesai));
  int selisihJam = 0;
  int selisihMenit = 0;
  int selisihDetik = 0;
  showModalBottomSheet(
    context: contextA,
    isScrollControlled: true,
    shape: RoundedRectangleBorder(
      borderRadius: BorderRadius.vertical(top: Radius.circular(16.0)),
    ),
    builder: (context) {
      return StatefulBuilder(
          builder: (BuildContext context, StateSetter setState) {
        return Padding(
          padding: MediaQuery.of(context).viewInsets,
          child: SingleChildScrollView(
            child: Padding(
              padding: const EdgeInsets.all(16.0),
              child: Column(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Text(
                        redaksional.data!.approvalLembur!,
                        style: TextStyle(
                          fontSize: 18,
                          fontWeight: FontWeight.bold,
                        ),
                      ),
                      IconButton(
                        onPressed: () => Navigator.pop(context),
                        icon: Icon(Icons.close),
                      ),
                    ],
                  ),
                  Divider(
                    thickness: 1,
                  ),
                  SizedBox(height: 8.0),
                  Container(
                    padding: EdgeInsets.all(12.0),
                    decoration: BoxDecoration(
                      color: Colors.blue[50],
                      borderRadius: BorderRadius.circular(8.0),
                      border: Border.all(color: Colors.blue),
                    ),
                    child: Row(
                      children: [
                        Icon(Icons.info, color: Colors.blue),
                        SizedBox(width: 8.0),
                        Expanded(
                          child: Text(
                            redaksional.data!.info!,
                            style: TextStyle(color: Colors.blue),
                          ),
                        ),
                      ],
                    ),
                  ),
                  SizedBox(height: 16.0),
                  Container(
                    padding: EdgeInsets.all(12.0),
                    decoration: BoxDecoration(
                      color: Colors.red[50],
                      borderRadius: BorderRadius.circular(8.0),
                      border: Border.all(color: Colors.red),
                    ),
                    child: Row(
                      children: [
                        Icon(Icons.timer_sharp, color: Colors.red),
                        SizedBox(width: 8.0),
                        Expanded(
                          child: Text(
                            '${redaksional.data!.totalLembur} : $selisihJam ${redaksional.data!.jam}, $selisihMenit ${redaksional.data!.menit}',
                            style: TextStyle(color: Colors.red,fontWeight:FontWeight.bold),
                          ),
                        ),
                      ],
                    ),
                  ),
                  SizedBox(height: 16.0),
                  Column(
                    children: [
                      BlocBuilder<DatePickBloc, DatePickState>(
                          builder: (context, state) {
                        if (state is DateSelected) {
                          WidgetsBinding.instance.addPostFrameCallback((_) {
                            setState(() {
                              if (jamMulai.text != state.startDate.toString()) {
                                jamMulai.text = DateFormat('dd-MM-yyyy HH:mm')
                                    .format(state.startDate);
                                      jamMulaiDisplay.text = DateFormat('dd MMMM yyyy HH:mm', redaksional.bahasa  == 'en' ?'en_US':'id_ID')
                                    .format(state.startDate);
                              }
                              if (state.endDate != null &&
                                  jamSelesai.text != state.endDate.toString()) {
                                jamSelesai.text = DateFormat('dd-MM-yyyy HH:mm')
                                    .format(state.endDate!);
                                         jamSelesaiDisplay.text = DateFormat('dd MMMM yyyy HH:mm', redaksional.bahasa  == 'en' ?'en_US':'id_ID')
                                    .format(state.endDate!);
                              }
                              final dateFormat = DateFormat('dd-MM-yyyy HH:mm');
                              DateTime mulai = dateFormat.parse(jamMulai.text);
                              DateTime selesai = dateFormat.parse(jamSelesai.text);
                              Duration selisih = selesai.difference(mulai);
                              selisihJam = selisih.inHours;
                              selisihMenit = selisih.inMinutes.remainder(60);
                              selisihDetik = selisih.inSeconds.remainder(60);
                            });
                          });
                          return Column(
                            children: [
                              Row(
                                children: [
                                  Text(
                                    '${redaksional.data!.lemburMulai!} ',
                                    style: TextStyle(
                                      fontSize: 14.0,
                                      fontWeight: FontWeight.w500,
                                    ),
                                  ),
                                  Text(
                                    ' *',
                                    style: TextStyle(
                                        fontSize: 14.0,
                                        fontWeight: FontWeight.w500,
                                        color: Colors.red),
                                  ),
                                ],
                              ),
                              SizedBox(height: 8.0),
                              GestureDetector(
                                onTap: () {
                                  DateFormat format =
                                      DateFormat('dd-MM-yyyy HH:mm');
                                  cupertinoPicker(context, true,
                                          format.parse(jamMulai.text),bahasa: redaksional.bahasa!,initialDateTimeEnd:format.parse(jamSelesai.text));
                                },
                                child: AbsorbPointer(
                                  child: TextFormField(
                                    controller: jamMulaiDisplay,
                                    decoration: InputDecoration(
                                      border: OutlineInputBorder(
                                        borderRadius:
                                            BorderRadius.circular(8.0),
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                              SizedBox(height: 24.0),
                              Column(
                                children: [
                                  Row(
                                    children: [
                                      Text(
                                      '${redaksional.data!.lemburSelesai!} ',
                                        style: TextStyle(
                                          fontSize: 14.0,
                                          fontWeight: FontWeight.w500,
                                        ),
                                      ),
                                      Text(
                                        ' *',
                                        style: TextStyle(
                                            fontSize: 14.0,
                                            fontWeight: FontWeight.w500,
                                            color: Colors.red),
                                      ),
                                    ],
                                  ),
                                  SizedBox(
                                    height: 8,
                                  ),
                                  GestureDetector(
                                    onTap: () {
                                      DateFormat format =
                                          DateFormat('dd-MM-yyyy HH:mm');
                                      cupertinoPicker(context, false,
                                          format.parse(jamMulai.text),bahasa: redaksional.bahasa!,initialDateTimeEnd:format.parse(jamSelesai.text));
                                    },
                                    child: AbsorbPointer(
                                      child: TextFormField(
                                        controller: jamSelesaiDisplay,
                                        decoration: InputDecoration(
                                          border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(8.0),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ],
                          );
                        } else
                          return Container();
                      }),
                      SizedBox(height: 16.0),
                    ],
                  ),
                  SizedBox(height: 24.0),
                  TemplateButton(
                    label: "Submit",
                    heightButton: 45,
                    fontSize: 15,
                    color: CustomStyle.color1,
                    widthButton: MediaQuery.of(context).size.width - 20,
                    onClick: () {
                      DateFormat inputFormat = DateFormat('dd-MM-yyyy HH:mm');
                      DateTime parsedDateMulai =
                          inputFormat.parse(jamMulai.text);
                      DateTime parsedDateSelesai =
                          inputFormat.parse(jamSelesai.text);

                      DateFormat outputFormat = DateFormat('yyyy-MM-dd HH:mm');
                      String mulai = outputFormat.format(parsedDateMulai);
                      String selesai = outputFormat.format(parsedDateSelesai);
                      if (parsedDateMulai.isAfter(parsedDateSelesai)) {
                        CustomSnackBar.show(contextA,
                                            redaksional.messageKonfirmasi!.waktu!,
                                            SnackBarType
                                                .warning);
                      } else {
                        TemplateConfirmationDialog(
                          buttonApvHrd
                            ? redaksional.messageKonfirmasi!.setujuiSemua!
                            : redaksional.messageKonfirmasi!.setujui!,
                          () => buttonApvHrd
                              ? BlocProvider.of<LemburPegawaiBloc>(contextA)
                                  .add(MewakiliSetujuiLembur(idLembur, contextA,
                                      scaffoldKey, 'editDetail'))
                              : BlocProvider.of<LemburPegawaiBloc>(contextA)
                                  .add(setujuiLembur(
                                  idLembur,
                                  contextA,
                                  scaffoldKey,
                                  'editDetail',
                                  mulai: mulai,
                                  selesai: selesai,
                                )),
                          contextA,bahasa: redaksional.bahasa!);
                      }
                    },
                  ),
                ],
              ),
            ),
          ),
        );
      });
    },
  );
}

void cupertinoPicker(
    BuildContext context, bool isStartDate, DateTime initialDateTime,
    {DateTime? initialDateTimeEnd, required String bahasa}) {
  final currentState = BlocProvider.of<DatePickBloc>(context).state;
  if (currentState is DateSelected) {
    initialDateTime = currentState.startDate;
  }
  showModalBottomSheet(
    context: context,
    shape: RoundedRectangleBorder(
      borderRadius: BorderRadius.vertical(top: Radius.circular(20)),
    ),
    isScrollControlled: true,
    builder: (context) {
      DateTime selectedDateTime = initialDateTime;
      return Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Container(
            height: 5,
            width: 50,
            margin: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
            decoration: BoxDecoration(
                color: Colors.grey, borderRadius: BorderRadius.circular(10)),
          ),
          Divider(),
          SizedBox(
            height: 300,
            child: CustomCupertinoDateTimePicker(
              itemExtent: 50,
              minDate: isStartDate 
                  ? DateTime(initialDateTime.year, initialDateTime.month,initialDateTime.day, 0, 0)
                  : DateTime(initialDateTime.year, initialDateTime.month,
                  initialDateTime.day, initialDateTime.hour, initialDateTime.minute),
              maxDate: isStartDate
                        ? (initialDateTimeEnd != null
                            ? (initialDateTimeEnd.difference(initialDateTime).inDays >= 1
                                ? DateTime(initialDateTime.year, initialDateTime.month, initialDateTime.day, 23, 59)
                                : initialDateTimeEnd)
                            : DateTime(initialDateTime.year, initialDateTime.month, initialDateTime.day, 23, 59))
                        : (initialDateTimeEnd != null
                            ? DateTime(initialDateTime.year, initialDateTime.month, initialDateTime.day + 1, 23, 59)
                            : DateTime(initialDateTime.year, initialDateTime.month, initialDateTime.day + 1, 23, 59)),
              selectedDate: isStartDate
                  ? initialDateTime
                  : (initialDateTimeEnd != null && initialDateTimeEnd.isAfter(initialDateTime)
                      ? initialDateTimeEnd
                      : initialDateTime),
              diameterRatio: 4.0,
              magnification: 0.9,
              bahasa: bahasa,
              selectionOverlay: Container(
                width: double.infinity,
                height: 50,
                decoration: const BoxDecoration(
                  border: Border.symmetric(
                    horizontal: BorderSide(color: Colors.grey, width: 1),
                  ),
                ),
              ),
              selectedStyle: const TextStyle(
                color: Colors.blue,
                fontWeight: FontWeight.w600,
                fontSize: 24,
              ),
              unselectedStyle: TextStyle(
                color: Colors.black,
                fontWeight: FontWeight.w600,
                fontSize: 18,
              ),
              disabledStyle: TextStyle(
                color: Colors.grey[500],
                fontSize: 18,
              ),
              onSelectedItemChanged: (date) {
                selectedDateTime = date;
              },
            ),
          ),
          Divider(),
          Container(
            width: MediaQuery.sizeOf(context).width,
            margin: EdgeInsets.all(10),
            child: TemplateButton(
              label: "Terapkan",
              heightButton: 45,
              fontSize: 15,
              color: CustomStyle.color1,
              widthButton: MediaQuery.of(context).size.width - 20,
              onClick: () {
                if (isStartDate) {
                    BlocProvider.of<DatePickBloc>(context)
                      .add(PickStartDateEvent(selectedDateTime));
                } else {
                  BlocProvider.of<DatePickBloc>(context)
                      .add(PickEndDateEvent(selectedDateTime));
                }
                Navigator.pop(context);
              },
            ),
          )
        ],
      );
    },
  );
}

