import 'package:flutter/material.dart';

class KPIItem extends StatelessWidget {
  final String title;
  final String subtitle;
  final String icon;
  final int badge;
  final VoidCallback onTap;
  KPIItem(
      {required this.title,
      required this.subtitle,
      required this.icon,
      required this.badge,
      required this.onTap});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.all(16.0),
        margin: EdgeInsets.symmetric(horizontal: 15.0, vertical: 10),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8.0),
          boxShadow: [
            BoxShadow(
              color: Colors.grey.withOpacity(0.2),
              spreadRadius: 2,
              blurRadius: 5,
              offset: Offset(0, 3),
            ),
          ],
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Row(
              children: [
                Image.asset(
                  "$icon",
                  fit: BoxFit.cover,
                  height: 40,
                ),
                // Icon(Icons.assignment, color: Colors.blue),
                SizedBox(width: 8.0),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      title,
                      style: TextStyle(
                        fontSize: 16.0,
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                    Text(
                      subtitle,
                      style: TextStyle(
                        fontSize: 12.0,
                        color: Colors.grey,
                      ),
                    ),
                  ],
                ),
              ],
            ),
            Row(
              children: [
                badge != 0
                    ? Chip(
                        label: Text(
                          badge.toString(),
                          style: TextStyle(color: Colors.white),
                        ),
                        backgroundColor: Colors.red,
                        padding: EdgeInsets.all(2.0),
                      )
                    : Container(),
                Icon(Icons.arrow_forward_ios, color: Colors.grey),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
