// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/HalamanKpiDraftTeam.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/HalamanKpiTeam.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/Bloc/date_pick_bloc.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/CustomCupertinoDatePicker.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTabKpiTeam extends StatefulWidget {
  const ParentTabKpiTeam({Key? key}) : super(key: key);

  @override
  State<ParentTabKpiTeam> createState() => _ParentTabKpiTeamState();
}

class _ParentTabKpiTeamState extends State<ParentTabKpiTeam> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();

  int tabLength = 2;
  @override
  void initState() {
    BlocProvider.of<DatePickBloc>(context).add(ClearDatesEvent());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return DefaultTabController(
        length: tabLength,
        child: Scaffold(
            appBar: AppBar(
              centerTitle: true,
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
              title: Text(
                'KPI Team',
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
            ),
            body: Padding(
              padding: const EdgeInsets.only(top: 5),
              child: Column(
                children: [
                  Material(
                    child: Container(
                      height: 40,
                      child: TabBar(
                        padding: EdgeInsets.symmetric(horizontal: 2),
                        unselectedLabelColor: CustomStyle.color1,
                        labelPadding: EdgeInsets.symmetric(vertical: 0, horizontal: 3),
                        labelColor: Colors.white,
                        indicatorSize: TabBarIndicatorSize.tab,
                        indicator: BoxDecoration(
                          borderRadius: BorderRadius.circular(8),
                          color: CustomStyle.color1,
                        ),
                        tabs: [
                          _buildTab("Draft KPI"),
                          _buildTab("KPI Team"),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    child: TabBarView(
                      // physics: NeverScrollableScrollPhysics(),
                      children: [
                        HalamanKpiDraftTeam(),
                        HalamanKpiTeam()
                      ],
                    ),
                  ),
                ],
              ),
            )));
  }
  Widget _buildTab(String label) {
    return Container(
      height: 35,
      padding: EdgeInsets.symmetric(horizontal: 8, vertical: 3),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        border: Border.all(color: CustomStyle.color1, width: 0.8),
      ),
      child: Align(
        alignment: Alignment.center,
        child: Text(
          label,
          style: TextStyle(
            fontSize: MediaQuery.of(context).size.width > 600 ? 14 : 12,
          ),
        ),
      ),
    );
  }
}
