// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/Kpi/KpiSaya/GetListKpiSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/komponen/Komponenplaning.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/Bloc/date_pick_bloc.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/TemplateMonthYearPicker.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListPengajuanKpiSaya extends StatefulWidget {
  const HalamanListPengajuanKpiSaya({Key? key}) : super(key: key);

  @override
  State<HalamanListPengajuanKpiSaya> createState() =>
      _HalamanListPengajuanKpiSayaState();
}

class _HalamanListPengajuanKpiSayaState
    extends State<HalamanListPengajuanKpiSaya> {
  @override
  void initState() {
    BlocProvider.of<DatePickBloc>(context)
        .add(PickStartDateEvent(DateTime.now()));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        BlocBuilder<GetListKpiPengajuanSayaBloc, DataListKpiSayaState>(
            builder: (BuildContext context, DataListKpiSayaState state) {
          if (state is GetListKpiPengajuanSayaSuccessState)
            return Stack(
              children: <Widget>[
                ListView.builder(
                    physics: AlwaysScrollableScrollPhysics(),
                    // controller: _scrollController,
                    itemCount: state.data!.length,
                    itemBuilder: (BuildContext context, index) {
                      return CardListKpiPlanning(
                          state.data![index], 'pengajuan');
                    }),
              ],
            );
          else if (state is DataListKpiSayaProgressState)
            return Center(
              child: CircularProgressIndicator(
                strokeWidth: 8,
              ),
            );
          else
            return Center(
              child: Image.asset(
                ValueImage.noData,
                height: 250,
              ),
            );
        }),
        Positioned(
          bottom: 16,
          right: 14,
          child: BlocListener<DatePickBloc, DatePickState>(
              listener: (BuildContext context, DatePickState state) {
                if (state is DateSelected) {
                  BlocProvider.of<GetListKpiPengajuanSayaBloc>(context).add(
                      GetDataListKpiPengajuanSaya(ModelFilterKpi(
                          status: '1,8', monthYear: state.startDate)));
                }
              },
              child: TemplateMonthYearPicker()),
        ),
      ],
    );
  }
}
